#include <stdio.h>
#include <gtk/gtk.h>

#include "../config.h"

#include "defines.h"
#include "gtk_gui.h"
#include "debconf.h"
#include "files.h"
#include "config.h"
#include "cbs.h"

extern GtkWidget *main_window;

/*
  This is mostly a callback to run_config
*/
void 
configure_cb (GtkWidget *w, gpointer data)
{
  GtkWidget *entry = (GtkWidget*)data;
  gchar *cf;

  cf = gtk_entry_get_text (GTK_ENTRY(entry));

  run_config (cf);
}


void 
about_cb (GtkWidget *w, gpointer data)
{
  char msg[1024];

  sprintf (msg, 
	   _("GkDebconf %s\n\n"
	     "This program is intended for those who are not\n"
	     "used to the Debian packaging system and don't\n"
	     "know how to find what packages can be reconfigured\n"
	     "and how to reconfigure them.\n\n"
	     "I'd like to dedicate this simple program to my\n"
	     "good and complex ;) friends from #debian-br@OPN\n"
	     "for helping me so much in many things.\n\n"
	     "Thanks to Ricardo Sandrin <rsandrin@cipsga.org.br>\n"
	     "(aka strange) for the cool splash screen of this\n"
	     "version.\n\n"
	     "Author: Gustavo Noronha Silva <kov@debian.org>\n"),
	   VERSION);

  show_about_window (msg, "gkdebconf-splash.xpm");
}

void
remember_fe_cb (gpointer data, guint action, GtkWidget *w )
{
  if (GTK_CHECK_MENU_ITEM(w)->active)
    write_config ("remember_frontend", "yes");
  else
    write_config ("remember_frontend", "no");
}
