/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"
#include "ginspector-ui.h"

#include "glrr-gobject.h"
#include "glrr-gtk.h"

#include "misc-utils.h"



static void builtin_module_init (void);

static gpointer create_window_child_property_editor (gpointer data,
						     gpointer func_data,
						     gpointer invoke_data);



void
g_inspector_builtin_register_module_window_child_property_editor (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-window-child-property-editor";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("edit-children-properties",
				  "Edit Children Properties",
                                  G_INSPECTOR_PROCEDURE_TYPE_WINDOW,
                                  G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE,
				  GTK_TYPE_CONTAINER,
				  create_window_child_property_editor,
                                  NULL);
}



static gpointer create_panel_child_property_editor (gpointer data,
						    gpointer func_data,
						    gpointer invoke_data);
static void     selection_changed                  (GtkTreeSelection      *selection,
						    gpointer               user_data);
static void     element_list_update                (GInspectorElementList *element_list,
						    gpointer               user_data);
static void     select_top                         (GInspectorElementList *element_list);


static gpointer
create_window_child_property_editor (gpointer data,
				     gpointer func_data,
				     gpointer invoke_data)
{
  GtkContainer *container;

  GtkWidget *top;
  GtkWidget *window;
  GtkWidget *w;


  container = GTK_CONTAINER (data);


  window = g_inspector_window_new ();
  top = window;

  {
    gchar *widget_name;
    gchar *window_title;

    widget_name = gtk_widget_get_name_or_null (GTK_WIDGET (container));
    window_title = ((widget_name != NULL)
                  ? g_strdup_printf ("Child Property Editor: %s: %s",
                                     g_get_prgname (), widget_name)
                  : g_strdup_printf ("Child Property Editor: %s: %p",
                                     g_get_prgname (), container));

    gtk_window_set_title (GTK_WINDOW (window), window_title);
    g_free (window_title);
  }

  gtk_window_set_default_size (GTK_WINDOW (window), 400, 300);


  w = create_panel_child_property_editor (container,
					  NULL,
					  NULL);


  gtk_container_add (GTK_CONTAINER (window), w);


  gtk_widget_show_all (top);



  {
    g_object_weak_xref (G_OBJECT (container), (GWeakNotify)gtk_widget_destroy,
			G_OBJECT (top),       NULL);
  }


  return top;
}


static gpointer
create_panel_child_property_editor (gpointer data,
				    gpointer func_data,
				    gpointer invoke_data)
{
  GtkContainer *container;

  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *vbox;

  container = GTK_CONTAINER (data);


  {
    panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
			  NULL);

    G_INSPECTOR_PANEL (panel)->element_type = G_INSPECTOR_ELEMENT_TYPE_GTYPEINSTANCE;
    G_INSPECTOR_PANEL (panel)->element = container;

    top = panel;
  }

#if 0
  {
    g_object_weak_xref (container, gtk_widget_destroy,
			top,       NULL);
  }
#endif

  {
    vbox = gtk_vbox_new (FALSE, 0);
    gtk_widget_set_name (vbox, "vbox");

    gtk_container_add (GTK_CONTAINER (panel), vbox);
  }

  {
    GtkWidget *w;
    GtkWidget *element_list;

    w = g_inspector_invoke_procedure_by_name ("create-panel-child-list",
					      container,
					      NULL);

    element_list = gtk_container_find_descendant_by_name (GTK_CONTAINER (w),
							  "element-list");

    {
      GtkTreeSelection *selection;

      selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (element_list));

      g_signal_connect (selection,
			"changed",
			G_CALLBACK (selection_changed),
			panel);
    }

    {
      g_signal_connect (element_list,
			"update",
			G_CALLBACK (element_list_update),
			NULL);
    }

    select_top (G_INSPECTOR_ELEMENT_LIST (element_list));

    gtk_box_pack_start (GTK_BOX (vbox),
			w, TRUE, TRUE, 0);
  }

  gtk_box_pack_start (GTK_BOX (vbox), gtk_hseparator_new (), FALSE, FALSE, 0);



  gtk_widget_show_all (top);


  return top;
}

/***/

static GtkWidget *
create_editor_widgets (GtkWidget *child)
{
  GtkWidget *top;
  GtkWidget *frame;
  GtkWidget *vbox;

  frame = gtk_frame_new ("Child Properties");
  top = frame;

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox);

  {
    GtkContainer *container;
    GParamSpec **properties;
    guint n_properties;

    container = GTK_CONTAINER (GTK_WIDGET (child)->parent);

    {
      GObjectClass *object_class;


      object_class = g_type_class_ref (G_OBJECT_TYPE (container));

      properties = gtk_container_class_list_child_properties (object_class,
							      &n_properties);

      g_type_class_unref (object_class);
    }


    {
      GParamSpec *spec;
      GtkSizeGroup *size_group;
      guint i;

      size_group = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);

      for (i = 0; i < n_properties; ++i)
	{
	  spec = properties[i];

	  {
	    GtkWidget *hbox;
	    GtkWidget *label;
	    GtkWidget *w;

	    hbox = gtk_hbox_new (FALSE, 0);
	    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
          

	    label = gtk_label_new (spec->name);
	    gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
	    gtk_size_group_add_widget (size_group, label);
	    gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

	    w = g_inspector_create_child_property_editor (G_OBJECT (child), spec);

	    if (w != NULL)
	      {
		gtk_box_pack_start (GTK_BOX (hbox), w, TRUE, TRUE, 0);
	      }
	  }
	}

      if (size_group->widgets == NULL)
	{
	  g_object_unref (size_group);
	}
    }

  }

  gtk_widget_set_name (top, "editor");

  return top;
}

static void
select_child (GInspectorPanel *panel,
	      GtkWidget       *child)
{
  {
    GtkWidget *editor;
    
    editor = gtk_container_find_descendant_by_name (GTK_CONTAINER (panel), "editor");

    if (editor != NULL)
      {
	gtk_widget_destroy (editor);
      }
  }


  if (child != NULL)
    {
      GtkWidget *vbox;
      GtkWidget *w;

      vbox = gtk_container_find_descendant_by_name (GTK_CONTAINER (panel), "vbox");

      w = create_editor_widgets (child);

      gtk_widget_show_all (w);

      gtk_box_pack_end (GTK_BOX (vbox), w, FALSE, FALSE, 0);
    }
  else
    {
    }
}

static void
selection_changed (GtkTreeSelection *selection,
		   gpointer          user_data)
{
  GInspectorPanel *panel;
  gboolean r;
  GtkTreeIter tree_iter;


  panel = G_INSPECTOR_PANEL (user_data);


  r = gtk_tree_selection_get_selected (selection, NULL, &tree_iter);

  if (r == TRUE)
    {
      GtkWidget *child;

      {
	GtkTreeView *tree_view;
	GtkTreeModel *tree_model;
	GTypeInstance *instance;

	tree_view = gtk_tree_selection_get_tree_view (selection);
	tree_model = gtk_tree_view_get_model (tree_view);
	gtk_tree_model_get (tree_model,
			    &tree_iter,
			    1, &instance,
			    -1);

	child = GTK_WIDGET (instance);
      }


      select_child (panel, child);
    }
  else
    {
      select_child (panel, NULL);
    }
}


static void
element_list_update (GInspectorElementList *element_list,
		     gpointer               user_data)
{
  select_top (element_list);
}

static void
select_top (GInspectorElementList *element_list)
{
  gboolean r;
  GtkTreeIter tree_iter;

  r = gtk_tree_model_get_iter_first (gtk_tree_view_get_model (GTK_TREE_VIEW (element_list)),
				     &tree_iter);

  if (r == TRUE)
    {
      GtkTreeSelection *selection;

      selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (element_list));

      gtk_tree_selection_select_iter (selection, &tree_iter);
    }
}
