#!/bin/sh

out_h="_register-builtin-modules.h"
out_c="_register-builtin-modules.c"

files="$@"


echo_pre_h()
{
cat <<EOF
#ifndef ___REGISTER_BUILTIN_MODULES_H__
#define ___REGISTER_BUILTIN_MODULES_H__


G_BEGIN_DECLS



static void _register_builtin_modules (void);


EOF
}

echo_post_h()
{
cat <<EOF



G_END_DECLS


#endif /* ___REGISTER_BUILTIN_MODULES_H__ */
EOF
}

echo_pre_c()
{
cat <<EOF
#include <glib.h>

#include "_register-builtin-modules.h"

static void
_register_builtin_modules (void)
{
EOF
}

echo_post_c()
{
cat <<EOF
}
EOF
}

cat /dev/null >  $out_h
cat /dev/null >  $out_c

echo_pre_h    >> $out_h
echo_pre_c    >> $out_c

for f in $files; do
  i=`grep "g_inspector_builtin_register_module_[_a-z]*" $f | sed -e "s/.*\(g_inspector_builtin_register_module[_a-z]*\).*/\1/"`
  if [ X"$i" != X"" ]; then
    echo "void $i (void);" >> $out_h
    echo "  $i ();"        >> $out_c
  fi
done

echo_post_h  >> $out_h
echo_post_c  >> $out_c
