/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "misc-utils.h"




static GEnumClass *
g_enum_class_ref (GType enum_type)
{
  GEnumClass *enum_class;

  enum_class = g_type_class_ref (enum_type);

  return enum_class;
}

static void
g_enum_class_unref (GEnumClass *enum_class)
{
  g_type_class_unref (enum_class);
}

static GFlagsClass *
g_flags_class_ref (GType flags_type)
{
  GFlagsClass *flags_class;

  flags_class = g_type_class_ref (flags_type);

  return flags_class;
}

static void
g_flags_class_unref (GFlagsClass *flags_class)
{
  g_type_class_unref (flags_class);
}

gchar *
g_type_enum_get_value_name (GType enum_type,
			    gint  value)
{
  GEnumClass *enum_class;
  GEnumValue *enum_values;
  guint       n_enum_values;
  gchar      *name;
  guint i;

  
  g_return_val_if_fail (G_TYPE_IS_ENUM (enum_type), NULL);


  enum_class = g_enum_class_ref (enum_type);

  enum_values   = enum_class->values;
  n_enum_values = enum_class->n_values;


  name = NULL;
  for (i = 0; i < n_enum_values; ++i)
    {
      if (enum_values[i].value == value)
	{
	  name = enum_values[i].value_name;
	  break;
	}
    }

  g_enum_class_unref (enum_class);

  return name;
}

gchar *
g_type_enum_get_value_nick (GType enum_type,
			    gint  value)
{
  GEnumClass *enum_class;
  GEnumValue *enum_values;
  guint       n_enum_values;
  gchar      *nick;
  guint i;


  g_return_val_if_fail (G_TYPE_IS_ENUM (enum_type), NULL);


  enum_class = g_enum_class_ref (enum_type);

  enum_values   = enum_class->values;
  n_enum_values = enum_class->n_values;


  nick = NULL;
  for (i = 0; i < n_enum_values; ++i)
    {
      if (enum_values[i].value == value)
	{
	  nick = enum_values[i].value_nick;
	  break;
	}
    }

  g_enum_class_unref (enum_class);

  return nick;
}

gchar *
g_type_flags_get_value_name (GType flags_type,
			     guint value)
{
  GFlagsClass *flags_class;
  GFlagsValue *flags_values;
  guint        n_flags_values;
  gchar       *name;
  guint i;

  
  g_return_val_if_fail (G_TYPE_IS_FLAGS (flags_type), NULL);


  flags_class = g_flags_class_ref (flags_type);

  flags_values   = flags_class->values;
  n_flags_values = flags_class->n_values;


  name = NULL;
  for (i = 0; i < n_flags_values; ++i)
    {
      if (flags_values[i].value == value)
	{
	  name = flags_values[i].value_name;
	  break;
	}
    }

  g_flags_class_unref (flags_class);

  return name;
}

gchar *
g_type_flags_get_value_nick (GType flags_type,
			     guint value)
{
  GFlagsClass *flags_class;
  GFlagsValue *flags_values;
  guint       n_flags_values;
  gchar      *nick;
  guint i;

  
  g_return_val_if_fail (G_TYPE_IS_FLAGS (flags_type), NULL);


  flags_class = g_flags_class_ref (flags_type);

  flags_values   = flags_class->values;
  n_flags_values = flags_class->n_values;


  nick = NULL;
  for (i = 0; i < n_flags_values; ++i)
    {
      if (flags_values[i].value == value)
	{
	  nick = flags_values[i].value_nick;
	  break;
	}
    }

  g_flags_class_unref (flags_class);

  return nick;
}

gchar*
g_type_flags_string (GType flags_type,
		     guint value)
{
  GFlagsClass *flags_class;
  GFlagsValue *flags_values;
  guint        n_flags_values;
  gchar        *str[sizeof(guint)*8 + 1];
  guint n;
  guint i;


  g_return_val_if_fail (G_TYPE_IS_FLAGS (flags_type), NULL);


  flags_class = g_flags_class_ref (flags_type);

  flags_values = flags_class->values;
  n_flags_values = flags_class->n_values;


  n = 0;

  for (i = 0; i < n_flags_values; ++i) {
      if (value & flags_values[i].value)
	{
	  str[n] = flags_values[i].value_nick;
	  ++n;
	}
    }

  str[n] = NULL;

  g_flags_class_unref (flags_class);


  return g_strjoinv (", ", str);
}

gchar *
g_param_flags_string (guint value)
{
  struct {
    guint flag;
    gchar *name;
  } param_flags[] = {
    { G_PARAM_READABLE,		"readable" },
    { G_PARAM_WRITABLE,		"writable" },
    { G_PARAM_CONSTRUCT,	"construct" },
    { G_PARAM_CONSTRUCT_ONLY,	"construct_only" },
    { G_PARAM_LAX_VALIDATION,	"lax_validation" },
    { G_PARAM_PRIVATE,		"private" }
  };
  int n_param_flags = G_N_ELEMENTS (param_flags);
  gchar *str[sizeof(guint) * 8 + 1];
  int n;
  int i;

  n = 0;
  
  for (i = 0; i < n_param_flags; ++i)
    {
      if (value & param_flags[i].flag)
	{
	  str[n] = param_flags[i].name;
	  ++n;
	}
    }

  str[n] = NULL;


  return g_strjoinv (", ", str);
}

gchar *
g_signal_flags_string (guint value)
{
  struct {
    guint flag;
    gchar *name;
  } signal_flags[] = {
    { G_SIGNAL_RUN_FIRST,	"run_first" },
    { G_SIGNAL_RUN_LAST,	"run_last" },
    { G_SIGNAL_RUN_CLEANUP,	"run_cleanup" },
    { G_SIGNAL_NO_RECURSE,	"no_recurse" },
    { G_SIGNAL_DETAILED,	"detailed" },
    { G_SIGNAL_ACTION,		"action" },
    { G_SIGNAL_NO_HOOKS,	"no_hooks" }
  };
  int n_signal_flags = G_N_ELEMENTS (signal_flags);
  gchar *str[sizeof(guint) * 8 + 1];
  int n;
  int i;

  n = 0;
  
  for (i = 0; i < n_signal_flags; ++i)
    {
      if (value & signal_flags[i].flag)
	{
	  str[n] = signal_flags[i].name;
	  ++n;
	}
    }

  str[n] = NULL;


  return g_strjoinv (", ", str);
}

gchar *
g_value_to_string (GValue *value)
{
  gchar *str;


  switch (G_TYPE_FUNDAMENTAL(G_VALUE_TYPE (value)))
    {
    case G_TYPE_CHAR:
      str = g_strdup_printf ("%d", g_value_get_char(value));
      break;

    case G_TYPE_UCHAR:
      str = g_strdup_printf ("%u", g_value_get_uchar(value));
      break;

    case G_TYPE_BOOLEAN:
      str = g_strdup (g_value_get_boolean(value)
		      ? "true"
		      : "false");
      break;

    case G_TYPE_INT:
      str = g_strdup_printf ("%d", g_value_get_int(value));
      break;

    case G_TYPE_UINT:
      str = g_strdup_printf ("%u", g_value_get_uint(value));
      break;

    case G_TYPE_LONG:
      str = g_strdup_printf ("%ld", g_value_get_long (value));
      break;

    case G_TYPE_ULONG:
      str = g_strdup_printf ("%lu", g_value_get_ulong (value));
      break;

    case G_TYPE_INT64:
      str = g_strdup_printf ("%" G_GINT64_FORMAT, g_value_get_int64(value));
      break;

    case G_TYPE_UINT64:
      str = g_strdup_printf ("%" G_GUINT64_FORMAT, g_value_get_uint64(value));
      break;

    case G_TYPE_ENUM:
      str = g_strdup (g_type_enum_get_value_nick (G_VALUE_TYPE (value),
						  g_value_get_enum(value)));
      break;

    case G_TYPE_FLAGS:
      str = g_type_flags_string (G_VALUE_TYPE (value),
				 g_value_get_flags(value));
      break;

    case G_TYPE_FLOAT:
      str = g_strdup_printf ("%f", g_value_get_float(value));
      break;

    case G_TYPE_DOUBLE:
      str = g_strdup_printf ("%f", g_value_get_double(value));
      break;

    case G_TYPE_STRING:
      str = g_strdup_printf ("%s", g_value_get_string(value));
      break;

    case G_TYPE_POINTER:
      str = g_strdup_printf ("%p", g_value_get_pointer(value));
      break;

    case G_TYPE_BOXED:
      str = g_strdup_printf ("%p", g_value_get_boxed(value));
      break;

    case G_TYPE_PARAM:
      str = g_strdup_printf ("%p", g_value_get_param(value));
      break;

    case G_TYPE_OBJECT:
      str = g_strdup_printf ("%p", g_value_get_object(value));

    default:
      str = NULL;
      break;
    }


  return str;
}
