/*
 *  
 *  $Id: contenedorherramientas.cpp 3558 2011-03-20 20:02:22Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <api/globals.h>
#include "contenedorherramientas.h"
#include <iostream>
namespace GNKVisualizator{
	namespace GUI{
		ContenedorHerramientas::ContenedorHerramientas(wxWindow* pPadre) : wxControl(pPadre, -1, wxDefaultPosition, wxDefaultSize)//wxScrolledWindow(pPadre, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxVSCROLL|wxHSCROLL)
		{
			Hide();
			GTRACE(">> ContenedorHerramientas::ContenedorHerramientas() " << this)
			SetMinSize(wxSize(300, -1));
			Connect(wxEVT_SIZE, wxSizeEventHandler(ContenedorHerramientas::OnSize));
			m_pSizer = new wxBoxSizer(wxVERTICAL);
			this->SetSizer(m_pSizer);
			m_pSizer->Fit(this);
			Layout();
			GTRACE("<< ContenedorHerramientas::ContenedorHerramientas() " << this)
		}

		ContenedorHerramientas::~ContenedorHerramientas()
		{
			 GTRACE(">> ContenedorHerramientas::~ContenedorHerramientas() " << this)
			 Disconnect(wxEVT_SIZE, wxSizeEventHandler(ContenedorHerramientas::OnSize));
			 GTRACE("<< ContenedorHerramientas::~ContenedorHerramientas() " << this)
		}

		void ContenedorHerramientas::InsertarPanel(wxWindow* child)
		{
			GTRACE("Panel insertado: " << child)
			m_pSizer->Add(child, 1, wxEXPAND, 0);
			Layout();
		}

		void ContenedorHerramientas::EliminarPanel(wxWindow* child)
		{
			m_pSizer->Detach(child);
			Layout();
		}

		void ContenedorHerramientas::OnSize(wxSizeEvent& WXUNUSED(event))
		{
			GTRACE("<< ContenedorHerramientas::OnResize() " << this)
			Layout();
			GTRACE(">> ContenedorHerramientas::OnResize() " << this)
		}

		void ContenedorHerramientas::ActualizarVirtualSize() {
			GTRACE("<< ContenedorHerramientas::OnResize() " << this)
			Layout();
			GTRACE(">> ContenedorHerramientas::OnResize() " << this)
		}
	}
}
