/*
 *  
 *  $Id: herramientalupa.h 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include <map>

#include <api/globals.h>
#include <api/icontroladoreventos.h>
#include <api/api.h>

#include <export/iherramientalupa.h>
#include <widgets/wlupa.h>

class IconoHerramientaCtrl;
class HerramientaOpcionesGUIBase;

namespace GNC {

	typedef enum ModoZoom {
		MZ_In,
		MZ_Out
	} ModoZoom;

	namespace GUI {
		class HerramientaOpcionesLupaGUI;
	}

	class EXTAPI HerramientaLupa : public GNC::GCS::IHerramientaLupa, public GNC::GCS::IObservador {

	public:

		HerramientaLupa();
		~HerramientaLupa();

		//region "Realización de la interfaz IHerramienta"

		// Eventos refinados desde los paneles
		virtual void SetModo(ModoZoom modo);

		// Setup de paneles
		virtual void CrearPaneles( wxPanel* panel );
		
		//endregion

		virtual void ConectarContratoFalso(bool activar);
		virtual void SetVistaActiva(GNC::GCS::IVista* pVista);
		virtual void ConectarContratos(bool activar);
		virtual void PreProcesarEvento(GNC::GCS::Eventos::IEvento *evt, GNC::GCS::IControladorEventos::TipoListaPunterosEventos& lista);
		virtual void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt);

	protected:

		GNC::GCS::Widgets::WLupaBuilder*         m_pLupaBuilder;

	};
}
