/*
 *  
 *  $Id: dicommoveassociation.h 4424 2011-11-18 12:24:36Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *  Code adapted from Aeskulap
 *
 */
#pragma once
#include <ctime>

#include "dicomfindassociation.h"
#include "istorecallback.h"

class MoveAssociation : public FindAssociation {
public:

	static std::string m_errorMessage;
    MoveAssociation(const std::string& ambitolog, IModeloDicom* pModelo=NULL);
    virtual ~MoveAssociation();
	
	 
	 void SetModelo(IModeloDicom* pModelo);

    void Create(const std::string& title, const std::string& peer, int port, const std::string& ouraet, /*int ourPort,*/ const char *abstractSyntax = UID_MOVEStudyRootQueryRetrieveInformationModel);
	
    CONDITION SendObject(DcmDataset *dataset);
	
    void SetCallbackHandler(IStoreCallBack* handler);
	
protected:
	
    void OnAddPresentationContext(T_ASC_Parameters *params);
	
    virtual void OnFileReceived(const std::string& fileName, DcmDataset* dataSet);
	
    int m_maxReceivePDULength;
	
private:
	
    typedef struct _MoveCallbackInfo {
		T_ASC_Association *assoc;
		T_ASC_PresentationContextID presId;
		MoveAssociation* pCaller;
    } MoveCallbackInfo;
	
    typedef struct _StoreCallbackInfo {
		MoveAssociation* pCaller;
		T_ASC_Association* assoc;
		std::clock_t lastTick;
		
    } StoreCallbackInfo;
	
    CONDITION moveSCU(DcmDataset *pdset);
    static void moveCallback(void *callbackData, T_DIMSE_C_MoveRQ *request, int responseCount, T_DIMSE_C_MoveRSP *response);
	
    CONDITION acceptSubAssoc(T_ASC_Network *aNet, T_ASC_Association **assoc);
    CONDITION subOpSCP(T_ASC_Association **subAssoc);
    static void subOpCallback(void * pCaller, T_ASC_Network *aNet, T_ASC_Association **subAssoc);
	
    CONDITION storeSCP(T_ASC_Association *assoc, T_DIMSE_Message *msg, T_ASC_PresentationContextID presID);
    static void storeSCPCallback(void *callbackData, T_DIMSE_StoreProgress *progress, T_DIMSE_C_StoreRQ *req, char *imageFileName, DcmDataset **imageDataSet, T_DIMSE_C_StoreRSP *rsp, DcmDataset **statusDetail);
	
    CONDITION echoSCP(T_ASC_Association *assoc, T_DIMSE_Message *msg, T_ASC_PresentationContextID presID);

	
    IStoreCallBack* m_pHandler;
    IModeloDicom* m_pModelo;
public:
	 int m_numeroImagenes;
	 std::string m_mensaje;
	 long m_bytesDescargados;
protected:
	typedef struct TMedida{
		time_t m_instante;
		int bytesDescargados;
		float oldTasa;
		TMedida() {
			m_instante = time(NULL);
			bytesDescargados = 0;
			oldTasa = 0.0f;
		}
	} TMedida;
	TMedida m_medida;
public:
	float TasaTransferencia(int bytesRestantes);
	void ResetearMedida(bool clearTasa = false);	 
};
