/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __THUMBVIEW_DETAIL_H__
#define __THUMBVIEW_DETAIL_H__

#include "gimageview.h"
#include "fileload.h"
#include "thumbnail_view.h"

#define DETAIL_VIEW_LABEL  "Detail"
#define DETAIL_ICON_LABEL  "Detail + Icon"
#define DETAIL_THUMB_LABEL "Detail + Thumbnail"

gboolean   detailview_append_thumb_frames   (ThumbView     *tv,
					     GList         *start,
					     gint           dest_mode);
GtkWidget *detailview_add_thumbnail         (Thumbnail     *thumb,
					     gint           dest_mode,
					     ThumbLoadType  type);
gboolean   detailview_refresh_thumbnail     (Thumbnail     *thumb);
GtkWidget *detailview_redraw                (ThumbView     *tv,
					     gint           dest_mode,
					     GtkWidget     *scroll_win);
GtkWidget *detailview_resize                (ThumbView     *tv);
void       detailview_adjust                (ThumbView     *tv,
					     Thumbnail     *thumb);
GtkWidget *detailview_create                (ThumbView     *tv,
					     gint           dest_mode);
void       detailview_remove_thumbview_data (ThumbView     *tv);
gboolean   detailview_set_selection         (Thumbnail     *thumb,
					     gboolean       select);

#endif /* __THUMBVIEW_DETAIL_H__ */
