/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __IMAGE_VIEW_H__
#define __IMAGE_VIEW_H__

#include "gimageview.h"

#include "fileload.h"
#include "gimv_image.h"
#include "image_info.h"


#define IMG_MIN_SCALE 5
#define IMG_MAX_SCALE 100000
#define IMG_SCALE_STEP 5


typedef enum
{
   ZOOM_100,  /* Real Size */
   ZOOM_IN,   /* Increase Image Size 5% */
   ZOOM_OUT,  /* Decrease Image Size 5% */
   ZOOM_FIT,  /* Fit to Widnow */
   ZOOM_10,
   ZOOM_25,
   ZOOM_50,
   ZOOM_75,
   ZOOM_125,
   ZOOM_150,
   ZOOM_175,
   ZOOM_200,
   ZOOM_300
} ImgZoomType;


typedef enum
{
   ROTATE_0,
   ROTATE_90,
   ROTATE_180,
   ROTATE_270
} ImageAngle;


typedef void (*ImageViewRenderCbFunc) (gpointer data);
typedef void (*ImageViewAspectCbFunc) (gpointer data);
typedef void (*ImageViewBufferCbFunc) (gpointer data);

typedef void (*ImageViewButtonClickedCbFunc) (ImageView      *iv,
					      GdkEventButton *event,
					      gpointer        data);
typedef void (*ImageView2Button1CbFunc)      (ImageView      *iv,
					      gpointer        data);
typedef void (*ImageViewButton2CbFunc)       (ImageView      *iv,
					      gpointer        data);
typedef void (*ImageViewButton4CbFunc)       (ImageView      *iv,
					      gpointer        data);
typedef void (*ImageViewButton5CbFunc)       (ImageView      *iv,
					      gpointer        data);

typedef GList *(*ImageViewNextFn) (ImageView *iv,
				   gpointer list_owner,
				   GList     *list,
				   gpointer   data);
typedef GList *(*ImageViewPrevFn) (ImageView *iv,
				   gpointer list_owner,
				   GList     *list,
				   gpointer   data);
typedef GList *(*ImageViewNthFn)  (ImageView *iv,
				   GList     *list,
				   guint      nth,
				   gpointer   data);

typedef void (*ImageViewRemoveListFn) (ImageView *iv,
				       gpointer list_owner,
				       gpointer data);

struct ImageView_Tag
{
   /* widget */
   GtkWidget       *event_box;
   GtkWidget       *draw_area;
   GtkWidget       *imageview_popup;
   GtkWidget       *zoom_menu;
   GtkWidget       *rotate_menu;
   GdkCursor       *cursor;

   /* information about image */
   ImageInfo       *info;

   /* image */
   GimvImage       *image;
   GdkPixmap       *gdk_pixmap;
   GdkBitmap       *mask;

   GList           *image_list;      /* shuld be accessed by "image list functions" */
   GList           *image_current;   /* same with above */
   gpointer        list_owner;

   /* image status */
   gfloat           x_scale;
   gfloat           y_scale;
   gint             width;
   gint             height;
   gint             rotate;
   gboolean         fit_to_frame;
   gboolean         keep_aspect;
   gboolean         buffer;

   /* information about image dragging */
   guint            button;
   gboolean         pressed;
   gboolean         dragging;
   gint             drag_startx;
   gint             drag_starty;
   gint             x_pos;
   gint             y_pos;

   /* functions for parent widget */
   ImageViewRenderCbFunc render_cb_func;
   gpointer              render_cb_data;
   ImageViewAspectCbFunc aspect_cb_func;
   gpointer              aspect_cb_data;
   ImageViewBufferCbFunc buffer_cb_func;
   gpointer              buffer_cb_data;

   ImageViewButtonClickedCbFunc button_clicked_cb_func;
   gpointer                     button_clicked_cb_data;
   ImageView2Button1CbFunc d_button1_cb_func;
   gpointer                d_button1_cb_data;
   ImageViewButton2CbFunc  button2_cb_func;
   gpointer                button2_cb_data;
   ImageViewButton4CbFunc  button4_cb_func;
   gpointer                button4_cb_data;
   ImageViewButton5CbFunc  button5_cb_func;
   gpointer                button5_cb_data;

   /* image list functions */
   ImageViewNextFn next_fn;
   gpointer        next_fn_data;
   ImageViewPrevFn prev_fn;
   gpointer        prev_fn_data;
   ImageViewNthFn  nth_fn;
   gpointer        nth_fn_data;

   ImageViewRemoveListFn remove_list_fn;
   gpointer              remove_list_fn_data;
};


extern GList *ImageViewList;


GtkWidget *imageview_create_zoom_menu   (GtkWidget *window,
					 ImageView *iv);
GtkWidget *imageview_create_rotate_menu (GtkWidget *window,
					 ImageView *iv);
GtkWidget *imageview_create_popup_menu  (GtkWidget *window,
					 ImageView *iv);

void       imageview_free               (ImageView   *iv);
void       imageview_free_image_buf     (ImageView   *iv);
void       imageview_load_image_buf     (ImageView   *iv);

void       imageview_change_image_file  (ImageView   *iv,
					 const gchar *newfile);
void       imageview_zoom               (ImageView   *iv,
					 ImgZoomType  zoom,
					 gint         x_scale,
					 gint         y_scale);
void       imageview_draw_image         (ImageView   *iv);
void       imageview_show_image         (ImageView   *iv,
					 ImageAngle   angle);

void       imageview_set_list           (ImageView       *iv,
					 GList           *list,
					 GList           *current,
					 gpointer         list_owner,
					 ImageViewNextFn  next_fn,
					 gpointer         next_fn_data,
					 ImageViewPrevFn  prev_fn,
					 gpointer         prev_fn_data,
					 ImageViewNthFn   nth_fn,
					 gpointer         nth_fn_data,
					 ImageViewRemoveListFn remove_list_fn,
					 gpointer              remove_list_fn_data);
void       imageview_remove_list        (ImageView   *iv,
					 gpointer     list_owner);
void       imageview_next               (ImageView   *iv);
void       imageview_prev               (ImageView   *iv);
void       imageview_nth                (ImageView   *iv,
					 guint        nth);

ImageView *imageview_create             (const gchar *newfile);


#endif /* __IMAGE_VIEW_H__ */
