Name: kudzu
Version: 0.89.2
Release: 1
Copyright: GPL
Summary: The Red Hat Linux hardware probing tool.
Group: Applications/System
Source: kudzu-%{PACKAGE_VERSION}.tar.gz
Obsoletes: rhs-hwdiag setconsole
Prereq: chkconfig, modutils >= 2.3.11-5, /etc/init.d
BuildPrereq: pciutils-devel
BuildRoot: %{_tmppath}/%{name}-root

%description
Kudzu is a hardware probing tool run at system boot time to determine
what hardware has been added or removed from the system.

%package devel
Summary: The development library for hardware probing.
Group: Development/Libraries

%description devel
The kudzu-devel package contains the libkudzu library, which is
used for hardware probing and configuration.

%prep

%setup

%build
ln -s `pwd` kudzu
make RPM_OPT_FLAGS="%{optflags} -I." all kudzu ktest

%install
rm -rf $RPM_BUILD_ROOT
make install install-program DESTDIR=$RPM_BUILD_ROOT
python -c 'from compileall import *; compile_dir("'$RPM_BUILD_ROOT'/usr/lib/python1.5",10,"/usr/lib/python1.5")'

%clean
rm -rf $RPM_BUILD_ROOT

%post
chkconfig --add kudzu

%preun
if [ $1 = 0 ]; then
	chkconfig --del kudzu
fi

%files
%defattr(-,root,root)
%doc README
%{_sbindir}/kudzu
%{_datadir}/kudzu
%{_mandir}/man1/*
%config(noreplace) /etc/sysconfig/kudzu
%config /etc/rc.d/init.d/kudzu
/usr/lib/python1.5/site-packages/*
%{_datadir}/locale/*/*/kudzu.mo

%files devel
%defattr(-,root,root)
%{_libdir}/libkudzu.a
%{_libdir}/libkudzu_loader.a
%{_includedir}/kudzu

%changelog
* Tue Jan  9 2001 Bill Nottingham <notting@redhat.com>
- don't write modules.conf aliases for cardbus network stuff

* Thu Dec 28 2000 Bill Nottingham <notting@redhat.com>
- fix continual redetection of SOCKET devices

* Fri Dec 22 2000 Bill Nottingham <notting@redhat.com>
- read modules.pcimap as well
- pcitable updates

* Tue Dec 19 2000 Bill Nottingham <notting@redhat.com>
- map yenta_socket driver for cardbus bridges (CLASS_SOCKET)

* Wed Dec 13 2000 Bill Nottingham <notting@redhat.com>
- work around a possible glibc bug
- fix up the USB device stuff

* Tue Dec 12 2000 Bill Nottingham <notting@redhat.com>
- fix segfault caused by yesterday's changes
- stub load/removeModule for the loader

* Mon Dec 11 2000 Bill Nottingham <notting@redhat.com>
- libmodules gets integrated into libkudzu
- load necessary modules before probing

* Fri Dec  8 2000 Bill Nottingham <notting@redhat.com>
- a WORM device is a CD-ROM (#19250)

* Tue Dec 05 2000 Michael Fulbright <msf@redhat.com>
- fix for IDE CDROM probing segfault

* Mon Nov 20 2000 Erik Troan <ewt@redhat.com>
- fix for scd devices > scd9

* Sat Nov 18 2000 Bill Nottingham <notting@redhat.com>
- don't use files in /tmp to determine whether to switch runlevels

* Sat Oct 21 2000 Matt Wilson <msw@redhat.com>
- install kudzu.py into /usr/lib/python1.5/site-packages, not
  /usr/lib/python1.5/
- added backwards compatibility for old python interface
- fixed crashes in python C binding
- fixed massive memory leaks in python C binding

* Wed Oct 18 2000 Bill Nottingham <notting@redhat.com>
- pcitable updates
- don't 'configure' agpgart on alpha
- don't configure usb controllers if there are no modules

* Wed Oct 04 2000 Trond Eivind Glomsrd <teg@redhat.com>
- segfault fix

* Tue Oct 03 2000 Trond Eivind Glomsrd <teg@redhat.com>
- some fixes to avoid segfaulting with serial devices
  in kudzu if no PnP-description is available
- minor fix to the makefile  

* Fri Sep 29 2000 Trond Eivind Glomsrd <teg@redhat.com>
- rewritten USB support
- new python module (formerly kudzu2), giving access to
  more information 

* Wed Sep 13 2000 Trond Eivind Glomsrd <teg@redhat.com>
- include more info in the kudzu2 python module

* Fri Sep 08 2000 Trond Eivind Glomsrd <teg@redhat.com>
- new kudzu2 python module which gives access to all
  of the information available on the device in the C
  library. Hopefully will be the main module soonish.

* Wed Aug 30 2000 Bill Nottingham <notting@redhat.com>
- pcitable tweaks

* Thu Aug 24 2000 Erik Troan <ewt@redhat.com>
- updated it/es translations

* Thu Aug 24 2000 Bill Nottingham <notting@redhat.com>
- fix segfault when passed '-f <some file that doesn't exist>'

* Wed Aug 23 2000 Bill Nottingham <notting@redhat.com>
- fix some ATI Mobility mappings
- use ftw() to look for modules; it's the only sane way to handle
  2.4 kernels

* Sat Aug 19 2000 Bill Nottingham <notting@redhat.com>
- fix network device ordering

* Tue Aug 15 2000 Bill Nottingham <notting@redhat.com>
- disabled things also have IRQ 255. Neat.

* Wed Aug  9 2000 Bill Nottingham <notting@redhat.com>
- actually include translation files. Duh.

* Wed Aug  9 2000 Tim Waugh <twaugh@redhat.com>
- avoid overflowing the monitor id buffer (#15795)

* Tue Aug  8 2000 Erik Troan <ewt@redhat.com>
- look for PCMCIA IDE devices (they aren't in /proc)

* Mon Aug  7 2000 Bill Nottingham <notting@redhat.com>
- handle probing for excessive numbers of SCSI devices
- tweak IRQ 0 ignoring slightly

* Sun Aug  6 2000 Bill Nottingham <notting@redhat.com>
- ignore devices on IRQ 0

* Fri Aug  4 2000 Bill Nottingham <notting@redhat.com>
- fix subdevice sorting in pci device table (#14503)

* Fri Aug  4 2000 Florian La Roche <Florian.LaRoche@redhat.com>
- make some functions in pci.c "static"

* Wed Aug  2 2000 Bill Nottingham <notting@redhat.com>
- assorted pcitable and translation fixes

* Fri Jul 28 2000 Bill Nottingham <notting@redhat.com>
- fixes so translations get activated

* Wed Jul 26 2000 Bill Nottingham <notting@redhat.com>
- pcitable fixes (Neomagic, Matrox)

* Wed Jul 26 2000 Matt Wilson <msw@redhat.com>
- new translations for de fr it es

* Tue Jul 25 2000 Bill Nottingham <notting@redhat.com>
- pci.ids updates
- probe for memory in DDC probe
- link vbe library in directly

* Tue Jul 25 2000 Florian La Roche <Florian.LaRoche@redhat.de>
- update gdth ICP vortex entries

* Mon Jul 24 2000 Bill Nottingham <notting@redhat.com>
- turn off DDC probing in generic hardware probe
- random pcitable updates

* Tue Jul 18 2000 Michael Fulbright <msf@redhat.com>
- enable USB bus probing for loader

* Tue Jul 18 2000 Bill Nottingham <notting@redhat.com>
- pcitable updates

* Fri Jul 14 2000 Matt Wilson <msw@redhat.com>
- added USB probing to kudzu_loader library

* Fri Jul 14 2000 Bill Nottingham <notting@redhat.com>
- move initscript back

* Tue Jul 11 2000 Florian La Roche <Florian.LaRoche@redhat.de>
- add another ncr/sym controller to pcitable

* Mon Jul  3 2000 Trond Eivind Glomsrd <teg@redhat.com>
- USB mouse detection

* Mon Jul  3 2000 Bill Nottingham <notting@redhat.com>
- preliminary USB probing (from Trond)

* Tue Jun 27 2000 Bill Nottingham <notting@redhat.com>
- add /etc/sysconfig/kudzu where you can force only safe probes on boot

* Mon Jun 26 2000 Bill Nottingham <notting@redhat.com>
- configure USB controllers
- initscript path munging

* Sun Jun 18 2000 Bill Nottingham <notting@redhat.com>
- fix broken bus handling in library

* Thu Jun 15 2000 Bill Nottingham <notting@redhat.com>
- add r128 driver mappings

* Thu Jun 15 2000 Matt Wilson <msw@redhat.com>
- hacks to probe vesa and vga16 framebuffers

* Tue Jun 13 2000 Bill Nottingham <notting@redhat.com>
- DDC probing fixes

* Wed Jun  7 2000 Bill Nottingham <notting@redhat.com>
- add in monitor probing

* Mon Jun  4 2000 Bill Nottingham <notting@redhat.com>
- pcitable fixes

* Thu Jun  1 2000 Bill Nottingham <notting@redhat.com>
- modules.confiscation

* Tue May 30 2000 Erik Troan <ewt@redhat.com>
- moved kudzumodule to main kudzu package

* Wed May 10 2000 Bill Nottingham <notting@redhat.com>
- add support for PCI subvendor, subdevice IDs

* Tue Apr  4 2000 Bill Nottingham <notting@redhat.com>
- add fix for odd keyboard controllers

* Tue Mar 28 2000 Erik Troan <ewt@redhat.com>
- added kudzumodule to devel package
- added libkudzu_loader to devel

* Sat Mar  4 2000 Matt Wilson <msw@redhat.com>
- added 810 SVGA mapping

* Thu Mar  2 2000 Bill Nottingham <notting@redhat.com>
- fixes in pci device list merging

* Thu Feb 24 2000 Bill Nottingham <notting@redhat.com>
- fix aliasing and configuration of network devices
- only configure modules that are available

* Mon Feb 21 2000 Bill Nottingham <notting@redhat.com>
- fix handling of token ring devices

* Thu Feb 17 2000 Bill Nottingham <notting@redhat.com>
- yet more serial fixes

* Wed Feb 16 2000 Bill Nottingham <notting@redhat.com>
- more serial fixes; bring back DTR and RTS correctly

* Fri Feb  4 2000 Bill Nottingham <notting@redhat.com>
- don't run serial probe on serial console, fixed right

* Tue Feb  1 2000 Bill Nottingham <notting@redhat.com>
- fix previous fixes.

* Wed Jan 26 2000 Bill Nottingham <notting@redhat.com>
- fix add/remove logic somewhat

* Wed Jan 19 2000 Bill Nottingham <notting@redhat.com>
- don't run serial probe on serial console

* Fri Jan  7 2000 Bill Nottingham <notting@redhat.com>
- fix stupid bug in configuring scsi/net cards

* Mon Oct 25 1999 Bill Nottingham <notting@redhat.com>
- oops, don't try to configure 'unknown's.

* Mon Oct 11 1999 Bill Nottingham <notting@redhat.com>
- fix creation of /etc/sysconfig/soundcard...

* Wed Oct  6 1999 Bill Nottingham <notting@redhat.com>
- add inittab munging for sparc serial consoles...

* Thu Sep 30 1999 Bill Nottingham <notting@redhat.com>
- add sun keyboard probing (from jakub)
- add some bttv support

* Wed Sep 22 1999 Bill Nottingham <notting@redhat.com>
- run 'telinit 5' if needed in the initscript

* Mon Sep 20 1999 Bill Nottingham <notting@redhat.com>
- new & improved UI
- module aliasing fixes

* Thu Sep  9 1999 Bill Nottingham <notting@redhat.com>
- sanitize, homogenize, sterilize...

* Wed Sep  8 1999 Bill Nottingham <notting@redhat.com>
- get geometry for ide drives
- enumerate buses (jj@ultra.linux.cz)
