/* This software may be freely redistributed under the terms of the GNU
 * public license.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <kudzu.h>

#include <stdio.h>
#include <stdlib.h>

extern char *classStrings[];

int main(int argc, char **argv) {
	struct device **baz;
	int x=0;
    
	initializeDeviceList(BUS_UNSPEC);
	baz=probeDevices(CLASS_UNSPEC,BUS_UNSPEC,PROBE_ALL);
	for (x=0; baz[x]; x++)
	{
  	/*if(baz[x]->class != CLASS_SCSI) {
  	  printf("Error: kudzu returned a non-SCSI device although I have told it not to !\n");
  	  exit(1);
  	}*/
  	printf("%s ", classStrings[baz[x]->class]);
	  printf("%s \"%s\"", baz[x]->driver, baz[x]->desc);
  	if (baz[x]->device)
  	  printf(" %s\n", baz[x]->device);
  	else
  	  printf("\n");
		
		baz[x]->freeDevice(baz[x]);
	}
	free(baz);
	exit(0);
}
