// GAMESS_DIALOG.CPP

// Copyright (C) 2002 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "ghemicalconfig.h"

#ifdef ENABLE_GAMESS

#include "efp_dialog.h"
#include "filetrans.h"

#include <ghemical/eng1_mm.h>
#include <iostream>
#include <sstream>
#include <sstream>
#include <string>

#include <gtk/gtk.h>
using namespace std;

#ifdef ENABLE_OPENBABEL
using namespace OpenBabel;
#endif
enum {
	COL_DATA = 0,
	COL_ATOMS,
	NUM_COLS
};

efp_dialog::efp_dialog(gtk_project * p1) : glade_dialog("glade/efp_dialog.glade")
{
	/*
enum EFPType {
	TYPE_EFP = 0,
	TYPE_QM
};
*/
	efp_dialog(p1, EFPGroup::EFP);
}

efp_dialog::efp_dialog(gtk_project * p1, EFPGroup::type type) : glade_dialog("glade/efp_dialog.glade")
{
	prj = p1;
	dialog = glade_xml_get_widget(xml, "efp_dialog");
	entry = glade_xml_get_widget(xml, "efp_entry");

	if( type == EFPGroup::QM )
		gtk_window_set_title(GTK_WINDOW(dialog), "Add QM Group");
	else if( type == EFPGroup::EFP )
		gtk_window_set_title(GTK_WINDOW(dialog), "Add EFP Group");

	if (dialog == NULL) { cout << "efp_dialog : glade_xml_get_widget() failed!!!" << endl; return; }
	
	// connect the handlers...

	glade_xml_signal_connect_data(xml, "on_efp_ok_clicked", (GtkSignalFunc) handler_ButtonOk, (gpointer)this);
	glade_xml_signal_connect_data(xml, "on_efp_cancel_clicked", (GtkSignalFunc) handler_ButtonCancel, (gpointer)this);

	// setup1_mm * owner = dynamic_cast<setup1_mm *>(prj->GetCurrentSetup());
	// gnome_mm1_docv * owner = dynamic_cast<gnome_mm1_docv *>(gnome_docv::glade_modal_dialog_owner);
	// if (!owner) cout << "ERROR: cast failed in efp_dialog::handler_ButtonOK()." << endl;

	// generate our list of fragments
	
#ifdef ENABLE_OPENBABEL

    list_view = (GtkWidget *) glade_xml_get_widget(xml, "efp_treeview");
    // gtk_tree_view_set_reorderable(GTK_TREE_VIEW(list), TRUE);
	
    // atoms 
    GtkTreeViewColumn *col = gtk_tree_view_column_new();
    gtk_tree_view_column_set_title(col, "Atoms");
    gtk_tree_view_append_column(GTK_TREE_VIEW(list_view), col);

    GtkCellRenderer *renderer = gtk_cell_renderer_text_new();
    gtk_tree_view_column_pack_start(col, renderer, TRUE);
    gtk_tree_view_column_add_attribute(col, renderer, "text", COL_ATOMS);

	list_store = gtk_list_store_new(NUM_COLS, G_TYPE_POINTER, G_TYPE_STRING);

	gtk_tree_view_set_model(GTK_TREE_VIEW(list_view), GTK_TREE_MODEL(list_store));

	GtkTreeSelection *selection;

	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(list_view));

	gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
	gtk_tree_selection_set_select_function(selection, select_callback, this, NULL);

	OBConversion conv;
	
	file_trans ft;
	sel_mol = ft.CopyAll(prj);

	OBAtom *atom;
	
	int count = 0;
	// We must build a vector of the atoms to remove.
	vector<OBAtom*> atoms_remove;
	for (iter_al it1 = prj->GetAtomsBegin();it1 != prj->GetAtomsEnd();it1++)
	{
		if ( !((* it1).flags & ATOMFLAG_USER_SELECTED) )
		{
			// cout << "Removing: " << (*it1).index << endl;
			atom = sel_mol->GetAtom((*it1).index + 1);
			atoms_remove.push_back(atom);
		}
		else
		{
			count++;
		}
	}

	for( vector<OBAtom*>::iterator it1 = atoms_remove.begin(); it1 != atoms_remove.end(); it1++ )
	{
		atom = (*it1);
		// printf("Atom IDX: %d\n", (*it1)->GetIdx());
		sel_mol->DeleteAtom((*it1));
	}

	if( count == 0 )
	{
		prj->Message("You must select atoms to add as an EFP!");
		gtk_widget_destroy(dialog);
		return;
	}

	if(!conv.SetOutFormat("smi"))
	{
		prj->Message("SMILES Format Conversion Not Available!");
	}
	else
	{
		printf("Finished building OBMol\n");
		cout << "Got SMILES: " << conv.WriteString(sel_mol);
	}

	// now finding molecules
	OBMol *mol = ft.CopyAll(prj);

	string pattern = conv.WriteString(sel_mol);
	pattern.erase(pattern.find_first_of(" \t\n\r"));

	OBSmartsPattern sp;
	sp.Init(pattern);

	GtkTreeIter iter;

	if(sp.Match(*mol))
	{
		EFPGroup *group;
		vector< vector<int> > maplist = sp.GetUMapList();
		// iterate over matches
		//
		// This algorithm is a nightmare but it's the only
		// way i can think of RIGHT NOW to make sure
		// that each molecule only gets added if it matches
		// completely.
		for(vector< vector<int> >::iterator it1 = maplist.begin();
				it1 != maplist.end(); it1++)
		{
			bool invalid = false;
			group = new EFPGroup();
			group->SetType(type);
			//cout << "Staring new group: ";
			// found list indexes
			//for(vector<int>::iterator it2 = (*it1).begin();
					//it2 != (*it1).end(); it2++)
			//{
				//cout << (*it2)-1 << " ";
			//}
			//cout << endl;
			for(vector<int>::iterator it2 = (*it1).begin();
					it2 != (*it1).end(); it2++)
			{
				// find atoms that are in our result
				for(iter_al it3 = prj->GetAtomsBegin(); 
						it3 != prj->GetAtomsEnd(); it3++) {
					if((*it2)-1 == (*it3).index) {
						// first make sure this atom isn't in any other groups
						for(iter_efpgl it4 = prj->gamess_data->GetEFPData()->GetGroupBegin();
								it4 != prj->gamess_data->GetEFPData()->GetGroupEnd(); it4++)
						{
							if((*it4).Contains(&(*it3)))
							{
								invalid=true;
							}
						}
						if(invalid) { break; }
						//cout << "Processing: " << (*it2)-1 << endl;
						// check out Hs!
						for(iter_cl it4 = (*it3).cr_list.begin();
								it4 != (*it3).cr_list.end(); it4++) {
							//cout << (*it3).index << " connected to " << (*it4).atmr->index << endl;
							// if an H is connected to the atom add it
							if((*it4).atmr->el.GetAtomicNumber() == 1) {
								group->AddAtom(((*it4).atmr));
							}
							else
							{
								invalid = true;
								// make sure the atom we have is connected
								// to another atom that is in our selection
								for(vector<int>::iterator it5 = (*it1).begin();
										it5 != (*it1).end(); it5++)
								{
									if((*it5)-1 == (*it4).atmr->index) {
										//cout << (*it5)-1 << " is in this group." << endl;
										invalid = false;
										break;
									}

								}
							}
							if(invalid) { break; }
						}
						if(invalid) { break; }
						group->AddAtom(&(*it3));
					}
				}
				if(invalid) {
					delete(group);
					break;
				}
			}
			if(!invalid)
			{
				gtk_list_store_append(list_store, &iter);
				gtk_list_store_set(list_store, &iter,
						COL_DATA, group,
						COL_ATOMS, group->GetAtomListString(","),
						-1);
			}
		}
	}

	if(!gtk_tree_model_get_iter_first(GTK_TREE_MODEL(list_store), &iter))
	{
		prj->Message("EFP Selection is Invalid");
		return;
	}


	gtk_tree_model_foreach(GTK_TREE_MODEL(list_store), (GtkTreeModelForeachFunc) init_callback, this);
	
#else
	prj->Message("Finding EFP Molecule Patterns Requires OpenBabel!");
	return;

#endif

	// GtkScrolledWindow *sw = (GtkScrolledWindow *) glade_xml_get_widget(xml, "efp_scrolledwindow");
	// GtkTable *t = (GtkTable *) glade_xml_get_widget(xml, "efp_table");
	// gnome_dialog_run(GNOME_DIALOG(dialog));		// MODAL
	gtk_widget_show(dialog);
	// gtk_widget_hide(list_view);
	// gtk_widget_hide(GTK_WIDGET(sw));
	gtk_dialog_run(GTK_DIALOG(dialog));	// MODAL
	// gtk_widget_destroy(dialog);		// MODAL
}

efp_dialog::~efp_dialog()
{
}

gboolean efp_dialog::init_callback(GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer data)
{
	efp_dialog * ref = (efp_dialog *) data;

	EFPGroup *group;

	gtk_project * prj = ref->prj;
	if (prj)
	{
		GtkTreeSelection *selection;
		selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(ref->list_view));

		gtk_tree_model_get(GTK_TREE_MODEL(ref->list_store), iter, COL_DATA, &group, -1);

		for(iter_alp it1 = group->GetAtomsBegin(); it1 != group->GetAtomsEnd(); it1++)
		{
			if((*it1)->GetSelected())
			{
				// cout << "IsSelected: " << (*it1)->index << endl;
				gtk_tree_selection_select_iter(selection, iter);
				break;
			}

		}

	}

	return(FALSE);
}

void efp_dialog::row_callback(GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer data)
{
	efp_dialog * ref = (efp_dialog *) data;

	EFPGroup *group;

	gtk_project * prj = ref->prj;
	if (prj)
	{
		gtk_tree_model_get(GTK_TREE_MODEL(ref->list_store), iter, COL_DATA, &group, -1);
		group->SetLabel(gtk_entry_get_text(GTK_ENTRY(ref->entry)));

		prj->AddEFPGroup(*group);
	}
}

gboolean efp_dialog::select_callback(GtkTreeSelection *selection, GtkTreeModel *model,
		GtkTreePath *path, gboolean path_currently_selected, gpointer data)
{
	efp_dialog * ref = (efp_dialog *) data;
	GladeXML* xml = ref->xml;
	gtk_project *prj = ref->prj;

	GtkTreeIter iter;

	EFPGroup *group;

	if(gtk_tree_model_get_iter(model, &iter, path))
	{
		gtk_tree_model_get(GTK_TREE_MODEL(ref->list_store), &iter, COL_DATA, &group, -1);

		// if it's not currently selected then select the atoms
		for(iter_alp it1 = group->GetAtomsBegin(); it1 != group->GetAtomsEnd(); it1++)
		{
			if(path_currently_selected)
			{
				(*it1)->SetSelected(false);
			}
			else
			{
				(*it1)->SetSelected(true);
			}
		}
		prj->UpdateAllGraphicsViews();
	}

	return TRUE;
}

void efp_dialog::handler_ButtonOk(GtkWidget *widget, gpointer data)
{
	efp_dialog * ref = (efp_dialog *) data;
	GladeXML* xml = ref->xml;

	// GtkWidget * entry = glade_xml_get_widget(xml, "efp_entry");

	GtkTreeSelection *selection;
	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(ref->list_view));

	gtk_tree_selection_selected_foreach(selection, (GtkTreeSelectionForeachFunc) row_callback, data);

	// gtk_project * prj = dynamic_cast<gtk_project *>(gv->prj);
	/*
	gtk_project * prj = ref->prj;
	if (prj)
	{
		EFPGroup group(gtk_entry_get_text(GTK_ENTRY(entry)));
		group.SetType(TYPE_EFP);
		int count = 0;
		for (iter_al it1 = prj->GetAtomsBegin();it1 != prj->GetAtomsEnd();it1++)
		{
			if ((*it1).GetSelected())
			{
				group.AddAtom((*it1));
				count++;
			}
		}
		
		if( count == 0 )
		{
			prj->Message("You must select atoms to add as an EFP!");
			return;
		}
		else
		{
			// prj->gamess_data->GetEFPData()->AddGroup(group);
			prj->AddEFPGroup(group);
		}
	}
	//setup1_mm * owner = dynamic_cast<setup1_mm *>(ref->prj->GetCurrentSetup());
	//if (!owner) cout << "ERROR: cast failed in efp_dialog::handler_ButtonOK()." << endl;
	
	*/
	
	gtk_widget_destroy(ref->dialog);

}

void efp_dialog::handler_ButtonCancel(GtkWidget *widget, gpointer data)
{
	efp_dialog * ref = (efp_dialog *) data;
	GladeXML* xml = ref->xml;

	//setup1_mm * owner = dynamic_cast<setup1_mm *>(ref->prj->GetCurrentSetup());
	//if (!owner) cout << "ERROR: cast failed in efp_dialog::handler_ButtonOK()." << endl;
	
	gtk_widget_destroy(ref->dialog);

}

#endif  // ENABLE_GAMESS

/*################################################################################################*/

// eof
