// MM1ENG9.CPP

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "mm1eng9.h"

#include <iomanip>
#include <fstream>
#include <strstream>
#include <algorithm>
using namespace std;

/*################################################################################################*/

mm1_eng_prmfit::mm1_eng_prmfit(mm1_mdl & p1, prmfit_tables & tab) : mm1_eng(p1)
{
	tab.UpdateTypes(* GetModel(), GetModel()->ostr);
	
	// set default sizes to containers. how optimal/useful this is after all?!?!?!?!?!
	
	bt1_vector.reserve(250);
	bt2_vector.reserve(500);
	bt3_vector.reserve(500);
	
	i32s total_err;
	
/*##############################################*/
/*##############################################*/

	// create bt1-terms...
	
	if (GetModel()->ostr != NULL) (* GetModel()->ostr) << "creating bt1-terms: ";
	i32s bt1_err = 0;
	
	for (iter_mm1bl it1 = GetModel()->GetBondsBegin();it1 != GetModel()->GetBondsEnd();it1++)
	{
		
		mm1_prmfit_bt1 newbt1;
		newbt1.atmi[0] = (* it1).atmr[0]->index;
		newbt1.atmi[1] = (* it1).atmr[1]->index;
		
	prmfit_bs_query query; query.strict = false;
	query.atmtp[0] = index[newbt1.atmi[0]]->atmtp;
	query.atmtp[1] = index[newbt1.atmi[1]]->atmtp;
	query.bndtp = (* it1).bt.GetValue();
	
	tab.DoParamSearch(query, GetModel()->ostr);
	if (query.index == NOT_DEFINED) bt1_err++;
	
		newbt1.opt = query.opt;
		newbt1.fc = query.fc;
		
	newbt1.bt = (* it1).bt.GetValue();		// save also bondtype information...
	newbt1.qi = query.index;			// ...and forcefield param information...
		
		(* it1).index = bt1_vector.size();	// the bond objects are modified here!!!!!
		bt1_vector.push_back(newbt1);
	}
	
	if (GetModel()->ostr != NULL)
	{
		(* GetModel()->ostr) << bt1_vector.size() << " terms, ";
		(* GetModel()->ostr) << bt1_err << " errors." << endl;
	}
	
	bt1data = new mm1_bt1_data[bt1_vector.size()];
	
/*##############################################*/
/*##############################################*/
	
	// create bt2-terms...
	
	if (GetModel()->ostr != NULL) (* GetModel()->ostr) << "creating bt2-terms: ";
	i32s bt2_err = 0;
	
	for (iter_mm1al it1 = GetModel()->GetAtomsBegin();it1 != GetModel()->GetAtomsEnd();it1++)
	{
		if ((* it1).cr_list.size() < 2) continue;
		
		// central atom is known, now find all possible combinations of bonds...
		
		bool dir[2];
		iter_mm1cl ita; iter_mm1cl rnga[2];
		iter_mm1cl itb; iter_mm1cl rngb[2];
		
		rngb[1] = (* it1).cr_list.end();
		
		rnga[0] = (* it1).cr_list.begin();
		rnga[1] = rngb[1]; rnga[1]--;
		
		for (ita = rnga[0];ita != rnga[1];ita++)
		{
			rngb[0] = ita; rngb[0]++;
			dir[0] = (& (* it1) == (* ita).bndr->atmr[0]);
			
			for (itb = rngb[0];itb != rngb[1];itb++)
			{
				dir[1] = (& (* it1) == (* itb).bndr->atmr[0]);
				
				mm1_prmfit_bt2 newbt2;
				newbt2.index1[0] = (* ita).bndr->index; newbt2.dir1[0] = dir[0];
				newbt2.index1[1] = (* itb).bndr->index; newbt2.dir1[1] = dir[1];
				
				newbt2.atmi[0] = bt1_vector[(* ita).bndr->index].get_atmi(1, dir[0]);
				newbt2.atmi[2] = bt1_vector[(* itb).bndr->index].get_atmi(1, dir[1]);
				
				newbt2.atmi[1] = bt1_vector[(* ita).bndr->index].get_atmi(0, dir[0]);
				
	prmfit_ab_query query; query.strict = false;
	query.atmtp[0] = index[newbt2.atmi[0]]->atmtp;
	query.atmtp[1] = index[newbt2.atmi[1]]->atmtp;
	query.atmtp[2] = index[newbt2.atmi[2]]->atmtp;
	query.bndtp[0] = (* ita).bndr->bt.GetValue();
	query.bndtp[1] = (* itb).bndr->bt.GetValue();
	
	tab.DoParamSearch(query, GetModel()->ostr);
	if (query.index == NOT_DEFINED) bt2_err++;
	
				newbt2.opt = query.opt;
				newbt2.fc = query.fc;
				
				newbt2.bt[0] = (* ita).bndr->bt.GetValue();	// save also bondtype information...
				newbt2.bt[1] = (* itb).bndr->bt.GetValue();	// save also bondtype information...
				
				bt2_vector.push_back(newbt2);
			}
		}
	}
	
	if (GetModel()->ostr != NULL)
	{
		(* GetModel()->ostr) << bt2_vector.size() << " terms, ";
		(* GetModel()->ostr) << bt2_err << " errors." << endl;
	}
	
	bt2data = new mm1_bt2_data[bt2_vector.size()];
	
/*##############################################*/
/*##############################################*/
	
	// create bt3-terms...

	if (GetModel()->ostr != NULL) (* GetModel()->ostr) << "creating bt3-terms: ";
	i32s bt3_err = 0;
	
	for (iter_mm1al it1 = GetModel()->GetAtomsBegin();it1 != GetModel()->GetAtomsEnd();it1++)
	{
		if ((* it1).cr_list.size() < 2) continue;
		
		// skip if default geometry is marked linear for this atomtype...
		
		const prmfit_at * tp1 = tab.GetAtomType((* it1).atmtp);
		if (!tp1 || (tp1 != NULL && (tp1->flags & 3) == 1)) continue;
		
		for (iter_mm1cl it2 = (* it1).cr_list.begin();it2 != (* it1).cr_list.end();it2++)
		{
			bool another = (& (* it1) == (* it2).bndr->atmr[0]);
			mm1_atom * atmr = (* it2).bndr->atmr[another];
			
			if (atmr->cr_list.size() < 2) continue;
			if (atmr->index > (* it1).index) continue;
			
			// skip if default geometry is marked linear for this atomtype...
			
			const prmfit_at * tp2 = tab.GetAtomType(atmr->atmtp);
			if (!tp2 || (tp2 != NULL && (tp2->flags & 3) == 1)) continue;
			
			// central atoms are known, now find all possible combinations of bonds...
			
			vector<i32s> ind1a; vector<bool> dir1a;		// search for the 1st group...
			for (iter_mm1cl it3 = (* it1).cr_list.begin();it3 != (* it1).cr_list.end();it3++)
			{
				if ((* it3) == (* it2)) continue;
				
				ind1a.push_back((* it3).bndr->index);
				dir1a.push_back(& (* it1) == (* it3).bndr->atmr[0]);
			}
			
			vector<i32s> ind2a; vector<bool> dir2a;
			for (i32u n1 = 0;n1 < ind1a.size();n1++)
			{
				i32s tmp1 = 0; i32s tmp2 = NOT_DEFINED;
				while (true)
				{
					i32s bt1[2] = { bt2_vector[tmp1].index1[0], bt2_vector[tmp1].index1[1] };
					i32s bt2[2] = { bt2_vector[tmp1].dir1[0], bt2_vector[tmp1].dir1[1] };
					
					if (bt1[0] == ind1a[n1] && bt2[0] == dir1a[n1] &&
						bt1[1] == (* it2).bndr->index && bt2[1] == another) tmp2 = true;
					if (bt1[1] == ind1a[n1] && bt2[1] == dir1a[n1] &&
						bt1[0] == (* it2).bndr->index && bt2[0] == another) tmp2 = false;
					
					if (tmp2 < 0) tmp1++; else break;
				}
				
				ind2a.push_back(tmp1);
				dir2a.push_back(tmp2);
			}
			
			vector<i32s> ind1b; vector<bool> dir1b;		// search for the 2nd group...
			for (iter_mm1cl it3 = atmr->cr_list.begin();it3 != atmr->cr_list.end();it3++)
			{
				if ((* it3) == (* it2)) continue;
				
				ind1b.push_back((* it3).bndr->index);
				dir1b.push_back(atmr == (* it3).bndr->atmr[0]);
			}
			
			vector<i32s> ind2b; vector<bool> dir2b;
			for (i32u n1 = 0;n1 < ind1b.size();n1++)
			{
				i32s tmp1 = 0; i32s tmp2 = NOT_DEFINED;
				while (true)
				{
					i32s bt1[2] = { bt2_vector[tmp1].index1[0], bt2_vector[tmp1].index1[1] };
					i32s bt2[2] = { bt2_vector[tmp1].dir1[0], bt2_vector[tmp1].dir1[1] };
					
					if (bt1[0] == ind1b[n1] && bt2[0] == dir1b[n1] &&
						bt1[1] == (* it2).bndr->index && bt2[1] != another) tmp2 = false;
					if (bt1[1] == ind1b[n1] && bt2[1] == dir1b[n1] &&
						bt1[0] == (* it2).bndr->index && bt2[0] != another) tmp2 = true;
					
					if (tmp2 < 0) tmp1++; else break;
				}
				
				ind2b.push_back(tmp1);
				dir2b.push_back(tmp2);
			}
			
			// now finally create the terms!!!!!
			
			for (i32u n1 = 0;n1 < ind2a.size();n1++)
			{
				for (i32u n2 = 0;n2 < ind2b.size();n2++)
				{
					mm1_prmfit_bt3 newbt3;
					newbt3.index2[0] = ind2a[n1];
					newbt3.index2[1] = ind2b[n2];
					
					newbt3.index1[0] = bt2_vector[newbt3.index2[0]].get_index(0, dir2a[n1]);
					newbt3.dir1[0] = bt2_vector[newbt3.index2[0]].get_dir(0, dir2a[n1]);
					
					newbt3.index1[1] = bt2_vector[newbt3.index2[0]].get_index(1, dir2a[n1]);
					newbt3.dir1[1] = bt2_vector[newbt3.index2[0]].get_dir(1, dir2a[n1]);
					
					newbt3.index1[2] = bt2_vector[newbt3.index2[1]].get_index(0, dir2b[n2]);
					newbt3.dir1[2] = bt2_vector[newbt3.index2[1]].get_dir(0, dir2b[n2]);
					
					newbt3.index1[3] = bt2_vector[newbt3.index2[1]].get_index(1, dir2b[n2]);
					newbt3.dir1[3] = bt2_vector[newbt3.index2[1]].get_dir(1, dir2b[n2]);
					
					newbt3.atmi[0] = bt1_vector[newbt3.index1[0]].get_atmi(1, newbt3.dir1[0]);
					newbt3.atmi[1] = bt1_vector[newbt3.index1[0]].get_atmi(0, newbt3.dir1[0]);
					newbt3.atmi[2] = bt1_vector[newbt3.index1[3]].get_atmi(0, newbt3.dir1[3]);
					newbt3.atmi[3] = bt1_vector[newbt3.index1[3]].get_atmi(1, newbt3.dir1[3]);
					
	prmfit_tr_query query; query.strict = false;
	query.atmtp[0] = index[newbt3.atmi[0]]->atmtp;
	query.atmtp[1] = index[newbt3.atmi[1]]->atmtp;
	query.atmtp[2] = index[newbt3.atmi[2]]->atmtp;
	query.atmtp[3] = index[newbt3.atmi[3]]->atmtp;
	
	// the easiest way to get bondtypes is to find the corresponding bonds...
	// the easiest way to get bondtypes is to find the corresponding bonds...
	// the easiest way to get bondtypes is to find the corresponding bonds...
	
	mm1_bond tmpb1 = mm1_bond(index[newbt3.atmi[0]], index[newbt3.atmi[1]], bondtype());
	iter_mm1bl itb1 = find(GetModel()->GetBondsBegin(), GetModel()->GetBondsEnd(), tmpb1);
	
	mm1_bond tmpb2 = mm1_bond(index[newbt3.atmi[1]], index[newbt3.atmi[2]], bondtype());
	iter_mm1bl itb2 = find(GetModel()->GetBondsBegin(), GetModel()->GetBondsEnd(), tmpb2);
	
	mm1_bond tmpb3 = mm1_bond(index[newbt3.atmi[2]], index[newbt3.atmi[3]], bondtype());
	iter_mm1bl itb3 = find(GetModel()->GetBondsBegin(), GetModel()->GetBondsEnd(), tmpb3);
	
	query.bndtp[0] = (* itb1).bt.GetValue();
	query.bndtp[1] = (* itb2).bt.GetValue();
	query.bndtp[2] = (* itb3).bt.GetValue();
	
	tab.DoParamSearch(query, GetModel()->ostr);
	if (query.index == NOT_DEFINED) bt3_err++;
	
					for (i32s n9 = 0;n9 < 3;n9++)
					{
						newbt3.k[n9] = query.k[n9];
						newbt3.t[n9] = query.t[n9];
					}
					
					newbt3.bt[0] = (* itb1).bt.GetValue();		// save also bondtype information...
					newbt3.bt[1] = (* itb2).bt.GetValue();		// save also bondtype information...
					newbt3.bt[2] = (* itb3).bt.GetValue();		// save also bondtype information...
					
					newbt3.constraint = false;
					bt3_vector.push_back(newbt3);
				}
			}
		}
	}
	
	if (GetModel()->ostr != NULL)
	{
		(* GetModel()->ostr) << bt3_vector.size() << " terms, ";
		(* GetModel()->ostr) << bt3_err << " errors." << endl;
	}
	
/*##############################################*/
/*##############################################*/

	// create bt4-terms...
	
	if (GetModel()->ostr != NULL) (* GetModel()->ostr) << "creating bt4-terms: ";
	i32s bt4_err = 0;
	
	for (iter_mm1al it1 = GetModel()->GetAtomsBegin();it1 != GetModel()->GetAtomsEnd();it1++)
	{
		const prmfit_at * tp = tab.GetAtomType((* it1).atmtp);
		if (!tp || (tp != NULL && !(tp->flags & 16))) continue;
		
		if ((* it1).cr_list.size() != 3) continue;
		
		mm1_cr * crtab[3];
		iter_mm1cl iter = (* it1).cr_list.begin();
		crtab[0] = & (* iter); iter++;
		crtab[1] = & (* iter); iter++;
		crtab[2] = & (* iter);
		
		for (i32s n1 = 0;n1 < 3;n1++)
		{
			mm1_prmfit_bt4 newbt4;
			
			newbt4.index1[0] = crtab[(n1 + 0) % 3]->bndr->index;
			newbt4.dir1[0] = (bt1_vector[newbt4.index1[0]].get_atmi(0, true) == (* it1).index);
			
			newbt4.index1[1] = crtab[(n1 + 1) % 3]->bndr->index;
			newbt4.dir1[1] = (bt1_vector[newbt4.index1[1]].get_atmi(0, true) == (* it1).index);
			
			newbt4.index1[2] = crtab[(n1 + 2) % 3]->bndr->index;
			newbt4.dir1[2] = (bt1_vector[newbt4.index1[2]].get_atmi(0, true) == (* it1).index);
			
			newbt4.index2 = 0;
			while (newbt4.index2 < (i32s) bt2_vector.size())
			{
				bool test[4];
				
				newbt4.dir2 = true;
				test[0] = (bt2_vector[newbt4.index2].get_index(0, newbt4.dir2) == newbt4.index1[0]);
				test[1] = (bt2_vector[newbt4.index2].get_dir(0, newbt4.dir2) == newbt4.dir1[0]);
				test[2] = (bt2_vector[newbt4.index2].get_index(1, newbt4.dir2) == newbt4.index1[1]);
				test[3] = (bt2_vector[newbt4.index2].get_dir(1, newbt4.dir2) == newbt4.dir1[1]);
				if (test[0] && test[1] && test[2] && test[3]) break;
				
				newbt4.dir2 = false;
				test[0] = (bt2_vector[newbt4.index2].get_index(0, newbt4.dir2) == newbt4.index1[0]);
				test[1] = (bt2_vector[newbt4.index2].get_dir(0, newbt4.dir2) == newbt4.dir1[0]);
				test[2] = (bt2_vector[newbt4.index2].get_index(1, newbt4.dir2) == newbt4.index1[1]);
				test[3] = (bt2_vector[newbt4.index2].get_dir(1, newbt4.dir2) == newbt4.dir1[1]);
				if (test[0] && test[1] && test[2] && test[3]) break;
				
				newbt4.index2++;
			}
			
			if (newbt4.index2 == (i32s) bt2_vector.size()) { cout << "bt2 missing for bt4!!!" << endl; exit(EXIT_FAILURE); }
			
			newbt4.atmi[0] = crtab[(n1 + 0) % 3]->atmr->index;
			newbt4.atmi[1] = (* it1).index;
			newbt4.atmi[2] = crtab[(n1 + 1) % 3]->atmr->index;
			newbt4.atmi[3] = crtab[(n1 + 2) % 3]->atmr->index;
			
	prmfit_op_query query; query.strict = false;
	query.atmtp[0] = index[newbt4.atmi[0]]->atmtp;
	query.atmtp[1] = index[newbt4.atmi[1]]->atmtp;
	query.atmtp[2] = index[newbt4.atmi[2]]->atmtp;
	query.atmtp[3] = index[newbt4.atmi[3]]->atmtp;
	
	query.bndtp[0] = crtab[(n1 + 0) % 3]->bndr->bt.GetValue();
	query.bndtp[1] = crtab[(n1 + 1) % 3]->bndr->bt.GetValue();
	query.bndtp[2] = crtab[(n1 + 2) % 3]->bndr->bt.GetValue();
	
	tab.DoParamSearch(query, GetModel()->ostr);
	if (query.index == NOT_DEFINED) bt4_err++;
	
			newbt4.opt = query.opt;
			newbt4.fc = query.fc;
			
			newbt4.bt[0] = crtab[(n1 + 0) % 3]->bndr->bt.GetValue();	// save also bondtype information...
			newbt4.bt[1] = crtab[(n1 + 1) % 3]->bndr->bt.GetValue();	// save also bondtype information...
			newbt4.bt[2] = crtab[(n1 + 2) % 3]->bndr->bt.GetValue();	// save also bondtype information...
			
			bt4_vector.push_back(newbt4);
		}
	}
	
	if (GetModel()->ostr != NULL)
	{
		(* GetModel()->ostr) << bt4_vector.size() << " terms, ";
		(* GetModel()->ostr) << bt4_err << " errors." << endl;
	}
	
/*##############################################*/
/*##############################################*/

	// report possible errors...
	
	total_err = bt1_err + bt2_err + bt3_err + bt4_err;
	if (total_err)
	{
		char mbuff1[256];
		ostrstream str1(mbuff1, sizeof(mbuff1));
		str1 << "WARNING : there were " << total_err << " missing parameters in the bonded terms." << endl << ends;
		GetModel()->PrintToLog(mbuff1);
	}
	
/*##############################################*/
/*##############################################*/

// SET FORMAL CHARGES USING ATOMTYPES!!!!!!!!!!
// SET FORMAL CHARGES USING ATOMTYPES!!!!!!!!!!
// SET FORMAL CHARGES USING ATOMTYPES!!!!!!!!!!
	for (i32s n1 = 0;n1 < natm;n1++) index[n1]->charge = 0.0;
	
	if (GetModel()->ostr != NULL) (* GetModel()->ostr) << "setting up partial charges..." << endl;
	for (iter_mm1bl it1 = GetModel()->GetBondsBegin();it1 != GetModel()->GetBondsEnd();it1++)
	{
		prmfit_bs_query query; query.strict = true;
		query.atmtp[0] = (* it1).atmr[0]->atmtp;
		query.atmtp[1] = (* it1).atmr[1]->atmtp;
		query.bndtp = (* it1).bt.GetValue();
		
		tab.DoParamSearch(query, GetModel()->ostr);
	//	if (query.index == NOT_DEFINED) bt1_err++;
	
		f64 delta = query.cid;			// here we also determine...
		if (query.dir) delta = -delta;		// ...the effect of direction!!!
		
		(* it1).atmr[0]->charge -= delta;
		(* it1).atmr[1]->charge += delta;
	}
	
	if (GetModel()->ostr != NULL) (* GetModel()->ostr) << "creating nbt1-terms: ";
	i32s nbt1_err = 0;
	
	for (i32s ind1 = 0;ind1 < natm - 1;ind1++)
	{
		for (i32s ind2 = ind1 + 1;ind2 < natm;ind2++)
		{
			i32s test = range_cr1[ind1];
			while (test < range_cr1[ind1 + 1])
			{
				if (cr1[test] == ind2) break;
				else test++;
			}
			
			if (test == range_cr1[ind1 + 1])
			{
				test = range_cr2[ind1];
				while (test < range_cr2[ind1 + 1])
				{
					if (cr2[test] == ind2) break;
					else test++;
				}
				
				bool is14 = (test != range_cr2[ind1 + 1]);
				
				mm1_prmfit_nbt1 newnbt1;
				newnbt1.atmi[0] = ind1;
				newnbt1.atmi[1] = ind2;
				
	const prmfit_at * at;
	
	f64 r1 = 0.150; f64 e1 = 0.175;			// default...
	at = tab.GetAtomType(index[ind1]->atmtp);
	if (at != NULL) { r1 = at->lj_r; e1 = at->lj_e; }
	else nbt1_err++;

	f64 r2 = 0.150; f64 e2 = 0.175;			// default...
	at = tab.GetAtomType(index[ind2]->atmtp);
	if (at != NULL) { r2 = at->lj_r; e2 = at->lj_e; }
	else nbt1_err++;
				
				f64 optdist = r1 + r2;
				f64 energy = sqrt(e1 * e2);
				
				f64 charge1 = index[ind1]->charge;
				f64 charge2 = index[ind2]->charge;
				newnbt1.qq = 138.9354518 * charge1 * charge2;
				
				if (is14)
				{
					energy *= 0.5;
					newnbt1.qq *= 0.75;
				}
				
				newnbt1.k1 = optdist * pow(1.0 * energy, 1.0 / 12.0);
				newnbt1.k2 = optdist * pow(2.0 * energy, 1.0 / 6.0);
				
				nbt1_vector.push_back(newnbt1);
			}
		}
	}
	
	// report possible errors...
	
	total_err = nbt1_err;
	if (total_err)
	{
		char mbuff1[256];
		ostrstream str1(mbuff1, sizeof(mbuff1));
		str1 << "WARNING : there were " << total_err << " missing parameters in the nonbonded terms." << endl << ends;
		GetModel()->PrintToLog(mbuff1);
	}
	
/*##############################################*/
/*##############################################*/

}

mm1_eng_prmfit::~mm1_eng_prmfit(void)
{
	delete[] bt1data;
	delete[] bt2data;
}

i32s mm1_eng_prmfit::FindTorsion(mm1_atom * a1, mm1_atom * a2, mm1_atom * a3, mm1_atom * a4)
{
	i32s tmp[4] = { a1->index, a2->index, a3->index, a4->index };
	
	for (i32s n1 = 0;n1 < (i32s) bt3_vector.size();n1++)
	{
		bool test;	// since torsion is the same in both directions, we can ignore direction...
		
		test = true;
		if (bt3_vector[n1].atmi[0] != tmp[0]) test = false;
		if (bt3_vector[n1].atmi[1] != tmp[1]) test = false;
		if (bt3_vector[n1].atmi[2] != tmp[2]) test = false;
		if (bt3_vector[n1].atmi[3] != tmp[3]) test = false;
		if (test) return n1;
		
		test = true;
		if (bt3_vector[n1].atmi[0] != tmp[3]) test = false;
		if (bt3_vector[n1].atmi[1] != tmp[2]) test = false;
		if (bt3_vector[n1].atmi[2] != tmp[1]) test = false;
		if (bt3_vector[n1].atmi[3] != tmp[0]) test = false;
		if (test) return n1;
	}
	
	return NOT_DEFINED;
}

bool mm1_eng_prmfit::SetTorsionConstraint(i32s ind_bt3, f64 opt, f64 fc, bool lock_local_structure)
{
	if (ind_bt3 < 0) return false;
	if (ind_bt3 >= (i32s) bt3_vector.size()) return false;
	
	// check that opt is in valid range [-pi,+pi]!!!
	
	while (opt > +M_PI) opt -= 2.0 * M_PI;
	while (opt < -M_PI) opt += 2.0 * M_PI;
	
	// measure the current torsion and set constraints for the other torsions, if requested...
	
	if (lock_local_structure)
	{
		v3d<f64> v1a(crd[bt3_vector[ind_bt3].atmi[1]], crd[bt3_vector[ind_bt3].atmi[0]]);
		v3d<f64> v1b(crd[bt3_vector[ind_bt3].atmi[1]], crd[bt3_vector[ind_bt3].atmi[2]]);
		v3d<f64> v1c(crd[bt3_vector[ind_bt3].atmi[2]], crd[bt3_vector[ind_bt3].atmi[3]]);
		f64 delta = opt - v1a.tor(v1b, v1c);
		
		while (delta > +M_PI) delta -= 2.0 * M_PI;
		while (delta < -M_PI) delta += 2.0 * M_PI;
		
		i32s tmp1 = bt3_vector[ind_bt3].atmi[1];
		i32s tmp2 = bt3_vector[ind_bt3].atmi[2];
		
		for (i32s n1 = 0;n1 < (i32s) bt3_vector.size();n1++)
		{
			bool test1 = true;
			if (bt3_vector[n1].atmi[1] != tmp1) test1 = false;
			if (bt3_vector[n1].atmi[2] != tmp2) test1 = false;
			
			bool test2 = true;
			if (bt3_vector[n1].atmi[1] != tmp2) test2 = false;
			if (bt3_vector[n1].atmi[2] != tmp1) test2 = false;
			
			if (test1 || test2)
			{
				v3d<f64> v2a(crd[bt3_vector[n1].atmi[1]], crd[bt3_vector[n1].atmi[0]]);
				v3d<f64> v2b(crd[bt3_vector[n1].atmi[1]], crd[bt3_vector[n1].atmi[2]]);
				v3d<f64> v2c(crd[bt3_vector[n1].atmi[2]], crd[bt3_vector[n1].atmi[3]]);
				f64 local = v2a.tor(v2b, v2c) + delta;
				
				while (local > +M_PI) local -= 2.0 * M_PI;
				while (local < -M_PI) local += 2.0 * M_PI;
				
				bt3_vector[n1].constraint = true;
				bt3_vector[n1].k[0] = local; bt3_vector[n1].k[1] = fc;
			}
		}
	}
	
	// then set the requested constraint... if lock_local_structure was true, then
	// this operation is in fact redundant, but perhaps a bit more accurate than above.
	
	bt3_vector[ind_bt3].constraint = true;
	bt3_vector[ind_bt3].k[0] = opt; bt3_vector[ind_bt3].k[1] = fc;
	return true;
}

void mm1_eng_prmfit::ComputeBT1(i32s p1)
{
	energy_bt1 = 0.0;
	
	// len -> length of the bond vector, in nanometers [nm].
	
	// the bond is a vector, since it has unique begin and end points.
	// if a bond vector needs to be reversed, it's begin and end points are swapped.
	// all data for both forward and reverse vectors are calculated and stored...
	
	// dlen[0] -> grad[0-2]: for atom 1 when direction = 0, for atom 0 when direction = 1
	// dlen[1] -> grad[0-2]: for atom 0 when direction = 0, for atom 1 when direction = 1
	
	// the end point gradient of a vector is always the same as components of the unit vector!!!
	
	for (i32s n1 = 0;n1 < (i32s) bt1_vector.size();n1++)
	{
		i32s * atmi = bt1_vector[n1].atmi;
		
		f64 t1a[3]; f64 t1b = 0.0;
		for (i32s n2 = 0;n2 < 3;n2++)
		{
			f64 t9a = crd[atmi[0]][n2];
			f64 t9b = crd[atmi[1]][n2];
			
			t1a[n2] = t9a - t9b;
			t1b += t1a[n2] * t1a[n2];
		}
		
		f64 t1c = sqrt(t1b);
		bt1data[n1].len = t1c;
		for (i32s n2 = 0;n2 < 3;n2++)
		{
			f64 t9a = t1a[n2] / t1c;
			
			bt1data[n1].dlen[0][n2] = +t9a;
			bt1data[n1].dlen[1][n2] = -t9a;
		}
		
	bt1_vector[n1].x = t1c;			// the bond length [nm] is stored...
	
		// f = a(x-b)^2
		// df/dx = 2a(x-b)
		
		f64 t2a = t1c - bt1_vector[n1].opt;
		f64 t2b = bt1_vector[n1].fc * t2a * t2a;
		
		energy_bt1 += t2b;
		
		if (p1 > 0)
		{
			f64 t2c = 2.0 * bt1_vector[n1].fc * t2a;
			
			for (i32s n2 = 0;n2 < 3;n2++)
			{
				f64 t2d = bt1data[n1].dlen[0][n2] * t2c;
				
				d1[atmi[0]][n2] += t2d;
				d1[atmi[1]][n2] -= t2d;
			}
		}
	}
}

void mm1_eng_prmfit::ComputeBT2(i32s p1)
{
	energy_bt2 = 0.0;
	
	// ang -> cosine of the bond angle, in the usual range [-1.0, +1.0]
	
	// we need directions also here... the angle consists of three points, say A-B-C.
	// when we reverse the angle, we will swap the end points: now they will be C-B-A.
	
	// dang[0] -> grad[0-2]: for atom 2 when direction = 0, for atom 0 when direction = 1
	// dang[1] -> grad[0-2]: for atom 1 when direction = 0, for atom 1 when direction = 1
	// dang[2] -> grad[0-2]: for atom 0 when direction = 0, for atom 2 when direction = 1
	
	for (i32s n1 = 0;n1 < (i32s) bt2_vector.size();n1++)
	{
		i32s * atmi = bt2_vector[n1].atmi;
		
		i32s * index1 = bt2_vector[n1].index1;
		bool * dir1 = bt2_vector[n1].dir1;
		
		f64 * t1a = bt1data[index1[0]].dlen[dir1[0]];
		f64 * t1b = bt1data[index1[1]].dlen[dir1[1]];
		
		f64 t1c = t1a[0] * t1b[0] + t1a[1] * t1b[1] + t1a[2] * t1b[2];
		
		if (t1c < -1.0) t1c = -1.0;		// domain check...
		if (t1c > +1.0) t1c = +1.0;		// domain check...
		
		bt2data[n1].csa = t1c;
		
		for (i32s n2 = 0;n2 < 3;n2++)
		{
			f64 t9a = (t1b[n2] - t1c * t1a[n2]) / bt1data[index1[0]].len;
			f64 t9b = (t1a[n2] - t1c * t1b[n2]) / bt1data[index1[1]].len;
			
			bt2data[n1].dcsa[0][n2] = t9a;
			bt2data[n1].dcsa[1][n2] = -(t9a + t9b);
			bt2data[n1].dcsa[2][n2] = t9b;
		}
		
	bt2_vector[n1].x = acos(t1c);		// the bond angle [rad] is stored...
	
		f64 t2a;	// df/dx
		
		if (bt2_vector[n1].opt > M_PI * 170.0 / 180.0)
		{
			// f = a(1 + x)
			// df/dx = a
			
			f64 t3b = 1.0 * bt2_vector[n1].fc;	// CHECK THE VALUE!!!
			energy_bt2 += t3b * (1.0 + t1c);
			
			t2a = t3b;
		}
		else
		{
			// f = a(acos(x)-b)^2
			// df/dx = -2a(x-b)/sqrt(1-x*x)
			
			f64 t3b = acos(t1c) - bt2_vector[n1].opt;
			f64 t3c = bt2_vector[n1].fc * t3b * t3b;
			
			energy_bt2 += t3c;
			
			t2a = -2.0 * bt2_vector[n1].fc * t3b / sqrt(1.0 - t1c * t1c);
		}
		
		if (p1 > 0)
		{
			for (i32s n2 = 0;n2 < 3;n2++)
			{
				d1[atmi[0]][n2] += bt2data[n1].dcsa[0][n2] * t2a;
				d1[atmi[1]][n2] += bt2data[n1].dcsa[1][n2] * t2a;
				d1[atmi[2]][n2] += bt2data[n1].dcsa[2][n2] * t2a;
			}
		}
	}
}

void mm1_eng_prmfit::ComputeBT3(i32s p1)
{
	energy_bt3 = 0.0;
	
	for (i32s n1 = 0;n1 < (i32s) bt3_vector.size();n1++)
	{
		i32s * atmi = bt3_vector[n1].atmi;
		
		i32s * index2 = bt3_vector[n1].index2;
		i32s * index1 = bt3_vector[n1].index1;
		bool * dir1 = bt3_vector[n1].dir1;
		
		f64 t1a[2] = { bt2data[index2[0]].csa, bt2data[index2[1]].csa };
		f64 t1b[2] = { 1.0 - t1a[0] * t1a[0], 1.0 - t1a[1] * t1a[1] };
		
		f64 t1c[2][3];
		t1c[0][0] = bt1data[index1[0]].dlen[dir1[0]][0] - t1a[0] * bt1data[index1[1]].dlen[dir1[1]][0];
		t1c[0][1] = bt1data[index1[0]].dlen[dir1[0]][1] - t1a[0] * bt1data[index1[1]].dlen[dir1[1]][1];
		t1c[0][2] = bt1data[index1[0]].dlen[dir1[0]][2] - t1a[0] * bt1data[index1[1]].dlen[dir1[1]][2];
		t1c[1][0] = bt1data[index1[3]].dlen[dir1[3]][0] - t1a[1] * bt1data[index1[2]].dlen[dir1[2]][0];
		t1c[1][1] = bt1data[index1[3]].dlen[dir1[3]][1] - t1a[1] * bt1data[index1[2]].dlen[dir1[2]][1];
		t1c[1][2] = bt1data[index1[3]].dlen[dir1[3]][2] - t1a[1] * bt1data[index1[2]].dlen[dir1[2]][2];
		
		f64 t1d = t1c[0][0] * t1c[1][0] + t1c[0][1] * t1c[1][1] + t1c[0][2] * t1c[1][2];
		f64 t1e = t1d / sqrt(t1b[0] * t1b[1]);
		
		if (t1e < -1.0) t1e = -1.0;		// domain check...
		if (t1e > +1.0) t1e = +1.0;		// domain check...
		
		f64 t1f[3];
		t1f[0] = acos(t1e);
		
		// now we still have to determine the sign of the result...
		// now we still have to determine the sign of the result...
		// now we still have to determine the sign of the result...
		
		f64 t1g[3];
		t1g[0] = bt1data[index1[2]].dlen[dir1[2]][1] * bt1data[index1[3]].dlen[dir1[3]][2] -
			bt1data[index1[2]].dlen[dir1[2]][2] * bt1data[index1[3]].dlen[dir1[3]][1];
		t1g[1] = bt1data[index1[2]].dlen[dir1[2]][2] * bt1data[index1[3]].dlen[dir1[3]][0] -
			bt1data[index1[2]].dlen[dir1[2]][0] * bt1data[index1[3]].dlen[dir1[3]][2];
		t1g[2] = bt1data[index1[2]].dlen[dir1[2]][0] * bt1data[index1[3]].dlen[dir1[3]][1] -
			bt1data[index1[2]].dlen[dir1[2]][1] * bt1data[index1[3]].dlen[dir1[3]][0];
		
		f64 t1h = t1c[0][0] * t1g[0] + t1c[0][1] * t1g[1] + t1c[0][2] * t1g[2];
		if (t1h < 0.0) t1f[0] = -t1f[0];
		
		t1f[1] = t1f[0] + t1f[0];
		t1f[2] = t1f[1] + t1f[0];
		
	bt3_vector[n1].x = t1f[0];		// the torsion angle [rad] is stored...
		
		f64 t9a; f64 t9b;
		if (bt3_vector[n1].constraint)
		{
			// Dx = x-b			| for the following formulas...
			
			// f = a(2PI-Dx)^4		| if Dx > +PI
			// df/fx = -4a(2PI-Dx)^3
			
			// f = a(2PI+Dx)^4		| if Dx < -PI
			// df/fx = +4a(2PI+Dx)^3
			
			// f = a(Dx)^4			| otherwise
			// df/fx = 4a(Dx)^3
			
			f64 t8a = t1f[0] - bt3_vector[n1].k[0];
			if (t8a > +M_PI)
			{
				t8a = 2.0 * M_PI - t8a;
				f64 t8b = t8a * t8a;
				
				t9a = bt3_vector[n1].k[1] * t8b * t8b;
				t9b = -4.0 * bt3_vector[n1].k[1] * t8b * t8a;
			}
			else if (t8a < -M_PI)
			{
				t8a = 2.0 * M_PI + t8a;
				f64 t8b = t8a * t8a;
				
				t9a = bt3_vector[n1].k[1] * t8b * t8b;
				t9b = +4.0 * bt3_vector[n1].k[1] * t8b * t8a;
			}
			else
			{
				f64 t8b = t8a * t8a;
				
				t9a = bt3_vector[n1].k[1] * t8b * t8b;
				t9b = 4.0 * bt3_vector[n1].k[1] * t8b * t8a;
			}
		}
		else
		{
			// f = a(1+cos(x))+b(1-cos(2x))+c(1+cos(3x))
			// df/dx = -a*sin(x)+2b*sin(2x)-3c*sin(3x)
			
			f64 t8a = bt3_vector[n1].k[0] * (1.0 + cos(t1f[0]));
			f64 t8b = bt3_vector[n1].k[1] * (1.0 - cos(t1f[1]));
			f64 t8c = bt3_vector[n1].k[2] * (1.0 + cos(t1f[2]));
			t9a = t8a + t8b + t8c;
			
			f64 t8r = bt3_vector[n1].k[0] * sin(t1f[0]);
			f64 t8s = bt3_vector[n1].k[1] * sin(t1f[1]) * 2.0;
			f64 t8t = bt3_vector[n1].k[2] * sin(t1f[2]) * 3.0;
			t9b = t8s - (t8r + t8t);
		}
		
		energy_bt3 += t9a;
		
		if (p1 > 0)
		{
			f64 t2a = bt1data[index1[0]].len * t1b[0];
			f64 t2b = bt1data[index1[0]].len * t1a[0] / bt1data[index1[1]].len;
			
			f64 t3a = bt1data[index1[3]].len * t1b[1];
			f64 t3b = bt1data[index1[3]].len * t1a[1] / bt1data[index1[2]].len;
			
			f64 t4c[3]; f64 t5c[3]; f64 t6a[3]; f64 t7a[3];
			const i32s cp[3][3] = { { 0, 1, 2 }, { 1, 2, 0 }, { 2, 0, 1 } };
			
			for (i32s n2 = 0;n2 < 3;n2++)
			{
				f64 t4a = bt1data[index1[0]].dlen[dir1[0]][cp[n2][1]] * bt1data[index1[1]].dlen[dir1[1]][cp[n2][2]];
				f64 t4b = bt1data[index1[0]].dlen[dir1[0]][cp[n2][2]] * bt1data[index1[1]].dlen[dir1[1]][cp[n2][1]];
				t4c[n2] = (t4a - t4b) / t2a;
				
				f64 t5a = bt1data[index1[2]].dlen[dir1[2]][cp[n2][2]] * bt1data[index1[3]].dlen[dir1[3]][cp[n2][1]];
				f64 t5b = bt1data[index1[2]].dlen[dir1[2]][cp[n2][1]] * bt1data[index1[3]].dlen[dir1[3]][cp[n2][2]];
				t5c[n2] = (t5a - t5b) / t3a;
				
				d1[atmi[0]][n2] += t4c[n2] * t9b;
				d1[atmi[3]][n2] += t5c[n2] * t9b;
				
				t6a[n2] = (t2b - 1.0) * t4c[n2] - t3b * t5c[n2];
				t7a[n2] = (t3b - 1.0) * t5c[n2] - t2b * t4c[n2];
				
				d1[atmi[1]][n2] += t6a[n2] * t9b;
				d1[atmi[2]][n2] += t7a[n2] * t9b;
			}
		}
	}
}

void mm1_eng_prmfit::ComputeBT4(i32s p1)
{
	energy_bt4 = 0.0;
	
	for (i32s n1 = 0;n1 < (i32s) bt4_vector.size();n1++)
	{
		i32s * atmi = bt4_vector[n1].atmi;
		
		i32s index2 = bt4_vector[n1].index2;
		bool dir2 = bt4_vector[n1].dir2;
		i32s * index1 = bt4_vector[n1].index1;
		bool * dir1 = bt4_vector[n1].dir1;
		
		f64 t1a[3];
		t1a[0] = bt1data[index1[0]].dlen[dir1[0]][1] * bt1data[index1[1]].dlen[dir1[1]][2] -
			bt1data[index1[0]].dlen[dir1[0]][2] * bt1data[index1[1]].dlen[dir1[1]][1];
		t1a[1] = bt1data[index1[0]].dlen[dir1[0]][2] * bt1data[index1[1]].dlen[dir1[1]][0] -
			bt1data[index1[0]].dlen[dir1[0]][0] * bt1data[index1[1]].dlen[dir1[1]][2];
		t1a[2] = bt1data[index1[0]].dlen[dir1[0]][0] * bt1data[index1[1]].dlen[dir1[1]][1] -
			bt1data[index1[0]].dlen[dir1[0]][1] * bt1data[index1[1]].dlen[dir1[1]][0];
		
		f64 t1b = 0.0;
		for (i32s n2 = 0;n2 < 3;n2++)
		{
			t1b += bt1data[index1[2]].dlen[dir1[2]][n2] * t1a[n2];
		}
		
		f64 t1c = 1.0 - bt2data[index2].csa * bt2data[index2].csa;
		f64 t1d = sqrt(t1c);
		
		f64 t1e = t1b / t1d;
		
//cout << "t1e = " << t1e << " " << t1e * t1e << endl;
//v3d<f64> v1(crd[atmi[1]], crd[atmi[0]]);
//v3d<f64> v2(crd[atmi[1]], crd[atmi[2]]);
//v3d<f64> v3(crd[atmi[1]], crd[atmi[3]]);
//v3d<f64> v4 = v1.vpr(v2);
//f64 ang = v3.ang(v4);
//cout << "tark = " << cos(ang) << " " << cos(ang) * cos(ang) << endl;
//int zzz; cin >> zzz;

		if (t1e < -1.0) t1e = -1.0;		// domain check...
		if (t1e > +1.0) t1e = +1.0;		// domain check...
		
	bt4_vector[n1].x = asin(t1e);		// the out-of-plane angle [rad] is stored...
		
		// f = a(asin(x)-b)^2
		// df/dx = 2a(asin(x)-b)/sqrt(1-x^2)
		
		f64 t1f = asin(t1e) - bt4_vector[n1].opt;
		energy_bt4 += bt4_vector[n1].fc * t1f * t1f;
		
		if (p1 > 0)
		{
			f64 t1g = 2.0 * bt4_vector[n1].fc * t1f / sqrt(1.0 - t1e * t1e);
	//		f64 t1h = bt2data[index2].csa / t1d;
			
			f64 t9b = 1.0 - bt2data[index2].csa * bt2data[index2].csa;
			f64 t9c = sqrt(t9b);
			
			for (i32s n2 = 0;n2 < 3;n2++)
			{
				// this code is borrowed from mm2_eng.cpp file...
				// might not be optimal, just a quick way to go ahead.
				
	f64 t6a[2];	// epsilon i
	t6a[0] = bt2data[index2].dcsa[dir2 ? 0 : 2][n2] * bt2data[index2].csa / t9b;
	t6a[1] = bt2data[index2].dcsa[dir2 ? 2 : 0][n2] * bt2data[index2].csa / t9b;
	
	f64 t6b[2];	// sigma ii / r2X
	t6b[0] = (1.0 - bt1data[index1[0]].dlen[dir1[0]][n2] * bt1data[index1[0]].dlen[dir1[0]][n2]) / bt1data[index1[0]].len;
	t6b[1] = (1.0 - bt1data[index1[1]].dlen[dir1[1]][n2] * bt1data[index1[1]].dlen[dir1[1]][n2]) / bt1data[index1[1]].len;
	
	i32s n3[2];
	n3[0] = (n2 + 1) % 3;		// index j
	n3[1] = (n2 + 2) % 3;		// index k
	
	f64 t6c[2];	// sigma ij / r2X
	t6c[0] = -bt1data[index1[0]].dlen[dir1[0]][n2] * bt1data[index1[0]].dlen[dir1[0]][n3[0]] / bt1data[index1[0]].len;
	t6c[1] = -bt1data[index1[1]].dlen[dir1[1]][n2] * bt1data[index1[1]].dlen[dir1[1]][n3[0]] / bt1data[index1[1]].len;
	
	f64 t6d[2];	// sigma ik / r2X
	t6d[0] = -bt1data[index1[0]].dlen[dir1[0]][n2] * bt1data[index1[0]].dlen[dir1[0]][n3[1]] / bt1data[index1[0]].len;
	t6d[1] = -bt1data[index1[1]].dlen[dir1[1]][n2] * bt1data[index1[1]].dlen[dir1[1]][n3[1]] / bt1data[index1[1]].len;
	
	f64 t5a[2][3];	// components of dc/di
	t5a[0][n2] = (t6c[0] * bt1data[index1[1]].dlen[dir1[1]][n3[1]] -
		t6d[0] * bt1data[index1[1]].dlen[dir1[1]][n3[0]] + t1a[n2] * t6a[0]) / t9c;
	t5a[0][n3[0]] = (t6d[0] * bt1data[index1[1]].dlen[dir1[1]][n2] -
		t6b[0] * bt1data[index1[1]].dlen[dir1[1]][n3[1]] + t1a[n3[0]] * t6a[0]) / t9c;
	t5a[0][n3[1]] = (t6b[0] * bt1data[index1[1]].dlen[dir1[1]][n3[0]] -
		t6c[0] * bt1data[index1[1]].dlen[dir1[1]][n2] + t1a[n3[1]] * t6a[0]) / t9c;
	t5a[1][n2] = (t6d[1] * bt1data[index1[0]].dlen[dir1[0]][n3[0]] -
		t6c[1] * bt1data[index1[0]].dlen[dir1[0]][n3[1]] + t1a[n2] * t6a[1]) / t9c;
	t5a[1][n3[0]] = (t6b[1] * bt1data[index1[0]].dlen[dir1[0]][n3[1]] -
		t6d[1] * bt1data[index1[0]].dlen[dir1[0]][n2] + t1a[n3[0]] * t6a[1]) / t9c;
	t5a[1][n3[1]] = (t6c[1] * bt1data[index1[0]].dlen[dir1[0]][n2] -
		t6b[1] * bt1data[index1[0]].dlen[dir1[0]][n3[0]] + t1a[n3[1]] * t6a[1]) / t9c;
				
				f64 tmp1a = t5a[0][0] * bt1data[index1[2]].dlen[dir1[2]][0] +
					t5a[0][1] * bt1data[index1[2]].dlen[dir1[2]][1] +
					t5a[0][2] * bt1data[index1[2]].dlen[dir1[2]][2];
				
				f64 tmp3a = t5a[1][0] * bt1data[index1[2]].dlen[dir1[2]][0] +
					t5a[1][1] * bt1data[index1[2]].dlen[dir1[2]][1] +
					t5a[1][2] * bt1data[index1[2]].dlen[dir1[2]][2];
				
	f64 tmp4a = 0.0;
	for (i32s n4 = 0;n4 < 3;n4++)
	{
		f64 tmp4b;
		if (n2 != n4) tmp4b = -bt1data[index1[2]].dlen[!dir1[2]][n2] * bt1data[index1[2]].dlen[!dir1[2]][n4];
		else tmp4b = 1.0 - bt1data[index1[2]].dlen[!dir1[2]][n4] * bt1data[index1[2]].dlen[!dir1[2]][n4];
		tmp4a += (tmp4b / bt1data[index1[2]].len) * (t1a[n4] / t1d);
	}
				
				d1[atmi[0]][n2] += tmp1a * t1g;
				d1[atmi[1]][n2] -= (tmp1a + tmp3a + tmp4a) * t1g;
				d1[atmi[2]][n2] += tmp3a * t1g;
				d1[atmi[3]][n2] += tmp4a * t1g;
			}
		}
	}
}

void mm1_eng_prmfit::ComputeNBT1(i32s p1)
{
	energy_nbt1 = 0.0;
	
	for (i32s n1 = 0;n1 < (i32s) nbt1_vector.size();n1++)
	{
		i32s * atmi = nbt1_vector[n1].atmi;
		
		f64 t1a[3]; f64 t1b = 0.0;
		for (i32s n2 = 0;n2 < 3;n2++)
		{
			f64 t2a = crd[atmi[0]][n2];
			f64 t2b = crd[atmi[1]][n2];
			
			t1a[n2] = t2a - t2b;
			t1b += t1a[n2] * t1a[n2];
		}
		
		f64 t1c = sqrt(t1b);
		
		// f1 = (r/a)^-12 - (r/b)^-6
		// df1/dr = -12/a(r/a)^-13 + 6/b(r/b)^-7
		
		f64 t3a = t1c / nbt1_vector[n1].k1;
		f64 t3b = t1c / nbt1_vector[n1].k2;
		
		f64 t4a = t3a * t3a * t3a; f64 t4b = t4a * t4a; f64 t4c = t4b * t4b;	// ^3 ^6 ^12
		f64 t5a = t3b * t3b * t3b; f64 t5b = t5a * t5a;				// ^3 ^6
		
		f64 t6a = 1.0 / (t4c) - 1.0 / (t5b);
		
		// f2 = Q/r
		// df2/dr = -Q/r^2
		
		f64 t6b = nbt1_vector[n1].qq / t1c;
		
		energy_nbt1 += t6a + t6b;
		
		if (p1 > 0)
		{
			f64 t7a = 12.0 / (nbt1_vector[n1].k1 * t4c * t3a);
			f64 t7b = 6.0 / (nbt1_vector[n1].k2 * t5b * t3b);
			
			f64 t8a = nbt1_vector[n1].qq / t1b;
			
			f64 t9a = t7b - t7a - t8a;
			for (i32s n2 = 0;n2 < 3;n2++)
			{
				f64 t9b = (t1a[n2] / t1c) * t9a;
				
				d1[atmi[0]][n2] += t9b;
				d1[atmi[1]][n2] -= t9b;
			}
		}
	}
}

/*################################################################################################*/

// eof
