// T3DIALOG.H : dialog boxes etc...

// Copyright (C) 1999 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is for TARGET3...

#ifndef T3DIALOG_H
#define T3DIALOG_H

#include <gtk/gtk.h>

// (most?) dialogs here are made modal, so that only one dialog of it's kind can exist at
// any moment. therefore GtkWidgets are made static, because there is no need to store several
// GtkWidgets. if modal dialogs are needed, an array/container of GtkWidgets are needed in a
// similar way as in window classes...

// how to clean these objects after use ?!?!?! currently these are never deleted... but is that
// a problem as long as there are only static data members ?!?!? no memory leaking in practice???

/*################################################################################################*/

class element_dialog
{
	private:
	
	static GtkWidget * dialog;
	static GtkWidget * current_element_widget;

	public:
	
	element_dialog(void);
	~element_dialog(void);
	
	static void SignalHandler(GtkWidget *, int);
};

/*################################################################################################*/

class bondtype_dialog
{
	private:
	
	static GtkWidget * dialog;
	static GtkWidget * current_bond_widget;	

	public:
	
	bondtype_dialog(void);
	~bondtype_dialog(void);
	
	static void SignalHandler(GtkWidget *, int);
};

/*################################################################################################*/

// if we could have a gnome file dialog, where we could just do gnome_dialog_run_and_close() and
// just get the filename, all this stuff would be useless...

class file_dialog
{
//	private:
	protected:	// at trajfile class, we want to get rid of this...
	
	static GtkWidget * dialog;
	
	public:
	
	file_dialog(const char *, const char *, const char *);
	virtual ~file_dialog(void);
	
	static void OkHandler(GtkButton *, gpointer);
	static void CancelHandler(GtkButton *, gpointer);
	
	virtual bool OkEvent(const char *) = 0;
	virtual void CancelEvent(void) = 0;
};

/*################################################################################################*/

#endif	// T3DIALOG_H

// eof
