// MM2UTIL.CPP

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "mm2util.h"
#include "mm2mdl.h"

/*################################################################################################*/

mm2_chn::mm2_chn(void)
{
	description = NULL;
}

mm2_chn::mm2_chn(const char * p1)
{
	if (!p1) description = NULL;
	else SetDescription(p1);
}

mm2_chn::mm2_chn(const mm2_chn & p1)
{
	if (!p1.description) description = NULL;
	else SetDescription(p1.description);
	
	res_vector = p1.res_vector;
}

mm2_chn::~mm2_chn(void)
{
	if (description != NULL) delete[] description;
}

void mm2_chn::SetDescription(const char * p1)
{
	description = new char[strlen(p1) + 1];
	strcpy(description, p1);
}

/*################################################################################################*/

mm2_res::mm2_res(void)
{
	symbol = '?';
	state = STATE_LOOP; sel = false;
	
	natm = 0;
}

mm2_res::mm2_res(char p1, i32u p2, mm2_eng_param * prm)
{
	symbol = p1;
	state = STATE_LOOP; sel = false;
	
	switch (symbol)
	{
		case 'A': natm = 1;							// 71.1
		vdwr[0] = 0.2078;
		type[0] = TYPE_NEUTRAL; mass[0] = 71.1;
		sasa[0] = 0.537132;
		break;
		
		case 'R': natm = 3;							// 156.7
		vdwr[0] = 0.2000;
		type[0] = TYPE_NEUTRAL; mass[0] = 53.9;		// 1.05
		sasa[0] = 0.124115;
		
		vdwr[1] = 0.2140;
		type[1] = TYPE_NEUTRAL; mass[1] = 51.4;		// 1.00
		sasa[1] = 0.291123;
		
		vdwr[2] = 0.2038;
		type[2] = TYPE_CPOS; mass[2] = 51.4;		// 1.00
		sasa[2] = 0.653118;
		break;
		
		case 'N': natm = 2;							// 114.1
		vdwr[0] = 0.2006;
		type[0] = TYPE_NEUTRAL; mass[0] = 58.4;		// 1.05
		sasa[0] = 0.137107;
		
		vdwr[1] = 0.1991;
		type[1] = TYPE_POLAR; mass[1] = 55.7;		// 1.00
		sasa[1] = 0.527893;
		break;
		
		case 'D': natm = 2;							// 114.5
		vdwr[0] = 0.2003;
		type[0] = TYPE_NEUTRAL; mass[0] = 58.6;		// 1.05
		sasa[0] = 0.191900;
		
		vdwr[1] = 0.1959;
		type[1] = TYPE_CNEG; mass[1] = 55.9;		// 1.00
		sasa[1] = 0.725448;
		break;
		
		case 'C': natm = 2;							// 103.2
		vdwr[0] = 0.2032;
		type[0] = TYPE_NEUTRAL; mass[0] = 51.6;		// 1.00
		sasa[0] = 0.027267;	// min_sasa
		
		vdwr[1] = 0.1776;
		type[1] = TYPE_POLAR; mass[1] = 51.6;		// 1.00
		sasa[1] = 0.042102;
		break;
		
		case 'Q': natm = 2;							// 128.2
		vdwr[0] = 0.2014;
		type[0] = TYPE_NEUTRAL; mass[0] = 64.1;		// 1.00
		sasa[0] = 0.112938;
		
		vdwr[1] = 0.2178;
		type[1] = TYPE_POLAR; mass[1] = 64.1;		// 1.00
		sasa[1] = 0.495674;
		break;
		
		case 'E': natm = 2;							// 128.7
		vdwr[0] = 0.2001;
		type[0] = TYPE_NEUTRAL; mass[0] = 64.3;		// 1.00
		sasa[0] = 0.201951;
		
		vdwr[1] = 0.2091;
		type[1] = TYPE_CNEG; mass[1] = 64.3;		// 1.00
		sasa[1] = 0.919451;
		break;
		
		case 'G': natm = 1;							// 57.1
		vdwr[0] = 0.1836;
		type[0] = TYPE_NEUTRAL; mass[0] = 57.1;
		sasa[0] = 0.600160;
		break;
		
		case 'H': natm = 2;							// 137.7
		vdwr[0] = 0.2027;
		type[0] = TYPE_NEUTRAL; mass[0] = 68.9;		// 1.00
		sasa[0] = 0.070503;
		
		vdwr[1] = 0.1891;
		type[1] = TYPE_POLAR; mass[1] = 68.9;		// 1.00
		sasa[1] = 0.241468;
		break;
		
		case 'I': natm = 2;							// 113.1
		vdwr[0] = 0.2005;
		type[0] = TYPE_NEUTRAL; mass[0] = 56.6;		// 1.00
		sasa[0] = 0.093478;
		
		vdwr[1] = 0.1932;
		type[1] = TYPE_NEUTRAL; mass[1] = 56.6;		// 1.00
		sasa[1] = 0.227029;
		break;
		
		case 'L': natm = 2;							// 113.1
		vdwr[0] = 0.1993;
		type[0] = TYPE_NEUTRAL; mass[0] = 56.6;		// 1.00
		sasa[0] = 0.142353;
		
		vdwr[1] = 0.2030;
		type[1] = TYPE_NEUTRAL; mass[1] = 56.6;		// 1.00
		sasa[1] = 0.384560;
		break;
		
		case 'K': natm = 3;							// 129.2
		vdwr[0] = 0.1998;
		type[0] = TYPE_NEUTRAL; mass[0] = 49.7;		// 1.25
		sasa[0] = 0.163943;
		
		vdwr[1] = 0.2043;
		type[1] = TYPE_NEUTRAL; mass[1] = 39.8;		// 1.00
		sasa[1] = 0.301966;
		
		vdwr[2] = 0.2196;
		type[2] = TYPE_CPOS; mass[2] = 39.8;		// 1.00
		sasa[2] = 1.000000;	// max_sasa
		break;
		
		case 'M': natm = 2;							// 131.2
		vdwr[0] = 0.2028;
		type[0] = TYPE_NEUTRAL; mass[0] = 65.6;		// 1.00
		sasa[0] = 0.051322;
		
		vdwr[1] = 0.1946;
		type[1] = TYPE_NEUTRAL; mass[1] = 65.6;		// 1.00
		sasa[1] = 0.143864;
		break;
		
		case 'F': natm = 2;							// 147.2
		vdwr[0] = 0.2007;
		type[0] = TYPE_NEUTRAL; mass[0] = 68.5;		// 1.00
		sasa[0] = 0.088155;
		
		vdwr[1] = 0.2139;
		type[1] = TYPE_NEUTRAL; mass[1] = 78.7;		// 1.15
		sasa[1] = 0.198559;
		break;
		
		case 'P': natm = 1;							// 97.1
		vdwr[0] = 0.2259;
		type[0] = TYPE_NEUTRAL; mass[0] = 97.1;
		sasa[0] = 0.410933;
		break;
		
		case 'S': natm = 1;							// 87.1
		vdwr[0] = 0.2187;
		type[0] = TYPE_POLAR; mass[0] = 87.1;
		sasa[0] = 0.458944;
		break;
		
		case 'T': natm = 1;							// 101.1
		vdwr[0] = 0.2269;
		type[0] = TYPE_POLAR; mass[0] = 101.1;
		sasa[0] = 0.401230;
		break;
		
		case 'W': natm = 3;							// 188.2
		vdwr[0] = 0.2037;
		type[0] = TYPE_NEUTRAL; mass[0] = 62.7;		// 1.00
		sasa[0] = 0.029361;
		
		vdwr[1] = 0.2078;
		type[1] = TYPE_POLAR; mass[1] = 62.7;		// 1.00
		sasa[1] = 0.045369;
		
		vdwr[2] = 0.2005;
		type[2] = TYPE_NEUTRAL; mass[2] = 62.7;		// 1.00
		sasa[2] = 0.066148;
		break;
		
		case 'Y': natm = 2;							// 163.2
		vdwr[0] = 0.2008;
		type[0] = TYPE_NEUTRAL; mass[0] = 72.5;		// 1.00
		sasa[0] = 0.080746;
		
		vdwr[1] = 0.2122;
		type[1] = TYPE_POLAR; mass[1] = 90.6;		// 1.25
		sasa[1] = 0.239123;
		break;
		
		case 'V': natm = 1;							// 99.1
		vdwr[0] = 0.2264;
		type[0] = TYPE_NEUTRAL; mass[0] = 99.1;
		sasa[0] = 0.286812;
		break;
		
		default:
		cout << "bad problems: unknown residue " << symbol << " !!!" << endl;
		exit(EXIT_FAILURE);
	}
	
	label[0] = label[1] = label[2] = 0.0;
	for (i32u n1 = 0;n1 < natm;n1++)
	{
		vdwr[n1] *= prm->vdwrad;
		sasa[n1] = (sasa[n1] + prm->sasa1) * prm->sasa2;
	}
	
	// coordinates and dipoles are not handled here...
	// coordinates and dipoles are not handled here...
	// coordinates and dipoles are not handled here...
	
	fGL data1 = 0.0;
	fGL_a3 data2 = { 0.0, 0.0, 0.0 };
	
	for (i32u n1 = 0;n1 < p2;n1++)
	{
		peptide_vector.push_back(data1);
		
		for (i32u n2 = 0;n2 < natm;n2++)
		{
			crd_vector[n2].push_back(data2);
		}
	}
}

mm2_res::mm2_res(const mm2_res & p1)
{
	symbol = p1.symbol;
	state = p1.state; sel = p1.sel;
	
	natm = p1.natm;
	
	for (i32s n1 = 0;n1 < 3;n1++)
	{
		type[n1] = p1.type[n1];
		
		vdwr[n1] = p1.vdwr[n1];
		mass[n1] = p1.mass[n1];
		sasa[n1] = p1.sasa[n1];
		
		label[n1] = p1.label[n1];
	}
	
	peptide_vector = p1.peptide_vector;
	
	crd_vector[0] = p1.crd_vector[0];
	crd_vector[1] = p1.crd_vector[1];
	crd_vector[2] = p1.crd_vector[2];
}

mm2_res::~mm2_res(void)
{
}

/*################################################################################################*/

mm2_atm::mm2_atm(void)
{
	data = 0;
}

mm2_atm::mm2_atm(i32u p1, i32u p2, i32u p3)
{
	data = (p1 << 20) + (p2 << 4) + p3;
}

mm2_atm::~mm2_atm(void)
{
}

i32u mm2_atm::operator[](i32s p1) const
{
	switch (p1)
	{
		case 0:		return (data & 0xFFF00000) >> 20;
		case 1:		return (data & 0x000FFFF0) >> 4;
		case 2:		return (data & 0x0000000F);
		default:	return 0;
	}
}

bool mm2_atm::operator==(const mm2_atm & p1) const
{
	return (data == p1.data);
}

/*################################################################################################*/

// eof
