// DEFINE.H : just some macros #defined here...

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef DEFINE_H
#define DEFINE_H

/*################################################################################################*/

// RELEASEDATE should be either __DATE__ or a fixed string like "2000-11-02"

//#define RELEASEDATE __DATE__
#define RELEASEDATE "2002-02-22"

#define WEBSITE "http://www.bioinformatics.org/ghemical"

// could we keep VERSION and RELEASEDATE here???

#ifndef VERSION		// we need this for the old targets also... TH
#define VERSION "0.82"
#endif	// VERSION

/*################################################################################################*/

/// NOT_DEFINED is defined as -1; therefore negative values often mean "##not defined".

#define NOT_DEFINED -1

/*################################################################################################*/

#ifndef PRIMARY_PATH	// version number and subdirectory (e.g. parameters) in code
#define PRIMARY_PATH "/usr/local/share/ghemical/"	// the default for old makefiles...
#endif

#define SECONDARY_PATH "./"

// some additional macros here...

#define MM1_AMINO_BUILDER_FILE "builder/amino.txt"
#define MM1_NUCLEIC_BUILDER_FILE "builder/nucleic.txt"

// directory and extension separators in filenames...

#define DIR_SEPARATOR '/'		// directory separator
#define EXT_SEPARATOR '.'		// extension separator

/*################################################################################################*/

#define GLNAME_LIGHT	0x0001
#define GLNAME_OBJECT	0x0002

#define GLNAME_MODEL_DEPENDENT 0xFF00		// all these events are forwarded...

#define GLNAME_MD_TYPE1 (GLNAME_MODEL_DEPENDENT | 0x01)
#define GLNAME_MD_TYPE2 (GLNAME_MODEL_DEPENDENT | 0x02)

/*################################################################################################*/

// should these be made model-dependent ?!?!?!
// should these be made model-dependent ?!?!?!
// should these be made model-dependent ?!?!?!

#define RENDER_NOTHING		0x00
#define RENDER_WIREFRAME	0x01
#define RENDER_BALL_AND_STICK	0x02
#define RENDER_VAN_DER_WAALS	0x03
#define RENDER_ACCESSIBLE	0x04
#define RENDER_CYLINDERS	0x05

#define LABEL_NOTHING		0x00
#define LABEL_INDEX		0x01
#define LABEL_CHARGE		0x02
#define LABEL_ELEMENT		0x03
#define LABEL_ATOMTYPE		0x04
#define LABEL_BONDTYPE		0x05

/*################################################################################################*/

#endif	// DEFINE_H

// eof
