with Iirs; use Iirs;

package Sem_Types is
   --  Semantization of types (LRM chapter 3)

   -- Semantize subtype indication DEF.
   -- If INCOMPLETE is TRUE, then DEF may designate an incomplete type
   -- definition.
   -- This is used by sem_expr for qualified expression and allocators.
   function Sem_Subtype_Indication (Def: Iir; Incomplete : Boolean := False)
     return Iir;

   -- Return FALSE if A_TYPE is an unconstrained array type or subtype.
   function Sem_Is_Constrained (A_Type: Iir) return Boolean;

   procedure Sem_Protected_Type_Body (Bod : Iir);

   function Sem_Type_Definition (Def: Iir; Decl: Iir) return Iir;

   --  Convert a range expression to a subtype definition whose constraint is
   --  A_RANGE.
   --  This function extract the type of the range expression.
   function Range_To_Subtype_Definition (A_Range: Iir) return Iir;
end Sem_Types;
