with Iirs; use Iirs;

package Sem_Assocs is
   --  Semantize actuals of ASSOC_CHAIN.
   --  Check all named associations are after positionnal one.
   --  Return TRUE if no error.
   function Sem_Actual_Of_Association_Chain (Assoc_Chain : Iir) return Boolean;

   --  Semantize association chain ASSOC_CHAIN with interfaces from
   --  INTERFACE_CHAIN.
   --  Return the level of compatibility between the two chains in LEVEL.
   --  If FINISH is true, then ASSOC_CHAIN may be modifies (individual assoc
   --  added), and error messages (if any) are displayed.
   --  MISSING control unassociated interfaces.
   -- LOC is the association.
   -- Sem_Actual_Of_Association_Chain must have been called before.
   type Missing_Type is (Missing_Parameter, Missing_Port, Missing_Generic,
                         Missing_Allowed);
   procedure Sem_Association_Chain
     (Interface_Chain : Iir;
      Assoc_Chain: in out Iir;
      Finish: Boolean;
      Missing : Missing_Type;
      Loc : Iir;
      Match : out Boolean);

   --  Do port Sem_Association_Chain checks for subprograms.
   procedure Check_Subprogram_Associations
     (Inter_Chain : Iir; Assoc_Chain : Iir);

   --  Check for restrictions in 1.1.1.2
   --  Return FALSE in case of error.
   function Check_Port_Association_Restriction
     (Formal : Iir_Signal_Interface_Declaration;
      Actual : Iir_Signal_Interface_Declaration;
      Assoc : Iir)
     return Boolean;
end Sem_Assocs;
