with System;
with System.Storage_Elements;
with Grt.Types; use Grt.Types;

--  Secondary stack management.
package Grt.Stack2 is
   type Stack2_Ptr is new System.Address;
   Null_Stack2_Ptr : constant Stack2_Ptr := Stack2_Ptr (System.Null_Address);

   type Mark_Id is new System.Storage_Elements.Integer_Address;

   function Mark (S : Stack2_Ptr) return Mark_Id;
   procedure Release (S : Stack2_Ptr; Mark : Mark_Id);
   function Allocate (S : Stack2_Ptr; Size : Ghdl_Index_Type)
     return System.Address;
   function Create return Stack2_Ptr;

   --  Check S is empty.
   procedure Check_Empty (S : Stack2_Ptr);
end Grt.Stack2;
