with Iirs; use Iirs;

package Back_End is
   --  Return the name of the library file for LIBRARY.
   --  The library file describe the contents of LIBRARY.
   function Default_Library_To_File_Name (Library : Iir_Library_Declaration)
                                         return String;

   type Library_To_File_Name_Acc is
     access function (Library : Iir_Library_Declaration) return String;

   Library_To_File_Name : Library_To_File_Name_Acc :=
     Default_Library_To_File_Name'Access;

   --  UNIT is a design unit from parse.
   --  According to the current back-end, do what is necessary.
   --
   --  If MAIN is true, then UNIT is a wanted to be analysed design unit, and
   --  dump/list options can applied.
   --  This avoid to dump/list units fetched (through a selected name or a
   --  use clause) indirectly by the main unit.
   type Finish_Compilation_Acc is access
     procedure (Unit : Iir_Design_Unit; Main : Boolean := False);

   Finish_Compilation : Finish_Compilation_Acc := null;

   --  DECL is an architecture (library unit) or a subprogram (specification)
   --  decorated with a FOREIGN attribute.  Do back-end checks.
   --  May be NULL for no additionnal checks.
   type Sem_Foreign_Acc is access procedure (Decl : Iir);
   Sem_Foreign : Sem_Foreign_Acc := null;

   --procedure Finish_Compilation
   --  (Unit : Iir_Design_Unit; Main : Boolean := False);
end Back_End;

