module StdControlAttribute (module StdControlAttribute, module StdControlDef) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	StdControlAttribute specifies which ControlAttributes are valid for each of the
--	standard controls.
--	********************************************************************************


import StdControlDef
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


isValidButtonControlAttribute :: ControlAttribute IF_MVAR(,ls ps) -> Bool
isValidButtonControlAttribute (ControlFunction     _) = True
isValidButtonControlAttribute (ControlId           _) = True
isValidButtonControlAttribute (ControlModsFunction _) = True
isValidButtonControlAttribute (ControlPos          _) = True
isValidButtonControlAttribute (ControlWidth        _) = True
isValidButtonControlAttribute _                       = False

isValidEditControlAttribute :: ControlAttribute IF_MVAR(,ls ps) -> Bool
isValidEditControlAttribute (ControlId          _)  = True
isValidEditControlAttribute (ControlKeyboard _ _ _) = True
isValidEditControlAttribute (ControlPos         _)  = True
isValidEditControlAttribute _                       = False

isValidTextControlAttribute :: ControlAttribute IF_MVAR(,ls ps) -> Bool
isValidTextControlAttribute (ControlId    _) = True
isValidTextControlAttribute (ControlPos   _) = True
isValidTextControlAttribute (ControlWidth _) = True
isValidTextControlAttribute _                = False


isControlFunction :: ControlAttribute IF_MVAR(,ls ps) -> Bool
isControlFunction (ControlFunction _)     = True
isControlFunction _                       = False

isControlId       :: ControlAttribute IF_MVAR(,ls ps) -> Bool
isControlId       (ControlId _)           = True
isControlId       _                       = False

isControlKeyboard :: ControlAttribute IF_MVAR(,ls ps) -> Bool
isControlKeyboard (ControlKeyboard _ _ _) = True
isControlKeyboard _                       = False

isControlModsFunction :: ControlAttribute IF_MVAR(,ls ps) -> Bool
isControlModsFunction (ControlModsFunction _) = True
isControlModsFunction _                       = False

isControlPos      :: ControlAttribute IF_MVAR(,ls ps) -> Bool
isControlPos      (ControlPos _)          = True
isControlPos      _                       = False

isControlWidth    :: ControlAttribute IF_MVAR(,ls ps) -> Bool
isControlWidth    (ControlWidth _)        = True
isControlWidth    _                       = False


getControlFun :: ControlAttribute IF_MVAR(,ls ps) -> IF_MVAR(GUIFun (),GUIFun ls ps)
getControlFun (ControlFunction f) = f

getControlIdAtt :: ControlAttribute IF_MVAR(,ls ps) -> Id
getControlIdAtt (ControlId id) = id

getControlKeyboardAtt :: ControlAttribute IF_MVAR(,ls ps) -> (KeyboardStateFilter,SelectState,KeyboardFunction IF_MVAR(,ls ps))
getControlKeyboardAtt (ControlKeyboard filter s f) = (filter,s,f)

getControlModsFun :: ControlAttribute IF_MVAR(,ls ps) -> ModifiersFunction IF_MVAR(,ls ps)
getControlModsFun (ControlModsFunction f) = f

getControlPosAtt :: ControlAttribute IF_MVAR(,ls ps) -> ItemPos
getControlPosAtt (ControlPos itemPos) = itemPos

getControlWidthAtt :: ControlAttribute IF_MVAR(,ls ps) -> ControlWidth
getControlWidthAtt (ControlWidth w) = w
