{-
HOpenGL - a binding of OpenGL and GLUT for Haskell.
Copyright (C) 2001  Sven Panne <Sven.Panne@BetaResearch.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library (COPYING.LIB); if not, write to the Free
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}

module GL_Marshal (
   Marshal,
   evalMarshal,   -- :: Marshal a -> Ptr b -> IO a
   peekMarshal,   -- :: Storable a => Marshal a
   eqMarshal      -- :: Ptr a -> Marshal Bool
) where

import Monad            (liftM)
import Foreign          (Ptr, Storable(..), castPtr, plusPtr)

----------------------------------------------------------------------
-- A simple state monad, keeping track of the current buffer addr.

newtype Marshal a = Marshal { runMarshal :: Ptr () -> IO (a, Ptr ()) }

instance Functor Marshal where
      fmap f m = Marshal (\s -> do (x, s') <- runMarshal m s
                                   return (f x, s'))
 
instance Monad Marshal where
   return x  = Marshal (\s -> return (x, s))
   m >>= f   = Marshal (\s -> do (x, s') <- runMarshal m s
                                 runMarshal (f x) s')
   fail msg  = Marshal (\_ -> fail msg)

evalMarshal :: Marshal a -> Ptr b -> IO a
evalMarshal m = liftM fst . runMarshal m . castPtr

peekMarshal :: Storable a => Marshal a
peekMarshal = Marshal (\s -> do x <- peek (castPtr s)
                                return (x, s `plusPtr` sizeOf x))

eqMarshal :: Ptr a -> Marshal Bool
eqMarshal p = Marshal (\s -> return (p == castPtr s, s))
