{-
HOpenGL - a binding of OpenGL and GLUT for Haskell.
Copyright (C) 2001  Sven Panne <Sven.Panne@BetaResearch.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library (COPYING.LIB); if not, write to the Free
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

This module corresponds to section 6.6 (Hints) of the OpenGL 1.2.1 specs.
-}

module GL_Hints (
   Hint(..), Quality(..),
   unmarshalQuality,   -- internal use only
   hint
) where

import GL_Constants     
import GL_BasicTypes    

---------------------------------------------------------------------------

data Hint =
     PerspectiveCorrectionHint
   | PointSmoothHint
   | LineSmoothHint
   | PolygonSmoothHint
   | FogHint
   deriving (Eq,Ord)

data Quality =
     Fastest
   | Nicest
   | DontCare

marshalQuality :: Quality -> GLenum
marshalQuality Fastest  = gl_FASTEST
marshalQuality Nicest   = gl_NICEST
marshalQuality DontCare = gl_DONT_CARE

unmarshalQuality  :: GLenum -> Quality
unmarshalQuality quality
   | quality == gl_FASTEST   = Fastest
   | quality == gl_NICEST    = Nicest
   | quality == gl_DONT_CARE = DontCare
   | otherwise = error "unmarshalQuality"

hint :: Hint -> Quality -> IO ()
hint PerspectiveCorrectionHint q = glHint gl_PERSPECTIVE_CORRECTION_HINT (marshalQuality q)
hint PointSmoothHint           q = glHint gl_POINT_SMOOTH_HINT           (marshalQuality q)
hint LineSmoothHint            q = glHint gl_LINE_SMOOTH_HINT            (marshalQuality q)
hint PolygonSmoothHint         q = glHint gl_POLYGON_SMOOTH_HINT         (marshalQuality q)
hint FogHint                   q = glHint gl_FOG_HINT                    (marshalQuality q)

foreign import unsafe glHint :: GLenum -> GLenum -> IO ()
