/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
/// @file gfc/gtk/separatormenuitem.hh
/// @brief A GtkSeparatorMenuItem C++ wrapper interface.
///
/// Provides SeparatorMenuItem, a separator used to group items within a menu.

#ifndef GFC_GTK_SEPARATOR_MENU_ITEM_HH
#define GFC_GTK_SEPARATOR_MENU_ITEM_HH

#ifndef GFC_GTK_MENU_ITEM_HH
#include <gfc/gtk/menuitem.hh>
#endif

#ifndef __GTK_SEPARATOR_MENU_ITEM_H__
#include <gtk/gtkseparatormenuitem.h>
#endif

namespace GFC {

namespace Gtk {

/// @class SeparatorMenuItem separatormenuitem.hh gfc/gtk/separatormenuitem.hh
/// @brief A GtkSeparatorMenuItem C++ wrapper class.
///
/// The SeparatorMenuItem is a separator used to group items within a menu. It displays
/// a horizontal line with a shadow to make it appear sunken into the interface.

class SeparatorMenuItem : public MenuItem
{
	friend class G::Object;
	
	SeparatorMenuItem(const SeparatorMenuItem&);
	SeparatorMenuItem& operator=(const SeparatorMenuItem&);
	
protected:
/// @name Constructors
/// @{

	explicit SeparatorMenuItem(GtkSeparatorMenuItem *menu_item, bool owns_reference = false);
	///< Construct a new SeparatorMenuItem from an existing GtkSeparatorMenuItem.
	///< @param menu_item A pointer to a GtkSeparatorMenuItem.
	///< @param owns_reference Set false if the initial reference count is floating, set true if it's not.
	///<
	///< <BR>The <EM>menu_item</EM> can be a newly created GtkSeparatorMenuItem or an existing
	///< GtkSeparatorMenuItem (see G::Object::Object).

/// @}

public:
/// @name Constructors
/// @{

	SeparatorMenuItem();
	///< Construct a new separator menu item.

	
	virtual ~SeparatorMenuItem();
	///< Destructor.
	
/// @}
/// @name Accessors
/// @{

	GtkSeparatorMenuItem* gtk_separator_menu_item() const;
	///< Get a pointer to the GtkSeparatorMenuItem structure.

	operator GtkSeparatorMenuItem* () const;
	///< Conversion operator; safely converts a SeparatorMenuItem to a GtkSeparatorMenuItem pointer.

/// @}
};

} // namespace Gtk

} // namespace GFC

#include <gfc/gtk/inline/separatormenuitem.inl>

#endif // GFC_GTK_SEPARATOR_MENU_ITEM_HH

