/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  menushellsignals.cc - Gtk::MenuShell virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "menushell.hh"
#include "menushellsignals.hh"
#include "private/menushellclass.hh"

using namespace GFC;

/*  Gtk::MenuShellSignals
 */

Gtk::MenuShellSignals::MenuShellSignals(MenuShell *menu_shell)
: ContainerSignals(menu_shell)
{
	Gtk::MenuShellClass::init(GTK_MENU_SHELL_GET_CLASS(menu_shell->gtk_menu_shell()));
}

Gtk::MenuShellSignals::~MenuShellSignals()
{
}

void
Gtk::MenuShellSignals::on_deactivate()
{
	GtkMenuShellClass *g_class = MenuShellClass::get_parent_class(instance_);
	if (g_class->deactivate)
		g_class->deactivate((GtkMenuShell*)instance_);
}

void
Gtk::MenuShellSignals::on_selection_done()
{
	GtkMenuShellClass *g_class = MenuShellClass::get_parent_class(instance_);
	if (g_class->selection_done)
		g_class->selection_done((GtkMenuShell*)instance_);
}

/*  Gtk::MenuShellClass
 */

void
Gtk::MenuShellClass::init(GtkMenuShellClass *g_class)
{
	g_class->deactivate = &deactivate_proxy;
	g_class->selection_done = &selection_done_proxy;
}

GtkMenuShellClass*
Gtk::MenuShellClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_MENU_SHELL_GET_CLASS(instance));
	return static_cast<GtkMenuShellClass*>(ptr);
}

GType
Gtk::MenuShellClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_MENU_SHELL);
	}
	return type;
}

void*
Gtk::MenuShellClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::MenuShellClass::deactivate_proxy(GtkMenuShell *menu_shell)
{
	void *ptr = g_object_get_qdata((GObject*)menu_shell, G::ObjectSignals::quark());
	if (ptr)
		static_cast<MenuShellSignals*>(ptr)->on_deactivate();
	else
	{
		GtkMenuShellClass *g_class = MenuShellClass::get_parent_class(menu_shell);
		if (g_class->deactivate)
			g_class->deactivate(menu_shell);
	}
}

void
Gtk::MenuShellClass::selection_done_proxy(GtkMenuShell *menu_shell)
{
	void *ptr = g_object_get_qdata((GObject*)menu_shell, G::ObjectSignals::quark());
	if (ptr)
		static_cast<MenuShellSignals*>(ptr)->on_selection_done();
	else
	{
		GtkMenuShellClass *g_class = MenuShellClass::get_parent_class(menu_shell);
		if (g_class->selection_done)
			g_class->selection_done(menu_shell);
	}
}

