/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  color.inl - Gdk::Color and Gdk::Colormap inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*  Gdk::Color
 */

inline GdkColor*
GFC::Gdk::Color::gdk_color() const
{
	return reinterpret_cast<GdkColor*>(boxed_);
}

inline GFC::Gdk::Color::operator GdkColor* () const
{
	return this ? gdk_color() : 0;
}

inline unsigned short
GFC::Gdk::Color::get_red() const
{
	return gdk_color()->red;
}

inline unsigned short
GFC::Gdk::Color::get_green() const
{
	return gdk_color()->green;
}

inline unsigned short
GFC::Gdk::Color::get_blue() const
{
	return gdk_color()->blue;
}

inline unsigned long
GFC::Gdk::Color::get_pixel() const
{
	return gdk_color()->pixel;
}

inline void
GFC::Gdk::Color::set_red(unsigned short r)
{
	gdk_color()->red = r;
}

inline void
GFC::Gdk::Color::set_green(unsigned short g)
{
	gdk_color()->green = g;
}

inline void
GFC::Gdk::Color::set_blue(unsigned short b)
{
	gdk_color()->blue = b;
}

inline void
GFC::Gdk::Color::set_pixel(unsigned long p)
{
	gdk_color()->pixel = p;
}

inline bool
GFC::Gdk::Color::parse(const char *spec)
{
	return gdk_color_parse(spec, gdk_color());
}

inline unsigned int
GFC::Gdk::Color::hash() const
{
	return gdk_color_hash(gdk_color());
}

/*  Gdk::Colormap
 */

inline GdkColormap*
GFC::Gdk::Colormap::gdk_colormap() const
{
	return reinterpret_cast<GdkColormap*>(instance_);
}

inline GFC::Gdk::Colormap::operator GdkColormap* () const
{
	return this ? gdk_colormap() : 0;
}

