#include "vektor.h"
#include "printer.h"
#include "parser.h"
#include "gfanapplication.h"
#include "minkowskisum.h"
#include "newtonpolytope.h"
#include "buchberger.h"
#include "wallideal.h"
#include "lp.h"
#include "tropical.h"
#include "division.h"
#include "bergman.h"
#include "tropical2.h"
#include "dimension.h"
#include "timer.h"

class TropicalStartingConeApplication : public GFanApplication
{
  SimpleOption useThisConeOption;
  SimpleOption dimensionOption;
public:
  bool includeInDefaultInstallation()
  {
    return true;
  }
  const char *helpText()
  {
    return "This program attempts to compute a starting pair of marked reduced Groebner bases to be used as input for gfan_tropicaltraverse. If unsuccessful the program will say so. The input is a homogeneous ideal whose tropical variety is a pure d-dimensional polyhedral complex.\n";
  }
  TropicalStartingConeApplication():
    useThisConeOption("-g","Tell the program that the input is already a reduced Groebner basis."),
    dimensionOption("-d","Output dimension information to standard error.")
  {
    registerOptions();
  }
  char *name()
  {
    return "_tropicalstartingcone";
  }
  int main()
  {
    lpSetSolver("cddgmp");
    FileParser P(Stdin);

    PolynomialSet g=P.parsePolynomialSetWithRing();
    if(!useThisConeOption.getValue())
      {
	buchberger(&g,StandardGradedLexicographicTermOrder());
      }
    //    assert(!containsMonomial(g));
    if(dimensionOption.getValue())
      {
	fprintf(Stderr,"Krull dimension of input ideal: %i\n",krullDimension(g));
	fprintf(Stderr,"Dimension of homogeneity space for full ideal: %i\n",dimensionOfHomogeneitySpace(g));
      }
    PolynomialSet fullBasis(g.getRing());
    PolynomialSet g2=guessInitialIdealWithoutMonomial(g,&fullBasis,false); //CHANGETHIS to false
    //    PolynomialSet g2=guessInitialIdealWithoutMonomial(g,&fullBasis,true); //CHANGETHIS to false

    if(dimensionOption.getValue())
      {
	fprintf(Stderr,"Krull dimension of input ideal: %i\n",krullDimension(g));
	fprintf(Stderr,"Dimension of homogeneity space for full ideal: %i\n",dimensionOfHomogeneitySpace(g));
	fprintf(Stderr,"Dimension of homogeneity space for initial ideal: %i\n",dimensionOfHomogeneitySpace(g2));
      }
    AsciiPrinter(Stdout).printPolynomialRing(g2.getRing());
    AsciiPrinter(Stdout).printNewLine();
    AsciiPrinter(Stdout).printPolynomialSet(g2);
    AsciiPrinter(Stdout).printPolynomialSet(fullBasis);


    return 0;
  }
};

static TropicalStartingConeApplication theApplication;
