#include <stdlib.h>
#include <stdint.h>
#include <stdio.h>
#include <sys/select.h>

#define TS_PACKET_SIZE		188

#define TS_PID_OFF1		1
#define TS_PID_OFF2		2
#define TS_PID_MASK		0x1fff
#define TS_CC_OFF		3
#define TS_CC_MASK		0xf
#define TS_AFC_OFF		3
#define TS_AFC_MASK		0x30
#define TS_AFC_SHIFT		4

#define	PID_MAX			0x2000

static inline unsigned int ts_pid(uint8_t *tsp) {
	return (tsp[TS_PID_OFF1]<<8|tsp[TS_PID_OFF2])&TS_PID_MASK;
}

static inline unsigned int ts_cc(uint8_t *tsp) {
	return (tsp[TS_CC_OFF] & TS_CC_MASK);
}

static inline unsigned int ts_afc(uint8_t *tsp) {
	return ((tsp[TS_AFC_OFF] & TS_AFC_MASK) >> TS_AFC_SHIFT);
}

static inline unsigned int ts_tei(uint8_t *tsp) {
        return (tsp[TS_PID_OFF1] & 0x80);
}

int main(void ) {
	uint8_t		tsbuf[TS_PACKET_SIZE];
	uint8_t		pidcc[PID_MAX];
	int		rc, len, pktno=0, pid, afc, valid=0, toread, no;
	uint8_t		cc, occ;
	fd_set		fdin;

	while(1) {
		toread=TS_PACKET_SIZE-valid;

		FD_ZERO(&fdin);
		FD_SET(fileno(stdin), &fdin);

		no=select(1, &fdin, NULL, NULL, NULL);
		if (!no)
			continue;

		len=read(fileno(stdin), &tsbuf, toread);

		if (len == 0 | len < 0) {
			printf("Aborting - short read %d/%d\n", len, toread);
			exit(0);
		}

		valid+=len;

		if (valid != TS_PACKET_SIZE)
			continue;

		valid=0;
		pktno++;

		if (tsbuf[0] != 0x47) {
			fprintf(stderr, "%06d Missing sync\n", pktno);
			continue;
		}

		if (ts_tei(tsbuf))
			fprintf(stderr, "%06d Packet has set TEI\n", pktno);

		pid=ts_pid(tsbuf);
		cc=ts_cc(tsbuf);
		afc=ts_afc(tsbuf);

		occ=pidcc[pid]&0xf;

		if (afc == 0x2 || afc == 0) {
			if (cc != occ) {
				fprintf(stderr, "%06d PID %d CC increased from %d to %d although AFC %d\n",
					pktno, pid, occ, cc, afc);
			}
		} else {
			if (cc != occ && cc != ((occ+1)&0xf)) {
				fprintf(stderr, "%06d PID %d CC increased from %d to %d\n",
					pktno, pid, occ, cc);
			}
		}
		pidcc[pid]=cc|0x80;
	}
}
