% FUNCTION [...]=gf_spmat_get(M, args)
% 
%   General getfem sparse matrix inquiry function. M might also be a
%   native matlab sparse matrix.
% 
%   * {ni,nj} = gf_spmat_get(M,'size')
%   Return a vector where `ni` and `nj` are the dimensions of the matrix.
% 
%   * n = gf_spmat_get(M,'nnz')
%   Return the number of non-null values stored in the sparse matrix.
% 
%   * b = gf_spmat_get(M,'is_complex')
%   Return 1 if the matrix contains complex values.
% 
%   * s = gf_spmat_get(M,'storage')
%   Return the storage type currently used for the matrix.  The storage is
%   returned as a string, either 'CSC' or 'WSC'.
% 
%   * Sm = gf_spmat_get(M,'full'[, list I[, list J]])
%   Return a full (sub-)matrix.  The optional arguments `I` and `J`, are the sub-
%   intervals for the rows and columns that are to be extracted.
% 
%   * MV = gf_spmat_get(M,'mult',vec V)
%   Product of the sparse matrix `M` with a vector `V`.  For matrix-matrix
%   multiplications, see gf_spmat('mult').
% 
%   * MtV = gf_spmat_get(M,'tmult',vec V)
%   Product of `M` transposed (conjugated if `M` is complex) with the vector `V`.
% 
%   * D = gf_spmat_get(M,'diag'[, list E])
%   Return the diagonal of `M` as a vector.  If `E` is used, return the sub-
%   diagonals whose ranks are given in E.
% 
%   * {JC, IR} = gf_spmat_get(M,'csc_ind')
%   Return the two usual index arrays of CSC storage.  If `M` is not stored as a
%   CSC matrix, it is converted into CSC.
% 
%   * V = gf_spmat_get(M,'csc_val')
%   Return the array of values of all non-zero entries of `M`.  If `M` is not
%   stored as a CSC matrix, it is converted into CSC.
% 
%   * {N, U0} = gf_spmat_get(M,'dirichlet_nullspace',vec R)
%   Solve the dirichlet conditions `M.U=R`.  A solution `U0` which has a minimum
%   L2-norm is returned, with a sparse matrix `N` containing an orthogonal basis
%   of the kernel of the (assembled) constraints matrix `M` (hence, the PDE linear
%   system should be solved on this subspace): the initial problem
%   
%     `K.U = B` with constraints `M.U = R`
%   
%     is replaced by
%   
%     `(N'.K.N).UU = N'.B` with `U = N.UU + U0`
% 
%   * s = gf_spmat_get(M,'info')
%   Return a string contains a short summary on the sparse matrix (dimensions,
%   filling, ...).
% 
%   * gf_spmat_get(M,'save',string format, string filename)
%   Export the sparse matrix.  the format of the file may be 'hb' for Harwell-
%   Boeing, or 'mm' for Matrix-Market.
% 
function [varargout]=gf_spmat_get(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('spmat_get',varargin{:});
  else
    gf_matlab('spmat_get',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
