% FUNCTION [x] = gf_mesh_im_get(meshim MIM, operation [, args])
% 
%   General function extracting information from mesh_im objects.
% 
%   * {I, CV2I} = gf_mesh_im_get(MIM,'integ'[, mat CVids])
%   Return a list of integration methods used by the MeshIm.  `I` is an array of
%   all Integ objects found in the convexes given in `CVids`. If `CV2I` was
%   supplied as an output argument, it contains, for each convex listed in
%   `CVids`, the index of its correspounding integration method in `I`.  Convexes
%   which are not part of the mesh, or convexes which do not have any integration
%   method have their correspounding entry in `CV2I` set to -1.
% 
%   Example:
%      cvid=gf_mesh_get(mim,'cvid');
%      [f,c2f]=gf_mesh_im_get(mim, 'integ');
%      for i=1:size(f), sf{i}=gf_integ_get('char',f(i)); end;
%      for i=1:size(c2f),
%        disp(sprintf('the integration of convex %d is %s',...
%             cvid(i),sf{i}));
%      end;
%   * M = gf_mesh_im_get(MIM,'eltm,'Eltm em, int cv [int f])
%   Return the elementary matrix (or tensor) integrated on the convex `cv`.
%   **WARNING** Be sure that the fem used for the construction of `em` is
%   compatible with the fem assigned to element `cv` ! This is not checked by the
%   function ! If the argument `f` is given, then the elementary tensor is
%   integrated on the face `f` of `cv` instead of the whole convex.
% 
%   * gf_mesh_im_get(MIM,'save,'string filename[, 'with mesh'])
%   Saves a MeshIm in a text file (and optionaly its linked mesh object).
% 
%   * gf_mesh_im_get(MIM,'char'[,'with mesh'])
%   Output a string description of the MeshIm.  By default, it does not include
%   the description of the linked Mesh object.
% 
%   * m = gf_mesh_im_get(MIM,'linked_mesh')
%   Returns a reference to the Mesh object linked to `mim`.
% 
%   * z = gf_mesh_im_get(MIM,'memsize')
%   Return the amount of memory (in bytes) used by the MeshIm object.  The result
%   does not take into account the linked Mesh object.
% 
% 
%   $Id: gf_mesh_im_get.cc 2869 2009-01-08 01:12:35Z lsaavedr $
function [varargout]=gf_mesh_im_get(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mesh_im_get',varargin{:});
  else
    gf_matlab('mesh_im_get',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
