% FUNCTION MF = gf_mesh_fem(...)
% 
%   General constructor for mesh_fem objects (Finite Element basis
%   functions on a mesh).
% 
%   * gf_mesh_fem(mesh M [, int Qdim=1])
% 
%   Return a getfem handle to the newly created mesh_fem object.
% 
%   * gf_mesh_fem('load', string fname[, Mesh m])
%   Load a MeshFem from a file.  If the mesh `m` is not supplied (this kind of
%   file does not store the mesh), then it is read from the file `fname` and its
%   descriptor is returned as the second output argument.
% 
%   * gf_mesh_fem('from_string', string [, mesh M])
%   Create a MeshFem object from its string description.  See also
%   gf_mesh_fem_get(MF,'char')
% 
%   * gf_mesh_fem('clone', MeshFem mf2)
%   Create a copy of a MeshFem.
% 
%   * gf_mesh_fem('sum', MeshFem mf1, MeshFem mf2[, MeshFem mf3[, ...]])
%   Create a MeshFem that combines two (or more) MeshFem's.  All MeshFem must
%   share the same mesh (see gf_fem('interpolated_fem') to map a MeshFem onto
%   another).  After that, you should not modify the FEM of `mf1`, `mf2` etc.
% 
%   * gf_mesh_fem('levelset', MeshFem mf, LevelSet ls)
%   Create a MeshFem that is conformal to implicit surfaces defined by LevelSet's.
% 
%   * gf_mesh_fem('partial', MeshFem mf, ivec DOFs[,ivec RCVs])
%   Build a restricted MeshFem by keeping only a subset of the degrees of freedom
%   of `mf`.  If `RCVs` is given, no FEM will be put on the convexes listed in
%   `RCVs`.
% 
% 
%   $Id: gf_mesh_fem.cc 2869 2009-01-08 01:12:35Z lsaavedr $
function [varargout]=gf_mesh_fem(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mesh_fem',varargin{:});
  else
    gf_matlab('mesh_fem',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
