/*
 * Decompiled with CFR 0.152.
 */
package geotrans.gui;

import geotrans.gui.Geotrans;
import geotrans.gui.MasterPanel;
import geotrans.gui.jOptions;
import geotrans.parameters.CoordinateSystemParameters;
import geotrans.parameters.EquidistantCylindricalParameters;
import geotrans.parameters.GeodeticParameters;
import geotrans.parameters.LocalCartesianParameters;
import geotrans.parameters.MapProjection3Parameters;
import geotrans.parameters.MapProjection4Parameters;
import geotrans.parameters.MapProjection5Parameters;
import geotrans.parameters.MapProjection6Parameters;
import geotrans.parameters.MercatorParameters;
import geotrans.parameters.NeysParameters;
import geotrans.parameters.ObliqueMercatorParameters;
import geotrans.parameters.PolarStereographicParameters;
import geotrans.parameters.UTMParameters;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RestoreDefault {
    private Geotrans parent;
    private File file;
    private MasterPanel upperMasterPanel;
    private MasterPanel lowerMasterPanel;
    private jOptions joptions;

    public RestoreDefault(Geotrans _parent, File _file, MasterPanel _upperMasterPanel, MasterPanel _lowerMasterPanel, jOptions _joptions) {
        this.parent = _parent;
        this.file = _file;
        this.upperMasterPanel = _upperMasterPanel;
        this.lowerMasterPanel = _lowerMasterPanel;
        this.joptions = _joptions;
        this.readDefaults();
    }

    private void readDefaults() {
        try {
            int defaultSourceDatum = 0;
            int defaultSourceProjection = 0;
            CoordinateSystemParameters defaultSourceParameters = new CoordinateSystemParameters();
            int defaultTargetDatum = 0;
            int defaultTargetProjection = 0;
            CoordinateSystemParameters defaultTargetParameters = new CoordinateSystemParameters();
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(this.file);
            doc.getDocumentElement().normalize();
            this.readOptions(doc);
            NodeList sourceDefaults = doc.getElementsByTagName("source");
            Node sourceNode = sourceDefaults.item(0);
            if (sourceNode.getNodeType() == 1) {
                Element sourceElement = (Element)sourceNode;
                NodeList datumList = sourceElement.getElementsByTagName("datum");
                Element datumElement = (Element)datumList.item(0);
                NodeList datumIndexList = datumElement.getElementsByTagName("index");
                Node datumIndexTextNode = datumIndexList.item(0).getLastChild();
                defaultSourceDatum = Integer.parseInt(datumIndexTextNode.getNodeValue().trim());
                NodeList datumCodeList = datumElement.getElementsByTagName("code");
                Node datumCodeTextNode = datumCodeList.item(0).getLastChild();
                String defaultSourceDatumCode = datumCodeTextNode.getNodeValue().trim();
                NodeList projectionList = sourceElement.getElementsByTagName("projection");
                Element projectionElement = (Element)projectionList.item(0);
                NodeList projectionIndexList = projectionElement.getElementsByTagName("index");
                Node projectionIndexTextNode = projectionIndexList.item(0).getLastChild();
                defaultSourceProjection = Integer.parseInt(projectionIndexTextNode.getNodeValue().trim());
                NodeList projectionCodeList = projectionElement.getElementsByTagName("code");
                Node projectionCodeTextNode = projectionCodeList.item(0).getLastChild();
                String defaultSourceProjectionCode = projectionCodeTextNode.getNodeValue().trim();
                NodeList parametersList = sourceElement.getElementsByTagName("parameters");
                Element parametersElement = (Element)parametersList.item(0);
                defaultSourceParameters = this.readParameters(defaultSourceProjection, parametersElement);
            }
            this.upperMasterPanel.setDefaults(defaultSourceDatum, defaultSourceProjection, defaultSourceParameters);
            NodeList targetDefaults = doc.getElementsByTagName("target");
            Node targetNode = targetDefaults.item(0);
            if (targetNode.getNodeType() == 1) {
                Element targetElement = (Element)targetNode;
                NodeList datumList = targetElement.getElementsByTagName("datum");
                Element datumElement = (Element)datumList.item(0);
                NodeList datumIndexList = datumElement.getElementsByTagName("index");
                Node datumIndexTextNode = datumIndexList.item(0).getLastChild();
                defaultTargetDatum = Integer.parseInt(datumIndexTextNode.getNodeValue().trim());
                NodeList datumCodeList = datumElement.getElementsByTagName("code");
                Node datumCodeTextNode = datumCodeList.item(0).getLastChild();
                String defaultTargetDatumCode = datumCodeTextNode.getNodeValue().trim();
                NodeList projectionList = targetElement.getElementsByTagName("projection");
                Element projectionElement = (Element)projectionList.item(0);
                NodeList projectionIndexList = projectionElement.getElementsByTagName("index");
                Node projectionIndexTextNode = projectionIndexList.item(0).getLastChild();
                defaultTargetProjection = Integer.parseInt(projectionIndexTextNode.getNodeValue().trim());
                NodeList projectionCodeList = projectionElement.getElementsByTagName("code");
                Node projectionCodeTextNode = projectionCodeList.item(0).getLastChild();
                String defaultTargetProjectionCode = projectionCodeTextNode.getNodeValue().trim();
                NodeList parametersList = targetElement.getElementsByTagName("parameters");
                Element parametersElement = (Element)parametersList.item(0);
                defaultTargetParameters = this.readParameters(defaultTargetProjection, parametersElement);
            }
            this.lowerMasterPanel.setDefaults(defaultTargetDatum, defaultTargetProjection, defaultTargetParameters);
        }
        catch (SAXParseException err) {
            System.out.println("** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            System.out.println(" " + err.getMessage());
        }
        catch (SAXException e) {
            Exception x = e.getException();
            (x == null ? e : x).printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void readOptions(Document doc) {
        NodeList optionsDefaults = doc.getElementsByTagName("options");
        Node optionsNode = optionsDefaults.item(0);
        if (optionsNode.getNodeType() == 1) {
            Element optionsElement = (Element)optionsNode;
            NodeList unitsList = optionsElement.getElementsByTagName("units");
            Element unitsElement = (Element)unitsList.item(0);
            NodeList unitsIndexList = unitsElement.getElementsByTagName("index");
            Node unitsIndexTextNode = unitsIndexList.item(0).getLastChild();
            int defaultUnits = Integer.parseInt(unitsIndexTextNode.getNodeValue().trim());
            NodeList unitsValueList = unitsElement.getElementsByTagName("value");
            Node unitsValueTextNode = unitsValueList.item(0).getLastChild();
            String defaultUnitsValue = unitsValueTextNode.getNodeValue().trim();
            this.joptions.setUnits(defaultUnits);
            NodeList separatorList = optionsElement.getElementsByTagName("separator");
            Element separatorElement = (Element)separatorList.item(0);
            NodeList separatorIndexList = separatorElement.getElementsByTagName("index");
            Node separatorIndexTextNode = separatorIndexList.item(0).getLastChild();
            int defaultSeparator = Integer.parseInt(separatorIndexTextNode.getNodeValue().trim());
            NodeList separatorValueList = separatorElement.getElementsByTagName("value");
            Node separatorValueTextNode = separatorValueList.item(0).getLastChild();
            String defaultSeparatorValue = separatorValueTextNode.getNodeValue().trim();
            this.joptions.setSeparator(defaultSeparator);
            NodeList signHemisphereList = optionsElement.getElementsByTagName("signHemisphere");
            Element signHemisphereElement = (Element)signHemisphereList.item(0);
            NodeList signHemisphereIndexList = signHemisphereElement.getElementsByTagName("index");
            Node signHemisphereIndexTextNode = signHemisphereIndexList.item(0).getLastChild();
            int defaultSignHemisphere = Integer.parseInt(signHemisphereIndexTextNode.getNodeValue().trim());
            NodeList signHemisphereValueList = signHemisphereElement.getElementsByTagName("value");
            Node signHemisphereValueTextNode = signHemisphereValueList.item(0).getLastChild();
            String defaultSignHemisphereValue = signHemisphereValueTextNode.getNodeValue().trim();
            this.joptions.setSignHemi(defaultSignHemisphere);
            NodeList longitudeRangeList = optionsElement.getElementsByTagName("longitudeRange");
            Element longitudeRangeElement = (Element)longitudeRangeList.item(0);
            NodeList longitudeRangeIndexList = longitudeRangeElement.getElementsByTagName("index");
            Node longitudeRangeIndexTextNode = longitudeRangeIndexList.item(0).getLastChild();
            int defaultLongitudeRange = Integer.parseInt(longitudeRangeIndexTextNode.getNodeValue().trim());
            NodeList longitudeRangeValueList = longitudeRangeElement.getElementsByTagName("value");
            Node longitudeRangeValueTextNode = longitudeRangeValueList.item(0).getLastChild();
            String defaultLongitudeRangeValue = longitudeRangeValueTextNode.getNodeValue().trim();
            this.joptions.setRange(defaultLongitudeRange);
            NodeList precisionList = optionsElement.getElementsByTagName("precision");
            Element precisionElement = (Element)precisionList.item(0);
            NodeList precisionIndexList = precisionElement.getElementsByTagName("index");
            Node precisionIndexTextNode = precisionIndexList.item(0).getLastChild();
            int defaultPrecision = Integer.parseInt(precisionIndexTextNode.getNodeValue().trim());
            NodeList precisionValueList = precisionElement.getElementsByTagName("value");
            Node precisionValueTextNode = precisionValueList.item(0).getLastChild();
            String defaultPrecisionValue = precisionValueTextNode.getNodeValue().trim();
            this.joptions.setPrecision(defaultPrecision);
            NodeList leadingZerosList = optionsElement.getElementsByTagName("leadingZeros");
            Element leadingZerosElement = (Element)leadingZerosList.item(0);
            NodeList leadingZerosValueList = leadingZerosElement.getElementsByTagName("value");
            Node leadingZerosValueTextNode = leadingZerosValueList.item(0).getLastChild();
            boolean defaultLeadingZerosValue = Boolean.valueOf(leadingZerosValueTextNode.getNodeValue().trim());
            this.joptions.setLeadingZeros(defaultLeadingZerosValue);
        }
    }

    private CoordinateSystemParameters readParameters(int projectionType, Element parametersElement) {
        switch (projectionType) {
            case 15: 
            case 16: 
            case 22: 
            case 23: 
            case 30: 
            case 34: {
                NodeList centralMeridianList = parametersElement.getElementsByTagName("centralMeridian");
                Node centralMeridianTextNode = centralMeridianList.item(0).getLastChild();
                double centralMeridian = Double.parseDouble(centralMeridianTextNode.getNodeValue().trim());
                NodeList falseEastingList = parametersElement.getElementsByTagName("falseEasting");
                Node falseEastingTextNode = falseEastingList.item(0).getLastChild();
                double falseEasting = Double.parseDouble(falseEastingTextNode.getNodeValue().trim());
                NodeList falseNorthingList = parametersElement.getElementsByTagName("falseNorthing");
                Node falseNorthingTextNode = falseNorthingList.item(0).getLastChild();
                double falseNorthing = Double.parseDouble(falseNorthingTextNode.getNodeValue().trim());
                return new MapProjection3Parameters(projectionType, centralMeridian, falseEasting, falseNorthing);
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 27: 
            case 29: 
            case 31: {
                NodeList centralMeridianList = parametersElement.getElementsByTagName("centralMeridian");
                Node centralMeridianTextNode = centralMeridianList.item(0).getLastChild();
                double centralMeridian = Double.parseDouble(centralMeridianTextNode.getNodeValue().trim());
                NodeList originLatitudeList = parametersElement.getElementsByTagName("originLatitude");
                Node originLatitudeTextNode = originLatitudeList.item(0).getLastChild();
                double originLatitude = Double.parseDouble(originLatitudeTextNode.getNodeValue().trim());
                NodeList falseEastingList = parametersElement.getElementsByTagName("falseEasting");
                Node falseEastingTextNode = falseEastingList.item(0).getLastChild();
                double falseEasting = Double.parseDouble(falseEastingTextNode.getNodeValue().trim());
                NodeList falseNorthingList = parametersElement.getElementsByTagName("falseNorthing");
                Node falseNorthingTextNode = falseNorthingList.item(0).getLastChild();
                double falseNorthing = Double.parseDouble(falseNorthingTextNode.getNodeValue().trim());
                return new MapProjection4Parameters(projectionType, centralMeridian, originLatitude, falseEasting, falseNorthing);
            }
            case 17: {
                NodeList centralMeridianList = parametersElement.getElementsByTagName("centralMeridian");
                Node centralMeridianTextNode = centralMeridianList.item(0).getLastChild();
                double centralMeridian = Double.parseDouble(centralMeridianTextNode.getNodeValue().trim());
                NodeList standardParallelList = parametersElement.getElementsByTagName("standardParallel");
                Node standardParallelTextNode = standardParallelList.item(0).getLastChild();
                double standardParallel = Double.parseDouble(standardParallelTextNode.getNodeValue().trim());
                NodeList falseEastingList = parametersElement.getElementsByTagName("falseEasting");
                Node falseEastingTextNode = falseEastingList.item(0).getLastChild();
                double falseEasting = Double.parseDouble(falseEastingTextNode.getNodeValue().trim());
                NodeList falseNorthingList = parametersElement.getElementsByTagName("falseNorthing");
                Node falseNorthingTextNode = falseNorthingList.item(0).getLastChild();
                double falseNorthing = Double.parseDouble(falseNorthingTextNode.getNodeValue().trim());
                return new EquidistantCylindricalParameters(projectionType, centralMeridian, standardParallel, falseEasting, falseNorthing);
            }
            case 19: 
            case 32: 
            case 33: {
                NodeList centralMeridianList = parametersElement.getElementsByTagName("centralMeridian");
                Node centralMeridianTextNode = centralMeridianList.item(0).getLastChild();
                double centralMeridian = Double.parseDouble(centralMeridianTextNode.getNodeValue().trim());
                NodeList originLatitudeList = parametersElement.getElementsByTagName("originLatitude");
                Node originLatitudeTextNode = originLatitudeList.item(0).getLastChild();
                double originLatitude = Double.parseDouble(originLatitudeTextNode.getNodeValue().trim());
                NodeList scaleFactorList = parametersElement.getElementsByTagName("scaleFactor");
                Node scaleFactorTextNode = scaleFactorList.item(0).getLastChild();
                double scaleFactor = Double.parseDouble(scaleFactorTextNode.getNodeValue().trim());
                NodeList falseEastingList = parametersElement.getElementsByTagName("falseEasting");
                Node falseEastingTextNode = falseEastingList.item(0).getLastChild();
                double falseEasting = Double.parseDouble(falseEastingTextNode.getNodeValue().trim());
                NodeList falseNorthingList = parametersElement.getElementsByTagName("falseNorthing");
                Node falseNorthingTextNode = falseNorthingList.item(0).getLastChild();
                double falseNorthing = Double.parseDouble(falseNorthingTextNode.getNodeValue().trim());
                return new MapProjection5Parameters(projectionType, centralMeridian, originLatitude, scaleFactor, falseEasting, falseNorthing);
            }
            case 21: {
                NodeList centralMeridianList = parametersElement.getElementsByTagName("centralMeridian");
                Node centralMeridianTextNode = centralMeridianList.item(0).getLastChild();
                double centralMeridian = Double.parseDouble(centralMeridianTextNode.getNodeValue().trim());
                NodeList latitudeOfTrueScaleList = parametersElement.getElementsByTagName("latitudeOfTrueScale");
                Node latitudeOfTrueScaleTextNode = latitudeOfTrueScaleList.item(0).getLastChild();
                double latitudeOfTrueScale = Double.parseDouble(latitudeOfTrueScaleTextNode.getNodeValue().trim());
                NodeList scaleFactorList = parametersElement.getElementsByTagName("scaleFactor");
                Node scaleFactorTextNode = scaleFactorList.item(0).getLastChild();
                double scaleFactor = Double.parseDouble(scaleFactorTextNode.getNodeValue().trim());
                NodeList falseEastingList = parametersElement.getElementsByTagName("falseEasting");
                Node falseEastingTextNode = falseEastingList.item(0).getLastChild();
                double falseEasting = Double.parseDouble(falseEastingTextNode.getNodeValue().trim());
                NodeList falseNorthingList = parametersElement.getElementsByTagName("falseNorthing");
                Node falseNorthingTextNode = falseNorthingList.item(0).getLastChild();
                double falseNorthing = Double.parseDouble(falseNorthingTextNode.getNodeValue().trim());
                return new MercatorParameters(projectionType, centralMeridian, latitudeOfTrueScale, scaleFactor, falseEasting, falseNorthing);
            }
            case 9: 
            case 20: {
                NodeList centralMeridianList = parametersElement.getElementsByTagName("centralMeridian");
                Node centralMeridianTextNode = centralMeridianList.item(0).getLastChild();
                double centralMeridian = Double.parseDouble(centralMeridianTextNode.getNodeValue().trim());
                NodeList originLatitudeList = parametersElement.getElementsByTagName("originLatitude");
                Node originLatitudeTextNode = originLatitudeList.item(0).getLastChild();
                double originLatitude = Double.parseDouble(originLatitudeTextNode.getNodeValue().trim());
                NodeList standardParallel1List = parametersElement.getElementsByTagName("standardParallel1");
                Node standardParallel1TextNode = standardParallel1List.item(0).getLastChild();
                double standardParallel1 = Double.parseDouble(standardParallel1TextNode.getNodeValue().trim());
                NodeList standardParallel2List = parametersElement.getElementsByTagName("standardParallel2");
                Node standardParallel2TextNode = standardParallel2List.item(0).getLastChild();
                double standardParallel2 = Double.parseDouble(standardParallel2TextNode.getNodeValue().trim());
                NodeList falseEastingList = parametersElement.getElementsByTagName("falseEasting");
                Node falseEastingTextNode = falseEastingList.item(0).getLastChild();
                double falseEasting = Double.parseDouble(falseEastingTextNode.getNodeValue().trim());
                NodeList falseNorthingList = parametersElement.getElementsByTagName("falseNorthing");
                Node falseNorthingTextNode = falseNorthingList.item(0).getLastChild();
                double falseNorthing = Double.parseDouble(falseNorthingTextNode.getNodeValue().trim());
                return new MapProjection6Parameters(projectionType, centralMeridian, originLatitude, standardParallel1, standardParallel2, falseEasting, falseNorthing);
            }
            case 4: {
                NodeList originLongitudeList = parametersElement.getElementsByTagName("originLongitude");
                Node originLongitudeTextNode = originLongitudeList.item(0).getLastChild();
                double originLongitude = Double.parseDouble(originLongitudeTextNode.getNodeValue().trim());
                NodeList originLatitudeList = parametersElement.getElementsByTagName("originLatitude");
                Node originLatitudeTextNode = originLatitudeList.item(0).getLastChild();
                double originLatitude = Double.parseDouble(originLatitudeTextNode.getNodeValue().trim());
                NodeList originHeightList = parametersElement.getElementsByTagName("originHeight");
                Node originHeightTextNode = originHeightList.item(0).getLastChild();
                double originHeight = Double.parseDouble(originHeightTextNode.getNodeValue().trim());
                NodeList orientationList = parametersElement.getElementsByTagName("orientation");
                Node orientationTextNode = orientationList.item(0).getLastChild();
                double orientation = Double.parseDouble(orientationTextNode.getNodeValue().trim());
                return new LocalCartesianParameters(projectionType, originLongitude, originLatitude, originHeight, orientation);
            }
            case 24: {
                NodeList centralMeridianList = parametersElement.getElementsByTagName("centralMeridian");
                Node centralMeridianTextNode = centralMeridianList.item(0).getLastChild();
                double centralMeridian = Double.parseDouble(centralMeridianTextNode.getNodeValue().trim());
                NodeList originLatitudeList = parametersElement.getElementsByTagName("originLatitude");
                Node originLatitudeTextNode = originLatitudeList.item(0).getLastChild();
                double originLatitude = Double.parseDouble(originLatitudeTextNode.getNodeValue().trim());
                NodeList standardParallel1List = parametersElement.getElementsByTagName("standardParallel1");
                Node standardParallel1TextNode = standardParallel1List.item(0).getLastChild();
                double standardParallel1 = Double.parseDouble(standardParallel1TextNode.getNodeValue().trim());
                NodeList falseEastingList = parametersElement.getElementsByTagName("falseEasting");
                Node falseEastingTextNode = falseEastingList.item(0).getLastChild();
                double falseEasting = Double.parseDouble(falseEastingTextNode.getNodeValue().trim());
                NodeList falseNorthingList = parametersElement.getElementsByTagName("falseNorthing");
                Node falseNorthingTextNode = falseNorthingList.item(0).getLastChild();
                double falseNorthing = Double.parseDouble(falseNorthingTextNode.getNodeValue().trim());
                return new NeysParameters(projectionType, centralMeridian, originLatitude, standardParallel1, falseEasting, falseNorthing);
            }
            case 26: {
                NodeList originLatitudeList = parametersElement.getElementsByTagName("originLatitude");
                Node originLatitudeTextNode = originLatitudeList.item(0).getLastChild();
                double originLatitude = Double.parseDouble(originLatitudeTextNode.getNodeValue().trim());
                NodeList scaleFactorList = parametersElement.getElementsByTagName("scaleFactor");
                Node scaleFactorTextNode = scaleFactorList.item(0).getLastChild();
                double scaleFactor = Double.parseDouble(scaleFactorTextNode.getNodeValue().trim());
                NodeList longitude1List = parametersElement.getElementsByTagName("longitude1");
                Node longitude1TextNode = longitude1List.item(0).getLastChild();
                double longitude1 = Double.parseDouble(longitude1TextNode.getNodeValue().trim());
                NodeList latitude1List = parametersElement.getElementsByTagName("latitude1");
                Node latitude1TextNode = latitude1List.item(0).getLastChild();
                double latitude1 = Double.parseDouble(latitude1TextNode.getNodeValue().trim());
                NodeList longitude2List = parametersElement.getElementsByTagName("longitude2");
                Node longitude2TextNode = longitude2List.item(0).getLastChild();
                double longitude2 = Double.parseDouble(longitude2TextNode.getNodeValue().trim());
                NodeList latitude2List = parametersElement.getElementsByTagName("latitude2");
                Node latitude2TextNode = latitude2List.item(0).getLastChild();
                double latitude2 = Double.parseDouble(latitude2TextNode.getNodeValue().trim());
                NodeList falseEastingList = parametersElement.getElementsByTagName("falseEasting");
                Node falseEastingTextNode = falseEastingList.item(0).getLastChild();
                double falseEasting = Double.parseDouble(falseEastingTextNode.getNodeValue().trim());
                NodeList falseNorthingList = parametersElement.getElementsByTagName("falseNorthing");
                Node falseNorthingTextNode = falseNorthingList.item(0).getLastChild();
                double falseNorthing = Double.parseDouble(falseNorthingTextNode.getNodeValue().trim());
                return new ObliqueMercatorParameters(projectionType, originLatitude, longitude1, latitude1, longitude2, latitude2, falseEasting, falseNorthing, scaleFactor);
            }
            case 28: {
                NodeList longitudeDownFromPoleList = parametersElement.getElementsByTagName("longitudeDownFromPole");
                Node longitudeDownFromPoleTextNode = longitudeDownFromPoleList.item(0).getLastChild();
                double longitudeDownFromPole = Double.parseDouble(longitudeDownFromPoleTextNode.getNodeValue().trim());
                NodeList latitudeOfTrueScaleList = parametersElement.getElementsByTagName("latitudeOfTrueScale");
                Node latitudeOfTrueScaleTextNode = latitudeOfTrueScaleList.item(0).getLastChild();
                double latitudeOfTrueScale = Double.parseDouble(latitudeOfTrueScaleTextNode.getNodeValue().trim());
                NodeList falseEastingList = parametersElement.getElementsByTagName("falseEasting");
                Node falseEastingTextNode = falseEastingList.item(0).getLastChild();
                double falseEasting = Double.parseDouble(falseEastingTextNode.getNodeValue().trim());
                NodeList falseNorthingList = parametersElement.getElementsByTagName("falseNorthing");
                Node falseNorthingTextNode = falseNorthingList.item(0).getLastChild();
                double falseNorthing = Double.parseDouble(falseNorthingTextNode.getNodeValue().trim());
                return new PolarStereographicParameters(projectionType, longitudeDownFromPole, latitudeOfTrueScale, falseEasting, falseNorthing);
            }
            case 0: {
                NodeList heightTypeList = parametersElement.getElementsByTagName("heightType");
                Node heightTypeTextNode = heightTypeList.item(0).getLastChild();
                int heightType = Integer.parseInt(heightTypeTextNode.getNodeValue().trim());
                return new GeodeticParameters(projectionType, heightType);
            }
            case 7: {
                NodeList overrideList = parametersElement.getElementsByTagName("override");
                Node overrideTextNode = overrideList.item(0).getLastChild();
                int override = Integer.parseInt(overrideTextNode.getNodeValue().trim());
                NodeList zoneList = parametersElement.getElementsByTagName("zone");
                Node zoneTextNode = zoneList.item(0).getLastChild();
                int zone = Integer.parseInt(zoneTextNode.getNodeValue().trim());
                return new UTMParameters(projectionType, zone, override);
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 25: 
            case 35: {
                return new CoordinateSystemParameters(projectionType);
            }
        }
        return null;
    }
}

