/*  $Id$
    Object containing an array of Pixmaps and masks.

    gengameng - Generic 2D Game Engine library
    Copyright (C) 1999 Pierre Sarrazin <sarrazip@iname.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA.
*/

#include "PixmapArray.h"

#include <assert.h>


PixmapArray::PixmapArray(Pixmap imagesArray[], Pixmap masksArray[], size_t size)
  : images(imagesArray),
    masks(masksArray),
    arraySize(size),
    imageSize(0, 0)
{
    assert(images != NULL);
    assert(masks != NULL);
    assert(size > 0);
}


PixmapArray::PixmapArray(size_t numImages)
  : images(new Pixmap[numImages]),
    masks(new Pixmap[numImages]),
    arraySize(numImages),
    imageSize(0, 0)
{
    assert(images != NULL);
    assert(masks != NULL);
    assert(numImages > 0);
}


/*static*/ void
PixmapArray::freePixmap(Pixmap pm)
{
    SDL_FreeSurface(pm);
}


void
PixmapArray::freePixmaps()
{
    if (images != NULL)
    {
	for (size_t i = 0; i < arraySize; i++)
	    freePixmap(images[i]);
	delete [] images;
	images = NULL;
    }
    if (masks != NULL)
    {
	for (size_t i = 0; i < arraySize; i++)
	    freePixmap(masks[i]);
	delete [] masks;
	masks = NULL;
    }

    arraySize = 0;
}


PixmapArray::~PixmapArray()
{
    freePixmaps();
}


void
PixmapArray::setArrayElement(size_t i, Pixmap image, Pixmap mask)
{
    assert(i < arraySize);
    assert(image);

    assert(images != NULL);
    assert(masks != NULL);

    images[i] = image;
    masks[i] = mask;
}


void
PixmapArray::setImageSize(Couple size)
{
    assert(size.x != 0 && size.y != 0);
    imageSize = size;
}
