/*
** $Id: shell_struct.h,v 1.3 2001/04/25 17:17:00 mhucka Exp $
** $Log: shell_struct.h,v $
** Revision 1.3  2001/04/25 17:17:00  mhucka
** Misc. small changes to improve portability and address compiler warnings.
**
** Revision 1.2  2000/06/19 06:06:26  mhucka
** The Script structure and the handling of scripts had this bogosity in which
** FILE pointers were being cast to char * and back again.  Why on earth
** didn't the authors just keep a separate pointer in the Script structure for
** FILE pointers, instead of shoehorning the pointers into the .ptr char *
** field?  Anyway, for better robustness and portability, I reimplemented this
** part using two separate pointers.
**
** Revision 1.1  1992/12/11 19:04:55  dhb
** Initial revision
**
*/

#ifndef SHELL_STRUCT_H
#define SHELL_STRUCT_H

#ifndef PFI_DEFINED
#define PFI_DEFINED
typedef int	(*PFI)();
#endif

typedef struct _EscapeCommand {
    char	*escseq;
    char	*string;
    int		argc;
    char	**argv;
    int		exec_mode;
    char	*id;
    struct _EscapeCommand *next;
} EscapeCommand;

typedef struct script_type {
    char	*ptr;
    char	*current;
    short	type;
    int		argc;
    char	**argv;
    short	line;
    FILE        *file;
} Script;

typedef struct func_table_type {
	char 	*name;
	PFI	adr;
	char 	*type;
} FuncTable;

typedef struct {
    char 	*name;
    char 	*type;
    short 	offset;
    short 	type_size;
    short 	field_indirection;
    short 	function_type;
    short 	dimensions;
    int 	dimension_size[4];
} Info;

typedef struct {
    PFI		function;
    int		count;
    int		priority;
} Job; 


#endif
