static char rcsid[] = "$Id: sim_reset.c,v 1.5 1997/07/18 02:58:25 dhb Exp $";

/*
** $Log: sim_reset.c,v $
** Revision 1.5  1997/07/18 02:58:25  dhb
** Fix for getopt problem; getopt(), optopt and optind are now
** G_getopt(), G_optopt and G_optind.
**
** Revision 1.4  1994/09/16 20:27:00  dhb
** Moved RESET code for projection connections into projection RESET
** action.
**
** The ResetElements() function which appears to be old code, also performed
** the same function.  Removed it there too.  Actually, the code here was in
** error, calling the CHECK action instead of RESET.
**
 * Revision 1.3  1993/06/29  18:53:23  dhb
 * Extended objects (incomplete)
 *
 * Revision 1.2  1993/02/12  23:32:11  dhb
 * 1.4 to 2.0 command arg changes:
 * 	do_reset (reset) no changes necessary
 * 	do_reset_simstate (not addfunced) no changes
 * 	do_reset_elements (not addfunced, but looks like a way to call
 * 		the RESET action for a set of elements) added calls to
 * 		getopt routines
 *
 * Revision 1.1  1992/10/27  20:25:39  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"

SimReset()
{
PFI			func;
Element			*element;
ElementStack		*stk;
Action			*action;
int			i;

    SetCurrentStep(0);
    simulation_time = 0;
    StepStatus();
    SetBreakFlag();
    ResetErrors();
    Reschedule();
/*
    CheckSimulation();
*/
    ResetTmin();

    action = GetAction("RESET");

    /*
    ** reset each element
    */
    stk = NewPutElementStack(RootElement());
    while((element=NewFastNextElement(3,stk)) != NULL){
	/*
	** get the element reset function
	*/
	if((func = GetActionFunc(element->object,RESET,NULL,NULL)) != NULL){
	    if (!IsHsolved(element)) {
			CallActionFunc(element, action);
		}
	}
    }
    NewFreeElementStack(stk);
}

ResetTmin()
{
ElementStack	*stk;
Element	*element;

    stk = NewPutElementStack(RootElement());
    /*
    ** go through all elements 
	**
	** Bugfix by Upi Bhalla 16 Jul 1991 :
	** flag here is set to 0 to cause proper
	** reset for passive buffers involved in higher order integ methods
    */
    while(element = NewNextElement(2,BUFFER_ELEMENT,stk)){
	/*
	** clear the tmin of the buffers on this element
	*/
	((Buffer *)element)->tmin = 0;
	/*
	** Upi Bhalla 18 Jul 1991
	** Another bugfix : completely reset the passive buffers.
	*/
	if (strcmp(element->object->name,"passive_buffer") == 0)
		ClearBuffer(element);
    }
    NewFreeElementStack(stk);
}

ResetSimState()
{
    SetCurrentStep(0);
    simulation_time = 0;
    StepStatus();
    SetBreakFlag();
    ResetErrors();
    Reschedule();
    ResetTmin();

}

ResetElements(list)
ElementList *list;
{
PFI			func;
Element			*element;
Action			*action;
int			i;

    action = GetAction("RESET");

    /*
    ** reset each element
    */
    for(i=0;i<list->nelements;i++){
	element = list->element[i];
	/*
	** get the element reset function
	*/
	if((func = GetActionFunc(element->object,RESET,NULL,NULL)) != NULL){
	    CallActionFunc(element, action);
	}
    }
}

do_reset()
{
    SimReset(); 
}

do_reset_simstate()
{ 
    ResetSimState(); 
}

do_reset_elements(argc,argv) 
int argc;
char **argv;
{ 
ElementList *list;

    initopt(argc, argv, "path");
    if (G_getopt(argc, argv) < 0)
      {
	printoptusage(argc, argv);
	return;
      }

    list = WildcardGetElement(optargv[1],1);
    ResetElements(list);
    FreeElementList(list);
}
