/* $Id */
/* $Log: xo_hash.c,v $
 * Revision 1.3  1994/11/07 22:27:47  bhalla
 * Added in another error check for xo_hash_find
 *
 * Revision 1.2  1994/02/02  20:26:05  bhalla
 * *** empty log message ***
 *
 * Revision 1.2  1994/02/02  20:26:05  bhalla
 * *** empty log message ***
 * */

/* Elmhash.c : this is very similar to Matt's version of the hash
** stuff, only I have munged it to handle pointers (normally used for
** elements) rather than character strings.
** Upi Bhalla, Mount Sinai, June 1993
*/

#include <stdio.h>
#include <math.h>
/*
#ifdef IRIS
#include <strings.h>
#else
#include <string.h>
#endif
*/
#include "hash.h"
/* mds3 changes */
/*
#include "system_deps.h"
*/

/*
** put in wraparound during the hash entry and search
*/

xo_hash_function(key,table)
char *key;
HASH *table;
{
int val = (int)key;
	return(((val & 0xff) | (val >> 8)) % table->size);
}

/* this one does not need to change from Matt's version
HASH *hash_create(size)
int size;
{
HASH *hash_table;

	hash_table = (HASH *)calloc(size,sizeof(HASH));
	hash_table->size = size;
	hash_table->entry = (ENTRY *)calloc(size+1,sizeof(ENTRY));
	return(hash_table);
}
*/

ENTRY *xo_hash_find(key,table)
char *key;
HASH *table;
{
int size;
ENTRY *hash_ptr;
ENTRY *start_ptr;

	if(key == NULL || table == NULL || table->size <= 0) return(NULL);
	start_ptr = hash_ptr = table->entry + xo_hash_function(key,table);
	size = table->size;
	while(hash_ptr->key){
		if(key == hash_ptr->key){
			return(hash_ptr);
		}
		if(++hash_ptr >= table->entry + size) hash_ptr = table->entry;
		if(hash_ptr == start_ptr){
			return(NULL);
		}
	}
	return(NULL);
}

ENTRY *xo_hash_enter(item,table)
ENTRY *item;
HASH *table;
{
int size;
ENTRY *hash_ptr;
ENTRY *start_ptr;
char *key;

	if(item == NULL || table == NULL) return(NULL);
	/*
	** look for the next available spot
	*/
	key = item->key;
	start_ptr = hash_ptr = table->entry + xo_hash_function(key,table);
	size = table->size;
	while(hash_ptr->key){
		/*
		** copy over existing keys if they exist
		*/
		if(key==hash_ptr->key){
			break;
		}
		if(++hash_ptr >= table->entry + size) hash_ptr = table->entry;
		if(hash_ptr == start_ptr){
			return(NULL);
		}
	}
	/*
	** leave the last entry empty to identify the end of the table
	*/
	bcopy(item,hash_ptr,sizeof(ENTRY));
	return(hash_ptr);
}

