//genesis
/**********************************************************************
** This program is part of kinetikit and is
**           copyright (C) 1995-1997 Upinder S. Bhalla.
** It is made available under the terms of the GNU General Public License. 
** See the file COPYRIGHT for the full notice.
**********************************************************************/

/* By Upinder S. Bhalla, Mount Sinai School of Medicine */
// this file sets up the basic X interface for kkit

int auto_plot = 1
 
int EX = WINWID/2 - BORDER // x position for edit windows
int GH = WINHT/3 - BORDER  // height of graphs
int EY = GH // y position for edit windows
int EW = WINWID/2 - BORDER // width of edit windows
int TW = WINWID/2 - BORDER // Width of title bar.
int TH = 200 // height of title bar
int TB = TH + WMH + 2 * BORDER 
int EDW = WINWID/2 - BORDER // width of edit/draw window
int EDH = WINHT - TB - BORDER - WMH // height of edit/draw window

include xcontrol.g
include xcomparemodel.g

function do_warning(is_cline,text)
	int is_cline
	str text
	if (is_cline)
		echo {text}
	else 
		setfield /warning/label label {text}
		xshowontop /warning
		xflushevents
	end
end

function edit_object(elm)
	str elm

	echo in edit_object {elm}
end

function drag_from_lib(dest,destval,srcval,x,y,z)
	str dest,destval,srcval
	float x,y,z

	str destclass

	echo in drag_from_lib {dest} {destval} {srcval}
	if ({strncmp {dest} "/edit/draw" 10} == 0)
		if ({strlen {destval}} == 0)
			destclass = "group"
			destval = "/kinetics"
		else
			destclass = {getfield {destval} object->name}
		end
		echo srcval = {srcval} destclass = {destclass}
		if ({strcmp {getdefault {srcval} manageclass} {destclass}} == 0)
			create {srcval} {destval}/{srcval} -autoindex
			call /edit/draw/tree RESET

			if ({exists {el ^} "link_to_manage"})
				callfunc {getfield {el ^} link_to_manage} \
					{el ^} {destval} {x} {y} {z}
			else
				call /edit/draw/tree MOVECUSTOM {el ^} {x} {y} {z} 1
			end
		else
			do_warning 0 {{srcval} @ "s must be created on a " @ \
				{getdefault {srcval} manageclass}}
				return
		end
		/* Set the clock for the new element */
		useclock {el ^} {SIMCLOCK}
		/* Edit the new element */
		callfunc {getfield {el ^} editfunc} {el ^}
	end
end

function drag_from_edit(dest,srcval,x,y,z)
	str dest,srcval
	float x,y,z

	int movekids = 1

	// echo in drag_from_edit {src} {dest} {srcval}
	if ({exists {srcval} movealone})
		movekids = 1 - {getfield {srcval} movealone}
	end
		
	if ({strcmp {dest} "/edit/draw"} == 0)
		call /edit/draw/tree MOVECUSTOM {srcval} {x} {y} {z} {movekids}
	end
end

function edit_elm(elm)
	callfunc {getfield {elm} editfunc} {elm}
end

function edit_obj(obj)
	echo in edit_obj with {obj}
end




function make_xedit
	/* Create the editor form */
    create xform /edit [0,{TB},{EDW},{EDH}]
	create xcoredraw /edit/draw [0,0,100%,100%] \
		-xmin -5 -xmax 5 -ymin -5 -ymax 5 -fg black
	create xtree /edit/draw/tree
		setfield ^ \
			treemode custom \
			path "/kinetics/##[]" \
			hlmode none \
		script "edit_elm.D <v>; drag_from_edit.w <d> <S> <x> <y> <z>"

		/* get rid of the default settings */
		call ^ ADDMSGARROW "" "" "" "" none 0 0 "" "" ""
	disable /edit
//    xshow /edit
end

function make_xlibrary
	/* creating the library form */
	/* The lib is now located in /control */
	// create xform /lib [1,115,250,200]
	create xcoredraw /control/lib [0,0:runtime,100%,0:NULL.bottom] \
		-xmin -1 -xmax 8 -ymin -1 -ymax 1
	create xtree /control/lib/tree
	setfield /control/lib/tree \
		path "kpool kreac kenz stim group xtab kchan" \
		treemode obj_grid \
		orientation r \
		sizescale 0.4 \
		script "drag_from_lib.w <d> <D> <S> <x> <y> <z>; edit_obj.D <v>"
	disable /control/lib
	// xshow /lib
end

function make_xclipboard
	create xform /clipboard [255,115,250,200]
	create xcoredraw /clipboard/draw [0,0,100%,100%] \
		-xmin -10 -xmax 10  -ymin -3 -ymax 1.5 \
		-fg black
	create xtree /clipboard/draw/tree
	setfield /clipboard/draw/tree \
		path "/kclip/##[]" \
		treemode custom \
		sizescale 0.4 \
		script "drag_from_clip.w <d> <S> <x> <y> <z>; edit_elmD <v>"
	disable /clipboard
end

function do_copy(elm)
	str elm
	if ({strcmp {getpath {elm} -head} "/edit/draw"} == 0)
		copy  {elm} {elm}/.. -autoindex
	end
	/*
	str name

	foreach name ({el /edit/draw/tree -listname select_elist})
		copy {name} {name}/.. -autoindex
	end
	*/
	call /edit/draw/tree RESET
end

function do_delete(src,elm)
	str src,elm
	// echo deleting {elm} from {src}
	if (({strncmp {src} "/edit/draw/" 11} == 0))
		delete  {elm}
		call /edit/draw/tree RESET
	end

	/*
	str name

	foreach name ({el /edit/draw/tree -listname select_elist})
		delete {name}
	end
	*/
end

function make_xedittools
// This also uses /control/lib as the parent draw widget
	create xgif /control/lib/del -filename del.gif \
		-tx 7 \
		-script "do_delete.p <s> <S>"
end


function make_xwarning
    create xform /warning [100,400,700,100]
    create xlabel /warning/label -title "Warning" -hgeom 50%
    create xbutton /warning/done [40%,60,20%,30%] -label "OK" \
        -script "xhide /warning"
	disable /warning
end

function make_xinform
    create xform /inform [200,500,500,100]
    create xlabel /inform/label -title "hello" [0,0,100%,100%]
	create xbutton /inform/ok -title "OK" [40%,40%,20%,40%] \
    	 -script "xhide /inform"
	disable /inform
end

function do_inform(text)
	str text
	setfield /inform/label label {text}
	xshowontop /inform
	xflushevents
end

function set_field(widget,value)
	str widget,value

	str elm = {getfield {{widget} @ "/.."} elmpath}
	str field = {getfield {widget} name}
	setfield {elm} {field} {value}
end

function set_item_name(widget,value)
	str widget,value

	str elm = {getfield {widget}/.. elmpath}
	str nm = {getpath {elm} -tail}

	if ({strcmp {nm} {value}} == 0)
		return
	end
	if ({exists {elm}/../{value}})
		do_warning 0 {"Rename failed. Element " @ {nm} @ \
			" already exists."}
		return
	end
	move {elm} {elm}/../{value}
	callfunc {getfield {el ^} editfunc} {el ^}
	call /edit/draw/tree RESET
end

function save_item_notes(widget)
	str widget
	str elm = {getfield {{widget} @ "/.."} elmpath}

	call {widget}/../notes PROCESS
	setfield {elm} notes {getfield {widget}/../notes initialtext}
end

function set_item_color(widget,color)
	str widget,color

	str elm = {getfield {{widget} @ "/.."} elmpath}
	str kids
	str manager
	str elmclass = {getfield {elm} object->name}

/* We need to change the plot colors here */

/* Changing the color of the elm */
	setfield {elm} xtree_fg_req {color}

/* Changing the textcolor of the elm kids */
	foreach kids ({el {elm}/#[]})
		manager = {getfield {kids} manageclass}
		if ({strcmp {manager} {elmclass}} == 0)
			setfield {kids} xtree_textfg_req {color}
		end
	end
	call /edit/draw/tree RESET
end

function xbegin
	/* Set the global flag for the interface to 1 */

	/* build the colorscale */
	xcolorscale rainbow2

	/* set up the postscript stuff */
	setpostscript -filename "display.ps" -inverse 0

	make_xedit
	// make_xclipboard
	create neutral /parmedit
	disable /parmedit
	make_xwarning
	make_xinform
	make_xcontrol
	make_xlibrary
	make_xfile
	//make_xgraphs
	make_opencontrol
	make_plotcontrol
	make_pscontrol
	make_comparecontrol
	make_simcontrol
	make_simhelp
	make_xedittools
	make_editcontrol
	make_toolcontrol

	simobjdump xtree path script namemode sizescale
	simobjdump xcoredraw xmin xmax ymin ymax
	simobjdump xtext editable
end

function xmiddle
end

function xend
	xhide /about
	xshow /edit
	xshow /control
	xshow /graphs
	call /edit/draw/tree RESET
	call /control/lib/tree RESET
	setfield /edit/draw/tree sizescale 0.6
	setfield /control/lib/tree sizescale 0.4
end
