/*
  methods.h - Interface for method handlers.

  Copyright (C) 2001 Free Software Foundation

  This file is part of the GNU Enterprise Application Server (GEAS)

  GEAS is free software; you can redistribute it and/or modify it under
  the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2, or (at your option) any later
  version.

  GEAS is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
  for more details.

  You should have received a copy of the GNU General Public License
  along with GEAS; if not, write to the Free Software Foundation, Inc.,
  59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

  $Id: methods.h,v 1.7 2001/06/08 22:42:42 reinhard Exp $
*/

#ifndef METHODS_H
#define METHODS_H

#include "config/configuration.h"
#include "geas-skeleton.h"

/* TODO: this section will need significant changes for dynamic loading of
 * modules, esp. during transactions */

gboolean initialise_method_handling (configuration config);
gboolean load_method_handlers (configuration config);
gboolean shutdown_method_handling (void);   /* TODO */

/* assumes everything has been validated already */
CORBA_char *execute_method (GEAS_object_reference * obj,
                            const char *methodname,
                            GEAS_Arguments * args, CORBA_Environment * ev);

#endif
