
/**************/
/* structures */
/**************/

struct transform_pak
{
gint id;
gdouble matrix[9];
gdouble vector[3];
gdouble scalar;
};

/**************/
/* prototypes */
/**************/

gint core_match(const gchar *, struct core_pak *);
gint shel_match(const gchar *, struct shel_pak *);
gint pair_match(const gchar *, const gchar *,
                struct core_pak *, struct core_pak *);

void info_bond(GtkWidget *, gint, gint, struct model_pak *);
void info_dist(gint, gint, struct model_pak *);
void info_angle(gint, gint, struct model_pak *);
void info_torsion(gint, gint, struct model_pak *);

void elem_change_colour(GtkWidget *, gpointer *);

gint copy_gulp_data(struct model_pak *, struct model_pak *);
gint copy_gulp_extra(struct model_pak *, struct model_pak *);
gint free_gulp_data(struct model_pak *);

gint search_basename(const gchar *);
gint dialog_active(gint);

void unhide_atoms(void);

void type_model(const gchar *, struct model_pak *);

void connect_page(GtkWidget *);
void periodicity_page(GtkWidget *);

