from utils.datatypes import *
from utils import i18n

from MetaSensor import MetaSensor

import commands, urllib, os, feedparser, re, string, time, threading

is_wrappable=0
try:
    from textwrap import TextWrapper
    is_wrappable=1
except:
    print "textwrap is not installed, upgrade to python 2.3"

#=====================================================================
# Implements an RSS reader
# Inspired by and (initially) based on rss-0.1 by dweazle
# Dave Masterson, Dec 2003
#
# Many parts added by gsergiu, Jan 2004, related to clickable 
# headlines - many thanks :-)
#
# Thanks to code error-checking suggestions fron Russ Nelson
# Thanks to Cyril Russo for unicode handling stuff
#=====================================================================
class RssSensor2(MetaSensor):

    # Setup the Sensor
    def __init__(self, *args):

        global _; _ = i18n.Translator("rss-desklet")
        
        # initialise the MetaSensor 
        MetaSensor.__init__(self,
                            self.__get_news_thread, 
                            lambda : int(self._get_config("update")) * 60,
                            self.__display_data)       

        # initial default values
        self.__state = {'baretitle' : 'Connecting',
                        'lutime'    : '00:00',
                        'maintitle' : 'Connecting\n(updated @ 00:00)',
                        'titles'    : [],
                        'links'     : []
                       }

        self.__last_state = {}

        if (is_wrappable):
            # Create the sensors text-wrapper
            self.__wrapper = TextWrapper()
            self.__wrapper.initial_indent = "[$] "

        # Default values for config
        self._set_config_type("url", TYPE_STRING, "http://www.slashdot.org/index.rss")
        self._set_config_type("browser", TYPE_STRING, "mozilla")
        self._set_config_type("update", TYPE_INT, 30)
        self._set_config_type("wrapwidth", TYPE_INT, 60)
        self._set_config_type("font", TYPE_STRING, "Arial 8")
        self._set_config_type("fontcolor", TYPE_STRING, "#00FF00")
        self._set_config_type("titlefont", TYPE_STRING, "Arial 12")
        self._set_config_type("titlefontcolor", TYPE_STRING, "#FFFF00")
        self._set_config_type("highlightfont", TYPE_STRING, "Arial 10")
        self._set_config_type("highlightfontcolor", TYPE_STRING, "#FFFFFF")

        # go grab the feed
        self._start()

    def __get_news_thread(self):
        
        # get the config values        
        url = self._get_config("url")
        myupdate = int(self._get_config("update")) * 60

        # Call the parser to populate rssdata
        rssdata = feedparser.parse(url)


        # Get the channel name
        if rssdata['channel'].has_key('title'):
            self.__state['maintitle'] = "%s\n(updated @ %s)" % (rssdata['channel']['title'], time.strftime("%H:%M"))
        else:
            self.__state['maintitle'] = "Title not found\n(updated @ %s)" % time.strftime("%H:%M")

        print "RSSDEBUG: got maintitle"

        # Clear the arrays
        self.__state['titles'] [0:] = []
        self.__state['links']  [0:] = []
 
        # get the headlines    
        for item in rssdata['items']:
            wtitle = ""
         
            print "RSSDEBUG: got headline"
 
            if item.has_key('title'):
                title = item['title']
            else:
                title = "Headline not found"

            # can we text wrap or not?
            if (is_wrappable):
                self.__wrapper.width = int(self._get_config("wrapwidth"))
                for bit in self.__wrapper.wrap(title):
                    wtitle = wtitle + bit.strip() + '\n'
            else:
                wtitle = title + '\n'

            #add link and titles to appropriate arrays
            self.__state['titles'].append(wtitle[:-1])
            self.__state['links'].append(item['link'])

        # do we need to display the data?
        if self.__state != self.__last_state:
            print "RSSDEBUG: New items - call display!!"
            self.__last_state = self.__state.copy()
            return True

        return False



    # Get the RSS feed, parse it and send it to the display
    def __display_data(self):

        # Send the title to the display
        output = self._new_output()

        print "RSSDEBUG: Displaying the following data:\n%s" % (self.__state['maintitle'])

        output.set("name", self.__state['maintitle'])
        output.set("namefont", self._get_config("titlefont"))
        output.set("namecolor", self._get_config("titlefontcolor"))

        # iterate through headlines and display them...    
        index = 0
        for headline in self.__state['titles']:
            output.set("item_value[%(index)d]" % vars(), self.__state['titles'][index])
            output.set("font[%(index)d]" % vars(), self._get_config("font"))
            output.set("color[%(index)d]" % vars(), self._get_config("fontcolor"))
            index = index+1

        self._send_output(output)

 
    # override this ethod to enable user interaction
    def call_action(self, action, path, args = []):

        index = int(path[-1])
        if (action == "launch"):
            try:
                # open the link in specified browser
                browser = self._get_config("browser");
                url = self.__state['links'][index]
                
                #allow '&' chars in urls...
                p = re.compile('&')
                nurl = p.sub('\&', url, 0)
                threading.Thread(target=os.system, args=("%s %s" % (browser,nurl),)).start()
                print "Opening %s with %s" % (url, browser)

            except Exception, e:
                  print "could not open %s -> %s" % (url,e)

        elif (action == "leave"):
            output = self._new_output()
            output.set("item_value[%(index)d]" % vars(), self.__state['titles'][index])
            output.set("font[%(index)d]" % vars(), self._get_config("font"))
            output.set("color[%(index)d]" % vars(), self._get_config("fontcolor"))
            self._send_output(output)

        elif (action == "enter"):
            output = self._new_output()
            output.set("item_value[%(index)d]" % vars(), self.__state['titles'][index])
            output.set("font[%(index)d]" % vars(), self._get_config("highlightfont"))
            output.set("color[%(index)d]" % vars(), self._get_config("highlightfontcolor"))
            self._send_output(output)

    # Add extra config fields
    def get_configurator(self):

        conf1 = self._new_configurator()
        conf1.set_name(_("Rss Settings"))
        conf1.add_title(_("Rss Source URL"))
        conf1.add_entry(_("URL",), "url", _("The url of the rss feed"))
        conf1.add_title(_("Interval between Rss updates (minutes)"))
        conf1.add_spin(_("Interval",), "update", _("The interval between updates (minutes)"),1,60)
        conf1.add_title(_("Max Headline Width (Python 2.3+ only)"))
        conf1.add_spin(_("Width",), "wrapwidth", _("The max number of columns before wrapping"),1,500)
        conf1.add_title(_("Preferred Browser"))
        conf1.add_entry(_("Browser",), "browser", _("The browser to use to view headlines clicked on"))
        conf1.add_title(_("Fonts"))
        conf1.add_font_selector(_("Title font :"),"titlefont", _("Font used in the title"))
        conf1.add_color_selector(_("Title font color :"),"titlefontcolor", _("Color used in the title"))
        conf1.add_font_selector(_("List font :"),"font", _("Font used in the url list"))
        conf1.add_color_selector(_("List font color :"),"fontcolor",_("Color used in the url list"))
        conf1.add_font_selector(_("Highlight font :"),"highlightfont", _("Font used to highlight link"))
        conf1.add_color_selector(_("Highlight font color :"),"highlightfontcolor", _("Color used to highlight link"))

        return conf1

# Advertise the sensor
def new_sensor(args): return RssSensor2(*args)
