# TODO: separator height is 2 (after 0.33)
# TODO: graph color set in xml (after 0.33)
# TODO: i18n (not anytime soon)
# TODO: dynamic themes list (dynamic properties)
# TODO: turn off separators when turning on borders (dead code for now :()
# TODO: all other themes

cf_width, cf_height = (200, 60)
cf_b_top, cf_b_bottom, cf_b_right, cf_b_left = (False, False, True, True)
cf_sep_show, cf_sep_size, cf_sep_type = (False, 5, "horizontal")
cf_theme, cf_side = ("ltv", "left")
cf_font = "Bitstream Vera Sans 12"
cf_command = ""

pcolor, scolor = ("#000000", "#000000")
icon_offsets = [0, 0, 0, 0]
content_offsets = [0, 0, 0, 0]
borders = [0, 0, 0, 0]
step_width, step_count = (1, 1)

def theme(s):
    return "gfx/themes/%s/%s"%(cf_theme, s)

def watch_prefs(key, value):
    global cf_sep_show
    if key == "cf_b_right" and value and cf_sep_type == "vertical":
        cf_sep_show = False
    if key == "cf_b_bottom" and value and cf_sep_type == "horizontal":
        cf_sep_show = False
    if key == "cf_sep_show" and value:
        if cf_sep_type == "vertical": cf_b_right = False
        if cf_sep_type == "horizontal": cf_b_bottom = False
    if key == "cf_sep_type" and cf_sep_show:
        if value == "vertical": cf_b_right = False
        if value == "horizontal": cf_b_bottom = False
    setup_theme()
    setup_sizes()
    setup_borders()
    setup_layout()
    setup_separator()
    try:
        setup_graph()
    except: pass
    try:
        setup_gauge()
    except: pass
    try:
        setup_local()
    except: pass

def setup_theme():
    global borders
    global pcolor, scolor
    Dsp.separator_h.uri = theme("separator-h.png")
    Dsp.separator_v.uri = theme("separator-v.png")
    Dsp.background.uri = theme("background.png")
    Dsp.theme_border_tl.uri = theme("top-left.png")
    Dsp.theme_border_br.uri = theme("bottom-right.png")
    Dsp.colors.uri = theme("colors.svg")
    pcolor = svg_color(Dsp.colors.dom.get("primary")["style"])
    scolor = svg_color(Dsp.colors.dom.get("secondary")["style"])
    wtl = Dsp.theme_border_tl.width.as_px()
    htl = Dsp.theme_border_tl.height.as_px()
    wbr = Dsp.theme_border_br.width.as_px()
    hbr = Dsp.theme_border_br.height.as_px()
    Dsp.main.border_width = [Unit(wtl, PX), Unit(htl, PX),
                             Unit(wbr, PX), Unit(hbr, PX)]
    borders = [wtl, htl, wbr, hbr]

def setup_sizes():
    global icon_offsets, content_offsets
    io = [0, 0, 0, 0]
    co = [0, 0, 0, 0]
    w, h = (cf_width, cf_height)
    Dsp.main.width = Unit(w, PX)
    Dsp.main.height = Unit(h, PX)
    if cf_b_left:
        io[0] = borders[0]/2
        co[0] = borders[0]
    if cf_b_top:
        io[1] = borders[1]/2
        co[1] = io[1]
    if cf_b_right:
        io[2] = borders[2]/2
        co[2] = borders[2]
    if cf_b_bottom:
        io[3] = borders[3]/2
        co[3] = io[3]
    if cf_sep_show:
        if cf_sep_type == "vertical":
            io[2] = max(cf_sep_size, io[2])
            co[2] = max(cf_sep_size, co[2])
        if cf_sep_type == "horizontal":
            io[3] = max(cf_sep_size, io[3])
            co[3] = io[3]
    icon_offsets = io
    content_offsets = co

def setup_borders():
    b = range(8)
    for i in range(8): b[i] = theme("background.png")
    if cf_b_left:
        b[0] = theme("left.png")
        if not cf_b_top: b[4] = theme("left.png")
        if not cf_b_bottom: b[7] = theme("left.png")
    if cf_b_top:
        b[1] = theme("top.png")
        if not cf_b_left: b[4] = theme("top.png")
        if not cf_b_right: b[5] = theme("top.png")
    if cf_b_right:
        b[2] = theme("right.png")
        if not cf_b_top: b[5] = theme("right.png")
        if not cf_b_bottom: b[6] = theme("right.png")
    if cf_b_bottom:
        b[3] = theme("bottom.png")
        if not cf_b_right: b[6] = theme("bottom.png")
        if not cf_b_left: b[7] = theme("bottom.png")
    if cf_b_left and cf_b_top: b[4] = theme("top-left.png")
    if cf_b_top and cf_b_right: b[5] = theme("top-right.png")
    if cf_b_right and cf_b_bottom: b[6] = theme("bottom-right.png")
    if cf_b_bottom and cf_b_left: b[7] = theme("bottom-left.png")
    Dsp.main.border_uris = b

def setup_layout():
    w = cf_width - icon_offsets[0] - icon_offsets[2]
    h = cf_height - icon_offsets[1] - icon_offsets[3]
    s = min(w, h)
    ss = int(0.9*s)
    Dsp.icon.y = Unit(icon_offsets[1], PX)
    Dsp.icon.width = Unit(s, PX)
    Dsp.icon.height = Unit(s, PX)
    Dsp.icon.image_width = Unit(s, PX)
    Dsp.icon.image_height = Unit(s, PX)
    Dsp.content.y = Unit(content_offsets[1], PX)
    Dsp.content.height = Unit(s, PX)
    if cf_side == "left":
        Dsp.icon.x = Unit(icon_offsets[0], PX)
        Dsp.content.x = Unit(icon_offsets[0] + ss, PX)
        w = cf_width - icon_offsets[0] - ss - content_offsets[2]
        Dsp.content.width = Unit(w, PX)
    if cf_side == "right":
        Dsp.icon.x = Unit(cf_width - icon_offsets[2] - s, PX)
        Dsp.content.x = Unit(content_offsets[0], PX)
        w = cf_width - content_offsets[0] - icon_offsets[2] - ss
        Dsp.content.width = Unit(w, PX)

def setup_separator():
    if cf_sep_show:
        if cf_sep_type == "horizontal":
            Dsp.separator_h.x = Unit(icon_offsets[0], PX)
            Dsp.separator_h.y = Unit(cf_height - (cf_sep_size + 1)/2, PX)
            w = Unit(cf_width - icon_offsets[0] - icon_offsets[2], PX)
            Dsp.separator_h.width = w
            Dsp.separator_h.image_width = w
            Dsp.separator_h.visible = True
            Dsp.separator_v.visible = False
        if cf_sep_type == "vertical":
            Dsp.separator_v.x = Unit(cf_width - (cf_sep_size + 1)/2, PX)
            Dsp.separator_v.y = Unit(icon_offsets[1], PX)
            h = Unit(cf_height - icon_offsets[1] - icon_offsets[3], PX)
            Dsp.separator_v.height = h
            Dsp.separator_v.image_height = h
            Dsp.separator_h.visible = False
            Dsp.separator_v.visible = True
    else:
        Dsp.separator_h.visible = False
        Dsp.separator_v.visible = False

def setup_graph():
    Dsp.plot.bg_uri = theme("graph.png")
    Dsp.graph.size = Dsp.graph.width.as_px()
    #Dsp.graph.color = pcolor
    p1 = Unit(1, PX)
    p2 = Unit(Dsp.graph.width.as_px() - 1, PX)
    if cf_side == "right":
        Dsp.l_near.x = p2
        Dsp.l_near.anchor = "ne"
        Dsp.l_far.x = p1
        Dsp.l_far.anchor = "nw"
    if cf_side == "left":
        Dsp.l_near.x = p1
        Dsp.l_near.anchor = "nw"
        Dsp.l_far.x = p2
        Dsp.l_far.anchor = "ne"
    Dsp.l_near.color = pcolor
    Dsp.l_far.color = pcolor
    c = font_size(cf_font, Dsp.content.height.as_px()*0.25)
    Dsp.l_near.font = c
    Dsp.l_far.font = c

def setup_gauge():
    global step_width, step_count
    Dsp.theme_gauge.uri = theme("gauge.png")
    Dsp.gauge_i.uri = theme("gauge.png")
    p1 = Unit(1, PX)
    p2 = Unit(Dsp.gauge_f.width.as_px() - 1, PX)
    if cf_side == "right":
        Dsp.l_near.x = p2
        Dsp.l_near.anchor = "se"
        Dsp.l_far.x = p1
        Dsp.l_far.anchor = "sw"
    if cf_side == "left":
        Dsp.l_near.x = p1
        Dsp.l_near.anchor = "sw"
        Dsp.l_far.x = p2
        Dsp.l_far.anchor = "se"
    Dsp.l_near.color = pcolor
    Dsp.l_far.color = pcolor
    c = font_size(cf_font, Dsp.content.height.as_px()*0.25)
    Dsp.l_near.font = c
    Dsp.l_far.font = c
    Dsp.gauge_f.color = scolor
    Dsp.gauge_i.image_width = Dsp.theme_gauge.width
    step_width = Dsp.theme_gauge.width.as_px()/50
    step_count = int((Dsp.gauge_f.width.as_px() - 2)/step_width)
    Dsp.gauge_g.width = Unit(step_count*step_width, PX)

def run():
    if cf_command != "":
        runner.command = "%s &"%cf_command

def set_gauge(val):
    sn = 100.0/step_count
    Dsp.gauge.fill = int(sn*int(val/sn))+1

def font_size(font, size, mod = None):
    if mod:
        return "%s %s %d"%(font[:font.rfind(" ")], mod, int(size))
    else:
        return "%s %d"%(font[:font.rfind(" ")], int(size))

def normalize(n):
        fn = float(n)
        if fn < 1024:
                return '%iB'%fn
        if fn < 10*1024:
                return '%.2fKB'%(fn/1024)
        if fn < 100*1024:
                return '%.1fKB'%(fn/1024)
        if fn < 1024*1024:
                return '%.0fKB'%(fn/1024)
        if fn < 10*1024**2:
                return '%.2fMB'%(fn/1024**2)
        if fn < 100*1024**2:
                return '%.1fMB'%(fn/1024**2)
        if fn < 1024*1024**2:
                return '%.0fMB'%(fn/1024**2)
        if fn < 10*1024**3:
                return '%.2fGB'%(fn/1024**3)
        if fn < 100*1024**3:
                return '%.1fGB'%(fn/1024**3)
        return '%.0fGB'%(fn/1024**3)

def svg_color(s):
    return s[5:12]
