/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.27
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/***********************************************************************
 *
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 *
 ************************************************************************/

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
#  if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#    define SWIGTEMPLATEDISAMBIGUATOR template
#  else
#    define SWIGTEMPLATEDISAMBIGUATOR 
#  endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__) || defined(__ICC)
#   define SWIGUNUSED __attribute__ ((unused)) 
# else
#   define SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods for Windows DLLs */
#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   define SWIGEXPORT
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif



/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTELC__)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else


#define  SWIG_MemoryError    1
#define  SWIG_IOError        2
#define  SWIG_RuntimeError   3
#define  SWIG_IndexError     4
#define  SWIG_TypeError      5
#define  SWIG_DivisionByZero 6
#define  SWIG_OverflowError  7
#define  SWIG_SyntaxError    8
#define  SWIG_ValueError     9
#define  SWIG_SystemError   10
#define  SWIG_UnknownError  99


SWIGINTERN void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}


#include <stdexcept>


#include <iostream>
using namespace std;

#include "ogr_api.h"
#include "ogr_core.h"
#include "cpl_port.h"
#include "cpl_string.h"

typedef void OSRSpatialReferenceShadow;
typedef void OGRDriverShadow;
typedef void OGRDataSourceShadow;
typedef void OGRLayerShadow;
typedef void OGRFeatureShadow;
typedef void OGRFeatureDefnShadow;
typedef void OGRGeometryShadow;
typedef void OSRCoordinateTransformationShadow;
typedef void OGRFieldDefnShadow;


#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif

static OGRDataSourceShadow *OGRDriverShadow_CreateDataSource(OGRDriverShadow *self,char const *name,char **options=0){
    OGRDataSourceShadow *ds = (OGRDataSourceShadow*) OGR_Dr_CreateDataSource( self, name, options);
    return ds;
  }
static OGRDataSourceShadow *OGRDriverShadow_CopyDataSource(OGRDriverShadow *self,OGRDataSourceShadow *copy_ds,char const *name,char **options=0){
    OGRDataSourceShadow *ds = (OGRDataSourceShadow*) OGR_Dr_CopyDataSource(self, copy_ds, name, options);
    return ds;
  }
static OGRDataSourceShadow *OGRDriverShadow_Open(OGRDriverShadow *self,char const *name,int update=0){
    OGRDataSourceShadow* ds = (OGRDataSourceShadow*) OGR_Dr_Open(self, name, update);
    return ds;
  }
static int OGRDriverShadow_DeleteDataSource(OGRDriverShadow *self,char const *name){
    return OGR_Dr_DeleteDataSource( self, name );
  }
static bool OGRDriverShadow_TestCapability(OGRDriverShadow *self,char const *cap){
    return OGR_Dr_TestCapability(self, cap);
  }
static char const *OGRDriverShadow_GetName(OGRDriverShadow *self){
    return OGR_Dr_GetName( self );
  }
static void delete_OGRDataSourceShadow(OGRDataSourceShadow *self){
    OGRReleaseDataSource(self);
  }
static int OGRDataSourceShadow_GetRefCount(OGRDataSourceShadow *self){
    return OGR_DS_GetRefCount(self);
  }
static int OGRDataSourceShadow_GetSummaryRefCount(OGRDataSourceShadow *self){
    return OGR_DS_GetSummaryRefCount(self);
  }
static int OGRDataSourceShadow_GetLayerCount(OGRDataSourceShadow *self){
    return OGR_DS_GetLayerCount(self);
  }
static OGRDriverShadow *OGRDataSourceShadow_GetDriver(OGRDataSourceShadow *self){
    OGRDriverShadow* driver;
    OGRDataSourceShadow* ds;
    ds = (OGRDataSourceShadow*)OGROpen((const char *) OGR_DS_GetName(self),0,&driver);
    OGRReleaseDataSource(ds);
    return driver;
  }
static char const *OGRDataSourceShadow_GetName(OGRDataSourceShadow *self){
    return OGR_DS_GetName(self);
  }
static OGRErr OGRDataSourceShadow_DeleteLayer(OGRDataSourceShadow *self,int index){
    return OGR_DS_DeleteLayer(self, index);
  }

static char const *
OGRErrMessages( int rc ) {
  switch( rc ) {
  case 0:
    return "OGR Error %d: None";
  case 1:
    return "OGR Error %d: Not enough data";
  case 2:
    return "OGR Error %d: Unsupported geometry type";
  case 3:
    return "OGR Error %d: Unsupported operation";
  case 4:
    return "OGR Error %d: Corrupt data";
  case 5:
    return "OGR Error %d: General Error";
  case 6:
    return "OGR Error %d: Unsupported SRS";
  default:
    return "OGR Error %d: Unknown";
  }
}

static OGRLayerShadow *OGRDataSourceShadow_CreateLayer(OGRDataSourceShadow *self,char const *name,OSRSpatialReferenceShadow *reference=NULL,OGRwkbGeometryType geom_type=wkbUnknown,char **options=0){
    OGRLayerShadow* layer = (OGRLayerShadow*) OGR_DS_CreateLayer( self,
                                                        name,
                                                        reference,
                                                        geom_type,
                                                        options);
    return layer;
  }
static OGRLayerShadow *OGRDataSourceShadow_CopyLayer(OGRDataSourceShadow *self,OGRLayerShadow *src_layer,char const *new_name,char **options=0){
    OGRLayerShadow* layer = (OGRLayerShadow*) OGR_DS_CopyLayer( self,
                                                      src_layer,
                                                      new_name,
                                                      options);
    return layer;
  }
static OGRLayerShadow *OGRDataSourceShadow_GetLayerByIndex(OGRDataSourceShadow *self,int index=0){
    OGRLayerShadow* layer = (OGRLayerShadow*) OGR_DS_GetLayer(self, index);
    return layer;
  }
static OGRLayerShadow *OGRDataSourceShadow_GetLayerByName(OGRDataSourceShadow *self,char const *layer_name){
    OGRLayerShadow* layer = (OGRLayerShadow*) OGR_DS_GetLayerByName(self, layer_name);
    return layer;
  }
static bool OGRDataSourceShadow_TestCapability(OGRDataSourceShadow *self,char const *cap){
    return OGR_DS_TestCapability(self, cap);
  }
static OGRLayerShadow *OGRDataSourceShadow_ExecuteSQL(OGRDataSourceShadow *self,char const *statement,OGRGeometryShadow *geom=NULL,char const *dialect=""){
    OGRLayerShadow* layer = (OGRLayerShadow*) OGR_DS_ExecuteSQL((OGRDataSourceShadow*)self,
                                                      statement,
                                                      geom,
                                                      dialect);
    return layer;
  }
static void OGRDataSourceShadow_ReleaseResultSet(OGRDataSourceShadow *self,OGRLayerShadow *layer){
    OGR_DS_ReleaseResultSet(self, layer);
  }
static int OGRLayerShadow_GetRefCount(OGRLayerShadow *self){
    return OGR_L_GetRefCount(self);
  }
static void OGRLayerShadow_SetSpatialFilter(OGRLayerShadow *self,OGRGeometryShadow *filter){
    OGR_L_SetSpatialFilter (self, filter);
  }
static void OGRLayerShadow_SetSpatialFilterRect(OGRLayerShadow *self,double minx,double miny,double maxx,double maxy){
    OGR_L_SetSpatialFilterRect(self, minx, miny, maxx, maxy);                          
  }
static OGRGeometryShadow *OGRLayerShadow_GetSpatialFilter(OGRLayerShadow *self){
    return (OGRGeometryShadow *) OGR_L_GetSpatialFilter(self);
  }
static OGRErr OGRLayerShadow_SetAttributeFilter(OGRLayerShadow *self,char *filter_string){
    return OGR_L_SetAttributeFilter((OGRLayerShadow*)self, filter_string);
  }
static void OGRLayerShadow_ResetReading(OGRLayerShadow *self){
    OGR_L_ResetReading(self);
  }
static char const *OGRLayerShadow_GetName(OGRLayerShadow *self){
    return OGR_FD_GetName(OGR_L_GetLayerDefn(self));
  }
static OGRFeatureShadow *OGRLayerShadow_GetFeature(OGRLayerShadow *self,long fid){
    return (OGRFeatureShadow*) OGR_L_GetFeature(self, fid);
  }
static OGRFeatureShadow *OGRLayerShadow_GetNextFeature(OGRLayerShadow *self){
    return (OGRFeatureShadow*) OGR_L_GetNextFeature(self);
  }
static OGRErr OGRLayerShadow_SetNextByIndex(OGRLayerShadow *self,long new_index){
    return OGR_L_SetNextByIndex(self, new_index);
  }
static OGRErr OGRLayerShadow_SetFeature(OGRLayerShadow *self,OGRFeatureShadow *feature){
    return OGR_L_SetFeature(self, feature);
  }
static OGRErr OGRLayerShadow_CreateFeature(OGRLayerShadow *self,OGRFeatureShadow *feature){
    return OGR_L_CreateFeature(self, feature);
  }
static OGRErr OGRLayerShadow_DeleteFeature(OGRLayerShadow *self,long fid){
    return OGR_L_DeleteFeature(self, fid);
  }
static OGRErr OGRLayerShadow_SyncToDisk(OGRLayerShadow *self){
    return OGR_L_SyncToDisk(self);
  }
static OGRFeatureDefnShadow *OGRLayerShadow_GetLayerDefn(OGRLayerShadow *self){
    return (OGRFeatureDefnShadow*) OGR_L_GetLayerDefn(self);
  }
static int OGRLayerShadow_GetFeatureCount(OGRLayerShadow *self,int force=1){
    return OGR_L_GetFeatureCount(self, force);
  }
static OGRErr OGRLayerShadow_GetExtent(OGRLayerShadow *self,double argout[4],int force=1){
    return OGR_L_GetExtent(self, (OGREnvelope*)argout, force);
  }
static bool OGRLayerShadow_TestCapability(OGRLayerShadow *self,char const *cap){
    return OGR_L_TestCapability(self, cap);
  }
static OGRErr OGRLayerShadow_CreateField(OGRLayerShadow *self,OGRFieldDefnShadow *field_def,int approx_ok=1){
    return OGR_L_CreateField(self, field_def, approx_ok);
  }
static OGRErr OGRLayerShadow_StartTransaction(OGRLayerShadow *self){
    return OGR_L_StartTransaction(self);
  }
static OGRErr OGRLayerShadow_CommitTransaction(OGRLayerShadow *self){
    return OGR_L_CommitTransaction(self);
  }
static OGRErr OGRLayerShadow_RollbackTransaction(OGRLayerShadow *self){
    return OGR_L_RollbackTransaction(self);
  }
static OSRSpatialReferenceShadow *OGRLayerShadow_GetSpatialRef(OGRLayerShadow *self){
    return (OSRSpatialReferenceShadow*) OGR_L_GetSpatialRef(self);
  }
static GIntBig OGRLayerShadow_GetFeatureRead(OGRLayerShadow *self){
    return OGR_L_GetFeaturesRead(self);
  }
static void delete_OGRFeatureShadow(OGRFeatureShadow *self){
    OGR_F_Destroy(self);
  }
static OGRFeatureShadow *new_OGRFeatureShadow(OGRFeatureDefnShadow *feature_def=0){
    return (OGRFeatureShadow*) OGR_F_Create( feature_def );
  }
static OGRFeatureDefnShadow *OGRFeatureShadow_GetDefnRef(OGRFeatureShadow *self){
    return (OGRFeatureDefnShadow*) OGR_F_GetDefnRef(self);
  }
static OGRErr OGRFeatureShadow_SetGeometry(OGRFeatureShadow *self,OGRGeometryShadow *geom){
    return OGR_F_SetGeometry(self, geom);
  }
static OGRErr OGRFeatureShadow_SetGeometryDirectly(OGRFeatureShadow *self,OGRGeometryShadow *geom){
    return OGR_F_SetGeometryDirectly(self, geom);
  }
static OGRGeometryShadow *OGRFeatureShadow_GetGeometryRef(OGRFeatureShadow *self){
    return (OGRGeometryShadow*) OGR_F_GetGeometryRef(self);
  }
static OGRFeatureShadow *OGRFeatureShadow_Clone(OGRFeatureShadow *self){
    return (OGRFeatureShadow*) OGR_F_Clone(self);
  }
static bool OGRFeatureShadow_Equal(OGRFeatureShadow *self,OGRFeatureShadow *feature){
    return OGR_F_Equal(self, feature);
  }
static int OGRFeatureShadow_GetFieldCount(OGRFeatureShadow *self){
    return OGR_F_GetFieldCount(self);
  }
static OGRFieldDefnShadow *OGRFeatureShadow_GetFieldDefnRef__SWIG_0(OGRFeatureShadow *self,int id){
    return (OGRFieldDefnShadow *) OGR_F_GetFieldDefnRef(self, id);
  }
static OGRFieldDefnShadow *OGRFeatureShadow_GetFieldDefnRef__SWIG_1(OGRFeatureShadow *self,char const *name){
    return (OGRFieldDefnShadow *) OGR_F_GetFieldDefnRef(self, OGR_F_GetFieldIndex(self, name));
  }
static char const *OGRFeatureShadow_GetFieldAsString__SWIG_0(OGRFeatureShadow *self,int id){
    return (const char *) OGR_F_GetFieldAsString(self, id);
  }
static char const *OGRFeatureShadow_GetFieldAsString__SWIG_1(OGRFeatureShadow *self,char const *name){
    return (const char *) OGR_F_GetFieldAsString(self, OGR_F_GetFieldIndex(self, name));
  }
static int OGRFeatureShadow_GetFieldAsInteger__SWIG_0(OGRFeatureShadow *self,int id){
    return OGR_F_GetFieldAsInteger(self, id);
  }
static int OGRFeatureShadow_GetFieldAsInteger__SWIG_1(OGRFeatureShadow *self,char const *name){
    return OGR_F_GetFieldAsInteger(self, OGR_F_GetFieldIndex(self, name));
  }
static double OGRFeatureShadow_GetFieldAsDouble__SWIG_0(OGRFeatureShadow *self,int id){
    return OGR_F_GetFieldAsDouble(self, id);
  }
static double OGRFeatureShadow_GetFieldAsDouble__SWIG_1(OGRFeatureShadow *self,char const *name){
    return OGR_F_GetFieldAsDouble(self, OGR_F_GetFieldIndex(self, name));
  }
static bool OGRFeatureShadow_IsFieldSet__SWIG_0(OGRFeatureShadow *self,int id){
    return OGR_F_IsFieldSet(self, id);
  }
static bool OGRFeatureShadow_IsFieldSet__SWIG_1(OGRFeatureShadow *self,char const *name){
    return OGR_F_IsFieldSet(self, OGR_F_GetFieldIndex(self, name));
  }
static int OGRFeatureShadow_GetFieldIndex(OGRFeatureShadow *self,char const *name){
    return OGR_F_GetFieldIndex(self, name);
  }
static int OGRFeatureShadow_GetFID(OGRFeatureShadow *self){
    return OGR_F_GetFID(self);
  }
static OGRErr OGRFeatureShadow_SetFID(OGRFeatureShadow *self,int fid){
    return OGR_F_SetFID(self, fid);
  }
static void OGRFeatureShadow_DumpReadable(OGRFeatureShadow *self){
    OGR_F_DumpReadable(self, NULL);
  }
static void OGRFeatureShadow_UnsetField__SWIG_0(OGRFeatureShadow *self,int id){
    OGR_F_UnsetField(self, id);
  }
static void OGRFeatureShadow_UnsetField__SWIG_1(OGRFeatureShadow *self,char const *name){
    OGR_F_UnsetField(self, OGR_F_GetFieldIndex(self, name));
  }
static void OGRFeatureShadow_SetField__SWIG_0(OGRFeatureShadow *self,int id,char const *value){
    OGR_F_SetFieldString(self, id, value);
  }
static void OGRFeatureShadow_SetField__SWIG_1(OGRFeatureShadow *self,char const *name,char const *value){
    OGR_F_SetFieldString(self, OGR_F_GetFieldIndex(self, name), value);
  }
static OGRErr OGRFeatureShadow_SetFrom(OGRFeatureShadow *self,OGRFeatureShadow *other,int forgiving=1){
    return OGR_F_SetFrom(self, other, forgiving);
  }
static char const *OGRFeatureShadow_GetStyleString(OGRFeatureShadow *self){
    return (const char*) OGR_F_GetStyleString(self);
  }
static void OGRFeatureShadow_SetStyleString(OGRFeatureShadow *self,char const *the_string){
    OGR_F_SetStyleString(self, the_string);
  }
static OGRFieldType OGRFeatureShadow_GetFieldType__SWIG_0(OGRFeatureShadow *self,int id){
    return (OGRFieldType) OGR_Fld_GetType( OGR_F_GetFieldDefnRef( self, id));
  }
static OGRFieldType OGRFeatureShadow_GetFieldType__SWIG_1(OGRFeatureShadow *self,char const *name,char const *value){
    return (OGRFieldType) OGR_Fld_GetType( 
                            OGR_F_GetFieldDefnRef( self,  
                                                   OGR_F_GetFieldIndex(self, 
                                                                       name)
                                                  )
                                          );
    
  }
static void delete_OGRFeatureDefnShadow(OGRFeatureDefnShadow *self){
    OGR_FD_Destroy(self);
  }
static OGRFeatureDefnShadow *new_OGRFeatureDefnShadow(char const *name=NULL){
    return (OGRFeatureDefnShadow* )OGR_FD_Create(name);
  }
static char const *OGRFeatureDefnShadow_GetName(OGRFeatureDefnShadow *self){
    return OGR_FD_GetName(self);
  }
static int OGRFeatureDefnShadow_GetFieldCount(OGRFeatureDefnShadow *self){
    return OGR_FD_GetFieldCount(self);
  }
static OGRFieldDefnShadow *OGRFeatureDefnShadow_GetFieldDefn(OGRFeatureDefnShadow *self,int i){
    return (OGRFieldDefnShadow*) OGR_FD_GetFieldDefn(self, i);
  }
static int OGRFeatureDefnShadow_GetFieldIndex(OGRFeatureDefnShadow *self,char const *name){
    return OGR_FD_GetFieldIndex(self, name);
  }
static void OGRFeatureDefnShadow_AddFieldDefn(OGRFeatureDefnShadow *self,OGRFieldDefnShadow *defn){
    OGR_FD_AddFieldDefn(self, defn);
  }
static OGRwkbGeometryType OGRFeatureDefnShadow_GetGeomType(OGRFeatureDefnShadow *self){
    return (OGRwkbGeometryType) OGR_FD_GetGeomType(self);
  }
static void OGRFeatureDefnShadow_SetGeomType(OGRFeatureDefnShadow *self,OGRwkbGeometryType geom_type){
    OGR_FD_SetGeomType(self, geom_type);
  }
static int OGRFeatureDefnShadow_GetReferenceCount(OGRFeatureDefnShadow *self){
    return OGR_FD_GetReferenceCount(self);
  }
static void delete_OGRFieldDefnShadow(OGRFieldDefnShadow *self){
    OGR_Fld_Destroy(self);
  }
static OGRFieldDefnShadow *new_OGRFieldDefnShadow(char const *name="unnamed",OGRFieldType field_type=OFTString){
    return (OGRFieldDefnShadow*) OGR_Fld_Create(name, field_type);
  }
static char const *OGRFieldDefnShadow_GetName(OGRFieldDefnShadow *self){
    return (const char *) OGR_Fld_GetNameRef(self);
  }
static char const *OGRFieldDefnShadow_GetNameRef(OGRFieldDefnShadow *self){
    return (const char *) OGR_Fld_GetNameRef(self);
  }
static void OGRFieldDefnShadow_SetName(OGRFieldDefnShadow *self,char const *name){
    OGR_Fld_SetName(self, name);
  }
static OGRFieldType OGRFieldDefnShadow_GetType(OGRFieldDefnShadow *self){
    return OGR_Fld_GetType(self);
  }
static void OGRFieldDefnShadow_SetType(OGRFieldDefnShadow *self,OGRFieldType type){
    OGR_Fld_SetType(self, type);
  }
static OGRJustification OGRFieldDefnShadow_GetJustify(OGRFieldDefnShadow *self){
    return OGR_Fld_GetJustify(self);
  }
static void OGRFieldDefnShadow_SetJustify(OGRFieldDefnShadow *self,OGRJustification justify){
    OGR_Fld_SetJustify(self, justify);
  }
static int OGRFieldDefnShadow_GetWidth(OGRFieldDefnShadow *self){
    return OGR_Fld_GetWidth(self);
  }
static void OGRFieldDefnShadow_SetWidth(OGRFieldDefnShadow *self,int width){
    OGR_Fld_SetWidth(self, width);
  }
static int OGRFieldDefnShadow_GetPrecision(OGRFieldDefnShadow *self){
    return OGR_Fld_GetPrecision(self);
  }
static void OGRFieldDefnShadow_SetPrecision(OGRFieldDefnShadow *self,int precision){
    OGR_Fld_SetPrecision(self, precision);
  }
static char const *OGRFieldDefnShadow_GetFieldTypeName(OGRFieldDefnShadow *self,OGRFieldType type){
    return OGR_GetFieldTypeName(type);
  }

  OGRGeometryShadow* CreateGeometryFromWkb( int len, char *bin_string, 
                                            OSRSpatialReferenceShadow *reference=NULL ) {
    void *geom;
    OGRErr err = OGR_G_CreateFromWkb( (unsigned char *) bin_string,
                                      reference,
                                      &geom,
                                      len );
    if (err != 0 )
       return NULL;
    return (OGRGeometryShadow*) geom;
  }
 


  OGRGeometryShadow* CreateGeometryFromWkt( char **val, 
                                      OSRSpatialReferenceShadow *reference=NULL ) {
    void *geom;
    OGRErr err = OGR_G_CreateFromWkt(val,
                                      reference,
                                      &geom);
    if (err != 0 )
       return NULL;
    return (OGRGeometryShadow*) geom;
  }
 


  OGRGeometryShadow *CreateGeometryFromGML( const char * input_string ) {
    OGRGeometryShadow* geom = (OGRGeometryShadow*)OGR_G_CreateFromGML(input_string);
    return geom;
  }
 

static void delete_OGRGeometryShadow(OGRGeometryShadow *self){
    OGR_G_DestroyGeometry( self );
  }
static OGRGeometryShadow *new_OGRGeometryShadow(OGRwkbGeometryType type=wkbUnknown,char *wkt=0,int wkb=0,char *wkb_buf=0,char *gml=0){
    if (type != wkbUnknown ) {
      return (OGRGeometryShadow*) OGR_G_CreateGeometry( type );
    }
    else if ( wkt != 0 ) {
      return CreateGeometryFromWkt( &wkt );
    }
    else if ( wkb != 0 ) {
      return CreateGeometryFromWkb( wkb, wkb_buf );
    }
    else if ( gml != 0 ) {
      return CreateGeometryFromGML( gml );
    }
    // throw?
    else return 0;
  }
static OGRErr OGRGeometryShadow_ExportToWkt(OGRGeometryShadow *self,char **argout){
    return OGR_G_ExportToWkt(self, argout);
  }
static OGRErr OGRGeometryShadow_ExportToWkb(OGRGeometryShadow *self,int *nLen,char **pBuf,OGRwkbByteOrder byte_order=wkbXDR){
    *nLen = OGR_G_WkbSize( self );
    *pBuf = (char *) malloc( *nLen * sizeof(unsigned char) );
    return OGR_G_ExportToWkb(self, byte_order, (unsigned char*) *pBuf );
  }
static char const *OGRGeometryShadow_ExportToGML(OGRGeometryShadow *self){
    return (const char *) OGR_G_ExportToGML(self);
  }
static void OGRGeometryShadow_AddPoint(OGRGeometryShadow *self,double x,double y,double z=0){
    OGR_G_AddPoint( self, x, y, z );
  }
static OGRErr OGRGeometryShadow_AddGeometryDirectly(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_AddGeometryDirectly( self, other );
  }
static OGRErr OGRGeometryShadow_AddGeometry(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_AddGeometry( self, other );
  }
static OGRGeometryShadow *OGRGeometryShadow_Clone(OGRGeometryShadow *self){
    return (OGRGeometryShadow*) OGR_G_Clone(self);
  }
static OGRwkbGeometryType OGRGeometryShadow_GetGeometryType(OGRGeometryShadow *self){
    return (OGRwkbGeometryType) OGR_G_GetGeometryType(self);
  }
static char const *OGRGeometryShadow_GetGeometryName(OGRGeometryShadow *self){
    return (const char *) OGR_G_GetGeometryName(self);
  }
static double OGRGeometryShadow_GetArea(OGRGeometryShadow *self){
    return OGR_G_GetArea(self);
  }
static int OGRGeometryShadow_GetPointCount(OGRGeometryShadow *self){
    return OGR_G_GetPointCount(self);
  }
static double OGRGeometryShadow_GetX(OGRGeometryShadow *self,int point=0){
    return OGR_G_GetX(self, point);
  }
static double OGRGeometryShadow_GetY(OGRGeometryShadow *self,int point=0){
    return OGR_G_GetY(self, point);
  }
static double OGRGeometryShadow_GetZ(OGRGeometryShadow *self,int point=0){
    return OGR_G_GetZ(self, point);
  }
static int OGRGeometryShadow_GetGeometryCount(OGRGeometryShadow *self){
    return OGR_G_GetGeometryCount(self);
  }
static void OGRGeometryShadow_SetPoint(OGRGeometryShadow *self,int point,double x,double y,double z=0){
    OGR_G_SetPoint(self, point, x, y, z);
  }
static OGRGeometryShadow *OGRGeometryShadow_GetGeometryRef(OGRGeometryShadow *self,int geom){
    return (OGRGeometryShadow*) OGR_G_GetGeometryRef(self, geom);
  }
static OGRGeometryShadow *OGRGeometryShadow_GetBoundary(OGRGeometryShadow *self){
    return (OGRGeometryShadow*) OGR_G_GetBoundary(self);
  }
static OGRGeometryShadow *OGRGeometryShadow_ConvexHull(OGRGeometryShadow *self){
    return (OGRGeometryShadow*) OGR_G_ConvexHull(self);
  }
static OGRGeometryShadow *OGRGeometryShadow_Buffer(OGRGeometryShadow *self,double distance,int quadsecs=30){
    return (OGRGeometryShadow*) OGR_G_Buffer( self, distance, quadsecs );
  }
static OGRGeometryShadow *OGRGeometryShadow_Intersection(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return (OGRGeometryShadow*) OGR_G_Intersection( self, other );
  }
static OGRGeometryShadow *OGRGeometryShadow_Union(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return (OGRGeometryShadow*) OGR_G_Union( self, other );
  }
static OGRGeometryShadow *OGRGeometryShadow_Difference(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return (OGRGeometryShadow*) OGR_G_Difference( self, other );
  }
static OGRGeometryShadow *OGRGeometryShadow_SymmetricDifference(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return (OGRGeometryShadow*) OGR_G_SymmetricDifference( self, other );
  }
static double OGRGeometryShadow_Distance(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_Distance(self, other);
  }
static void OGRGeometryShadow_Empty(OGRGeometryShadow *self){
    OGR_G_Empty(self);
  }
static bool OGRGeometryShadow_Intersect(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_Intersect(self, other);
  }
static bool OGRGeometryShadow_Equal(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_Equal(self, other);
  }
static bool OGRGeometryShadow_Disjoint(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_Disjoint(self, other);
  }
static bool OGRGeometryShadow_Touches(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_Touches(self, other);
  }
static bool OGRGeometryShadow_Crosses(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_Crosses(self, other);
  }
static bool OGRGeometryShadow_Within(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_Within(self, other);
  }
static bool OGRGeometryShadow_Contains(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_Contains(self, other);
  }
static bool OGRGeometryShadow_Overlaps(OGRGeometryShadow *self,OGRGeometryShadow *other){
    return OGR_G_Overlaps(self, other);
  }
static OGRErr OGRGeometryShadow_TransformTo(OGRGeometryShadow *self,OSRSpatialReferenceShadow *reference){
    return OGR_G_TransformTo(self, reference);
  }
static OGRErr OGRGeometryShadow_Transform(OGRGeometryShadow *self,OSRCoordinateTransformationShadow *trans){
    return OGR_G_Transform(self, trans);
  }
static OSRSpatialReferenceShadow *OGRGeometryShadow_GetSpatialReference(OGRGeometryShadow *self){
    return (OSRSpatialReferenceShadow*)OGR_G_GetSpatialReference(self);
  }
static void OGRGeometryShadow_AssignSpatialReference(OGRGeometryShadow *self,OSRSpatialReferenceShadow *reference){
    OGR_G_AssignSpatialReference(self, reference);
  }
static void OGRGeometryShadow_CloseRings(OGRGeometryShadow *self){
    OGR_G_CloseRings(self);
  }
static void OGRGeometryShadow_FlattenTo2D(OGRGeometryShadow *self){
    OGR_G_FlattenTo2D(self);
  }
static void OGRGeometryShadow_GetEnvelope(OGRGeometryShadow *self,double argout[4]){
    OGR_G_GetEnvelope(self, (OGREnvelope*)argout);
  }
static OGRGeometryShadow *OGRGeometryShadow_Centroid(OGRGeometryShadow *self){
    OGRGeometryShadow *pt = new_OGRGeometryShadow( wkbPoint );
    OGRErr rcode = OGR_G_Centroid( self, pt );
    return pt;
  }
static int OGRGeometryShadow_WkbSize(OGRGeometryShadow *self){
    return OGR_G_WkbSize(self);
  }
static int OGRGeometryShadow_GetCoordinateDimension(OGRGeometryShadow *self){
    return OGR_G_GetCoordinateDimension(self);
  }
static int OGRGeometryShadow_GetDimension(OGRGeometryShadow *self){
    return OGR_G_GetDimension(self);
  }

char const *OGRDriverShadow_get_name( OGRDriverShadow *h ) {
  return OGR_Dr_GetName( h );
}

char const *OGRDataSourceShadow_get_name( OGRDataSourceShadow *h ) {
  return OGR_DS_GetName( h );
}

char const *OGRDriverShadow_name_get( OGRDriverShadow *h ) {
  return OGR_Dr_GetName( h );
}

char const *OGRDataSourceShadow_name_get( OGRDataSourceShadow *h ) {
  return OGR_DS_GetName( h );
}


  OGRDataSourceShadow* GetOpenDS(int ds_number) {
    OGRDataSourceShadow* layer = (OGRDataSourceShadow*) OGRGetOpenDS(ds_number);
    return layer;
  }


  OGRDataSourceShadow* Open( const char *filename, int update =0 ) {
    OGRDataSourceShadow* ds = (OGRDataSourceShadow*)OGROpen(filename,update,NULL);
    return ds;
  }


  OGRDataSourceShadow* OpenShared( const char *filename, int update =0 ) {
    OGRDataSourceShadow* ds = (OGRDataSourceShadow*)OGROpenShared(filename,update,NULL);
    return ds;
  }


OGRDriverShadow* GetDriverByName( char const *name ) {
  return (OGRDriverShadow*) OGRGetDriverByName( name );
}

OGRDriverShadow* GetDriver(int driver_number) {
  return (OGRDriverShadow*) OGRGetDriver(driver_number);
}


#ifdef __cplusplus
extern "C" {
#endif

JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_wkb25Bit_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) wkb25DBit;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_wkbUnknown_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_wkbPoint_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_wkbLineString_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_wkbPolygon_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_wkbMultiPoint_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_wkbMultiLineString_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_wkbMultiPolygon_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 6;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_wkbGeometryCollection_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 7;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_wkbNone_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 100;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_wkbLinearRing_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 101;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_wkbPoint25D_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) wkbPoint+wkb25DBit;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_wkbLineString25D_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) wkbLineString+wkb25DBit;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_wkbPolygon25D_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) wkbPolygon+wkb25DBit;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_wkbMultiPoint25D_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) wkbMultiPoint+wkb25DBit;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_wkbMultiLineString25D_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) wkbMultiLineString+wkb25DBit;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_wkbMultiPolygon25D_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) wkbMultiPolygon+wkb25DBit;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_wkbGeometryCollection25D_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) wkbGeometryCollection+wkb25DBit;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_OFTInteger_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_OFTIntegerList_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_OFTReal_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_OFTRealList_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 3;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_OFTString_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 4;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_OFTStringList_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 5;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_OFTWideString_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 6;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_OFTWideStringList_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 7;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_OFTBinary_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 8;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_OFTDate_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 8;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_OJUndefined_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_OJLeft_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_OJRight_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 2;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_wkbXDR_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 0;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_wkbNDR_1get(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int) 1;
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_OLCRandomRead_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "RandomRead";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_OLCSequentialWrite_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "SequentialWrite";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_OLCRandomWrite_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "RandomWrite";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_OLCFastSpatialFilter_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "FastSpatialFilter";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_OLCFastFeatureCount_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "FastFeatureCount";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_OLCFastGetExtent_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "FastGetExtent";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_OLCCreateField_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "CreateField";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_OLCTransactions_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "Transactions";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_OLCDeleteFeature_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "DeleteFeature";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_OLCFastSetNextByIndex_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "FastSetNextByIndex";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_ODsCCreateLayer_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "CreateLayer";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_ODsCDeleteLayer_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "DeleteLayer";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_ODrCCreateDataSource_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "CreateDataSource";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_ODrCDeleteDataSource_1get(JNIEnv *jenv, jclass jcls) {
    jstring jresult = 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    result = (char *) "DeleteDataSource";
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_Driver_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    OGRDriverShadow *arg1 = (OGRDriverShadow *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDriverShadow **)(void *)&jarg1; 
    result = (char *)OGRDriverShadow_name_get(arg1);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Driver_1CreateDataSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jobject jarg3) {
    jlong jresult = 0 ;
    OGRDriverShadow *arg1 = (OGRDriverShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char **arg3 = (char **) 0 ;
    OGRDataSourceShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDriverShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        /* %typemap(in) char **options */
        arg3 = NULL;
        if(jarg3 != 0) {
            const jclass vector = jenv->FindClass("java/util/Vector");
            const jclass enumeration = jenv->FindClass("java/util/Enumeration");
            const jmethodID elements = jenv->GetMethodID(vector, "elements",
            "()Ljava/util/Enumeration;");
            const jmethodID hasMoreElements = jenv->GetMethodID(enumeration, 
            "hasMoreElements", "()Z");
            const jmethodID getNextElement = jenv->GetMethodID(enumeration,
            "nextElement", "()Ljava/lang/Object;");
            if(vector == NULL || enumeration == NULL || elements == NULL ||
            hasMoreElements == NULL || getNextElement == NULL) {
                fprintf(stderr, "Could not load (options **) jni types.\n");
                return 0;
            }
            for (jobject keys = jenv->CallObjectMethod(jarg3, elements);
            jenv->CallBooleanMethod(keys, hasMoreElements) == JNI_TRUE;) {
                jstring value = (jstring)jenv->CallObjectMethod(keys, getNextElement);
                const char *valptr = jenv->GetStringUTFChars(value, 0);
                arg3 = CSLAddString(arg3,  valptr);
                jenv->ReleaseStringUTFChars(value, valptr);
            }
        }
    }
    result = (OGRDataSourceShadow *)OGRDriverShadow_CreateDataSource(arg1,(char const *)arg2,arg3);
    
    *(OGRDataSourceShadow **)(void *)&jresult = result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        /* %typemap(freearg) char **options */
        CSLDestroy( arg3 );
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Driver_1CopyDataSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jobject jarg4) {
    jlong jresult = 0 ;
    OGRDriverShadow *arg1 = (OGRDriverShadow *) 0 ;
    OGRDataSourceShadow *arg2 = (OGRDataSourceShadow *) 0 ;
    char *arg3 = (char *) 0 ;
    char **arg4 = (char **) 0 ;
    OGRDataSourceShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDriverShadow **)(void *)&jarg1; 
    arg2 = *(OGRDataSourceShadow **)(void *)&jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    {
        /* %typemap(in) char **options */
        arg4 = NULL;
        if(jarg4 != 0) {
            const jclass vector = jenv->FindClass("java/util/Vector");
            const jclass enumeration = jenv->FindClass("java/util/Enumeration");
            const jmethodID elements = jenv->GetMethodID(vector, "elements",
            "()Ljava/util/Enumeration;");
            const jmethodID hasMoreElements = jenv->GetMethodID(enumeration, 
            "hasMoreElements", "()Z");
            const jmethodID getNextElement = jenv->GetMethodID(enumeration,
            "nextElement", "()Ljava/lang/Object;");
            if(vector == NULL || enumeration == NULL || elements == NULL ||
            hasMoreElements == NULL || getNextElement == NULL) {
                fprintf(stderr, "Could not load (options **) jni types.\n");
                return 0;
            }
            for (jobject keys = jenv->CallObjectMethod(jarg4, elements);
            jenv->CallBooleanMethod(keys, hasMoreElements) == JNI_TRUE;) {
                jstring value = (jstring)jenv->CallObjectMethod(keys, getNextElement);
                const char *valptr = jenv->GetStringUTFChars(value, 0);
                arg4 = CSLAddString(arg4,  valptr);
                jenv->ReleaseStringUTFChars(value, valptr);
            }
        }
    }
    result = (OGRDataSourceShadow *)OGRDriverShadow_CopyDataSource(arg1,arg2,(char const *)arg3,arg4);
    
    *(OGRDataSourceShadow **)(void *)&jresult = result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    {
        /* %typemap(freearg) char **options */
        CSLDestroy( arg4 );
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Driver_1Open(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jint jarg3) {
    jlong jresult = 0 ;
    OGRDriverShadow *arg1 = (OGRDriverShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    int arg3 = (int) 0 ;
    OGRDataSourceShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDriverShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = (int)jarg3; 
    result = (OGRDataSourceShadow *)OGRDriverShadow_Open(arg1,(char const *)arg2,arg3);
    
    *(OGRDataSourceShadow **)(void *)&jresult = result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Driver_1DeleteDataSource(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    OGRDriverShadow *arg1 = (OGRDriverShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDriverShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (int)OGRDriverShadow_DeleteDataSource(arg1,(char const *)arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_gdal_ogr_ogrJNI_Driver_1TestCapability(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jboolean jresult = 0 ;
    OGRDriverShadow *arg1 = (OGRDriverShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDriverShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (bool)OGRDriverShadow_TestCapability(arg1,(char const *)arg2);
    
    jresult = (jboolean)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_Driver_1GetName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    OGRDriverShadow *arg1 = (OGRDriverShadow *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDriverShadow **)(void *)&jarg1; 
    result = (char *)OGRDriverShadow_GetName(arg1);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_DataSource_1name_1get(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDataSourceShadow **)(void *)&jarg1; 
    result = (char *)OGRDataSourceShadow_name_get(arg1);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_delete_1DataSource(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDataSourceShadow **)(void *)&jarg1; 
    delete_OGRDataSourceShadow(arg1);
    
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_DataSource_1GetRefCount(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDataSourceShadow **)(void *)&jarg1; 
    result = (int)OGRDataSourceShadow_GetRefCount(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_DataSource_1GetSummaryRefCount(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDataSourceShadow **)(void *)&jarg1; 
    result = (int)OGRDataSourceShadow_GetSummaryRefCount(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_DataSource_1GetLayerCount(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDataSourceShadow **)(void *)&jarg1; 
    result = (int)OGRDataSourceShadow_GetLayerCount(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_DataSource_1GetDriver(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    OGRDriverShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDataSourceShadow **)(void *)&jarg1; 
    result = (OGRDriverShadow *)OGRDataSourceShadow_GetDriver(arg1);
    
    *(OGRDriverShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_DataSource_1GetName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDataSourceShadow **)(void *)&jarg1; 
    result = (char *)OGRDataSourceShadow_GetName(arg1);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_DataSource_1DeleteLayer(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    int arg2 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDataSourceShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (OGRErr)OGRDataSourceShadow_DeleteLayer(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_DataSource_1CreateLayer(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jint jarg4, jobject jarg5) {
    jlong jresult = 0 ;
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    OSRSpatialReferenceShadow *arg3 = (OSRSpatialReferenceShadow *) NULL ;
    OGRwkbGeometryType arg4 = (OGRwkbGeometryType) wkbUnknown ;
    char **arg5 = (char **) 0 ;
    OGRLayerShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDataSourceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = *(OSRSpatialReferenceShadow **)(void *)&jarg3; 
    arg4 = (OGRwkbGeometryType)jarg4; 
    {
        /* %typemap(in) char **options */
        arg5 = NULL;
        if(jarg5 != 0) {
            const jclass vector = jenv->FindClass("java/util/Vector");
            const jclass enumeration = jenv->FindClass("java/util/Enumeration");
            const jmethodID elements = jenv->GetMethodID(vector, "elements",
            "()Ljava/util/Enumeration;");
            const jmethodID hasMoreElements = jenv->GetMethodID(enumeration, 
            "hasMoreElements", "()Z");
            const jmethodID getNextElement = jenv->GetMethodID(enumeration,
            "nextElement", "()Ljava/lang/Object;");
            if(vector == NULL || enumeration == NULL || elements == NULL ||
            hasMoreElements == NULL || getNextElement == NULL) {
                fprintf(stderr, "Could not load (options **) jni types.\n");
                return 0;
            }
            for (jobject keys = jenv->CallObjectMethod(jarg5, elements);
            jenv->CallBooleanMethod(keys, hasMoreElements) == JNI_TRUE;) {
                jstring value = (jstring)jenv->CallObjectMethod(keys, getNextElement);
                const char *valptr = jenv->GetStringUTFChars(value, 0);
                arg5 = CSLAddString(arg5,  valptr);
                jenv->ReleaseStringUTFChars(value, valptr);
            }
        }
    }
    result = (OGRLayerShadow *)OGRDataSourceShadow_CreateLayer(arg1,(char const *)arg2,arg3,arg4,arg5);
    
    *(OGRLayerShadow **)(void *)&jresult = result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        /* %typemap(freearg) char **options */
        CSLDestroy( arg5 );
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_DataSource_1CopyLayer(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jstring jarg3, jobject jarg4) {
    jlong jresult = 0 ;
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    OGRLayerShadow *arg2 = (OGRLayerShadow *) 0 ;
    char *arg3 = (char *) 0 ;
    char **arg4 = (char **) 0 ;
    OGRLayerShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDataSourceShadow **)(void *)&jarg1; 
    arg2 = *(OGRLayerShadow **)(void *)&jarg2; 
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    {
        /* %typemap(in) char **options */
        arg4 = NULL;
        if(jarg4 != 0) {
            const jclass vector = jenv->FindClass("java/util/Vector");
            const jclass enumeration = jenv->FindClass("java/util/Enumeration");
            const jmethodID elements = jenv->GetMethodID(vector, "elements",
            "()Ljava/util/Enumeration;");
            const jmethodID hasMoreElements = jenv->GetMethodID(enumeration, 
            "hasMoreElements", "()Z");
            const jmethodID getNextElement = jenv->GetMethodID(enumeration,
            "nextElement", "()Ljava/lang/Object;");
            if(vector == NULL || enumeration == NULL || elements == NULL ||
            hasMoreElements == NULL || getNextElement == NULL) {
                fprintf(stderr, "Could not load (options **) jni types.\n");
                return 0;
            }
            for (jobject keys = jenv->CallObjectMethod(jarg4, elements);
            jenv->CallBooleanMethod(keys, hasMoreElements) == JNI_TRUE;) {
                jstring value = (jstring)jenv->CallObjectMethod(keys, getNextElement);
                const char *valptr = jenv->GetStringUTFChars(value, 0);
                arg4 = CSLAddString(arg4,  valptr);
                jenv->ReleaseStringUTFChars(value, valptr);
            }
        }
    }
    result = (OGRLayerShadow *)OGRDataSourceShadow_CopyLayer(arg1,arg2,(char const *)arg3,arg4);
    
    *(OGRLayerShadow **)(void *)&jresult = result; 
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    {
        /* %typemap(freearg) char **options */
        CSLDestroy( arg4 );
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_DataSource_1GetLayerByIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    int arg2 = (int) 0 ;
    OGRLayerShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDataSourceShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (OGRLayerShadow *)OGRDataSourceShadow_GetLayerByIndex(arg1,arg2);
    
    *(OGRLayerShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_DataSource_1GetLayerByName(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    OGRLayerShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDataSourceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (OGRLayerShadow *)OGRDataSourceShadow_GetLayerByName(arg1,(char const *)arg2);
    
    *(OGRLayerShadow **)(void *)&jresult = result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_gdal_ogr_ogrJNI_DataSource_1TestCapability(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jboolean jresult = 0 ;
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDataSourceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (bool)OGRDataSourceShadow_TestCapability(arg1,(char const *)arg2);
    
    jresult = (jboolean)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_DataSource_1ExecuteSQL(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jlong jarg3, jstring jarg4) {
    jlong jresult = 0 ;
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    OGRGeometryShadow *arg3 = (OGRGeometryShadow *) NULL ;
    char *arg4 = (char *) "" ;
    OGRLayerShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDataSourceShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = *(OGRGeometryShadow **)(void *)&jarg3; 
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
            if (!arg4) return 0;
        }
    }
    result = (OGRLayerShadow *)OGRDataSourceShadow_ExecuteSQL(arg1,(char const *)arg2,arg3,(char const *)arg4);
    
    *(OGRLayerShadow **)(void *)&jresult = result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        if (arg4) jenv->ReleaseStringUTFChars(jarg4, arg4); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_DataSource_1ReleaseResultSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    OGRDataSourceShadow *arg1 = (OGRDataSourceShadow *) 0 ;
    OGRLayerShadow *arg2 = (OGRLayerShadow *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRDataSourceShadow **)(void *)&jarg1; 
    arg2 = *(OGRLayerShadow **)(void *)&jarg2; 
    OGRDataSourceShadow_ReleaseResultSet(arg1,arg2);
    
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1GetRefCount(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    result = (int)OGRLayerShadow_GetRefCount(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1SetSpatialFilter(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    arg2 = *(OGRGeometryShadow **)(void *)&jarg2; 
    OGRLayerShadow_SetSpatialFilter(arg1,arg2);
    
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1SetSpatialFilterRect(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    arg3 = (double)jarg3; 
    arg4 = (double)jarg4; 
    arg5 = (double)jarg5; 
    OGRLayerShadow_SetSpatialFilterRect(arg1,arg2,arg3,arg4,arg5);
    
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1GetSpatialFilter(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRGeometryShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    result = (OGRGeometryShadow *)OGRLayerShadow_GetSpatialFilter(arg1);
    
    *(OGRGeometryShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1SetAttributeFilter(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (OGRErr)OGRLayerShadow_SetAttributeFilter(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1ResetReading(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    OGRLayerShadow_ResetReading(arg1);
    
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1GetName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    result = (char *)OGRLayerShadow_GetName(arg1);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1GetFeature(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    long arg2 ;
    OGRFeatureShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    arg2 = (long)jarg2; 
    result = (OGRFeatureShadow *)OGRLayerShadow_GetFeature(arg1,arg2);
    
    *(OGRFeatureShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1GetNextFeature(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRFeatureShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    result = (OGRFeatureShadow *)OGRLayerShadow_GetNextFeature(arg1);
    
    *(OGRFeatureShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1SetNextByIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    long arg2 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    arg2 = (long)jarg2; 
    result = (OGRErr)OGRLayerShadow_SetNextByIndex(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1SetFeature(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRFeatureShadow *arg2 = (OGRFeatureShadow *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    arg2 = *(OGRFeatureShadow **)(void *)&jarg2; 
    result = (OGRErr)OGRLayerShadow_SetFeature(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1CreateFeature(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRFeatureShadow *arg2 = (OGRFeatureShadow *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    arg2 = *(OGRFeatureShadow **)(void *)&jarg2; 
    result = (OGRErr)OGRLayerShadow_CreateFeature(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1DeleteFeature(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    long arg2 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    arg2 = (long)jarg2; 
    result = (OGRErr)OGRLayerShadow_DeleteFeature(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1SyncToDisk(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    result = (OGRErr)OGRLayerShadow_SyncToDisk(arg1);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1GetLayerDefn(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRFeatureDefnShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    result = (OGRFeatureDefnShadow *)OGRLayerShadow_GetLayerDefn(arg1);
    
    *(OGRFeatureDefnShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1GetFeatureCount(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    int arg2 = (int) 1 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (int)OGRLayerShadow_GetFeatureCount(arg1,arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1GetExtent(JNIEnv *jenv, jclass jcls, jlong jarg1, jdoubleArray jarg2, jint jarg3) {
    jint jresult = 0 ;
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    double *arg2 ;
    int arg3 = (int) 1 ;
    OGRErr result;
    jdouble *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return 0;
    }
    if (!SWIG_JavaArrayInDouble(jenv, &jarr2, &arg2, jarg2)) return 0; 
    arg3 = (int)jarg3; 
    result = (OGRErr)OGRLayerShadow_GetExtent(arg1,arg2,arg3);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    SWIG_JavaArrayArgoutDouble(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1TestCapability(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jboolean jresult = 0 ;
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (bool)OGRLayerShadow_TestCapability(arg1,(char const *)arg2);
    
    jresult = (jboolean)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1CreateField(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
    jint jresult = 0 ;
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRFieldDefnShadow *arg2 = (OGRFieldDefnShadow *) 0 ;
    int arg3 = (int) 1 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    arg2 = *(OGRFieldDefnShadow **)(void *)&jarg2; 
    arg3 = (int)jarg3; 
    result = (OGRErr)OGRLayerShadow_CreateField(arg1,arg2,arg3);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1StartTransaction(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    result = (OGRErr)OGRLayerShadow_StartTransaction(arg1);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1CommitTransaction(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    result = (OGRErr)OGRLayerShadow_CommitTransaction(arg1);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1RollbackTransaction(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    result = (OGRErr)OGRLayerShadow_RollbackTransaction(arg1);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1GetSpatialRef(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    OSRSpatialReferenceShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    result = (OSRSpatialReferenceShadow *)OGRLayerShadow_GetSpatialRef(arg1);
    
    *(OSRSpatialReferenceShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Layer_1GetFeatureRead(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    OGRLayerShadow *arg1 = (OGRLayerShadow *) 0 ;
    GIntBig result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRLayerShadow **)(void *)&jarg1; 
    result = OGRLayerShadow_GetFeatureRead(arg1);
    
    *(GIntBig **)(void *)&jresult = new GIntBig((GIntBig &)result); 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_delete_1Feature(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    delete_OGRFeatureShadow(arg1);
    
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_new_1Feature(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    OGRFeatureDefnShadow *arg1 = (OGRFeatureDefnShadow *) 0 ;
    OGRFeatureShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureDefnShadow **)(void *)&jarg1; 
    result = (OGRFeatureShadow *)new_OGRFeatureShadow(arg1);
    
    *(OGRFeatureShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1GetDefnRef(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    OGRFeatureDefnShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    result = (OGRFeatureDefnShadow *)OGRFeatureShadow_GetDefnRef(arg1);
    
    *(OGRFeatureDefnShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1SetGeometry(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    arg2 = *(OGRGeometryShadow **)(void *)&jarg2; 
    result = (OGRErr)OGRFeatureShadow_SetGeometry(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1SetGeometryDirectly(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    arg2 = *(OGRGeometryShadow **)(void *)&jarg2; 
    result = (OGRErr)OGRFeatureShadow_SetGeometryDirectly(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1GetGeometryRef(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    OGRGeometryShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    result = (OGRGeometryShadow *)OGRFeatureShadow_GetGeometryRef(arg1);
    
    *(OGRGeometryShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1Clone(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    OGRFeatureShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    result = (OGRFeatureShadow *)OGRFeatureShadow_Clone(arg1);
    
    *(OGRFeatureShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1Equal(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    OGRFeatureShadow *arg2 = (OGRFeatureShadow *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    arg2 = *(OGRFeatureShadow **)(void *)&jarg2; 
    result = (bool)OGRFeatureShadow_Equal(arg1,arg2);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1GetFieldCount(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    result = (int)OGRFeatureShadow_GetFieldCount(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1GetFieldDefnRef_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int arg2 ;
    OGRFieldDefnShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (OGRFieldDefnShadow *)OGRFeatureShadow_GetFieldDefnRef__SWIG_0(arg1,arg2);
    
    *(OGRFieldDefnShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1GetFieldDefnRef_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    OGRFieldDefnShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (OGRFieldDefnShadow *)OGRFeatureShadow_GetFieldDefnRef__SWIG_1(arg1,(char const *)arg2);
    
    *(OGRFieldDefnShadow **)(void *)&jresult = result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1GetFieldAsString_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jstring jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int arg2 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (char *)OGRFeatureShadow_GetFieldAsString__SWIG_0(arg1,arg2);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1GetFieldAsString_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jstring jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (char *)OGRFeatureShadow_GetFieldAsString__SWIG_1(arg1,(char const *)arg2);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1GetFieldAsInteger_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int arg2 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (int)OGRFeatureShadow_GetFieldAsInteger__SWIG_0(arg1,arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1GetFieldAsInteger_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (int)OGRFeatureShadow_GetFieldAsInteger__SWIG_1(arg1,(char const *)arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1GetFieldAsDouble_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jdouble jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int arg2 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (double)OGRFeatureShadow_GetFieldAsDouble__SWIG_0(arg1,arg2);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1GetFieldAsDouble_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jdouble jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (double)OGRFeatureShadow_GetFieldAsDouble__SWIG_1(arg1,(char const *)arg2);
    
    jresult = (jdouble)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1IsFieldSet_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jboolean jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int arg2 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (bool)OGRFeatureShadow_IsFieldSet__SWIG_0(arg1,arg2);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1IsFieldSet_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jboolean jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (bool)OGRFeatureShadow_IsFieldSet__SWIG_1(arg1,(char const *)arg2);
    
    jresult = (jboolean)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1GetFieldIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (int)OGRFeatureShadow_GetFieldIndex(arg1,(char const *)arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1GetFID(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    result = (int)OGRFeatureShadow_GetFID(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1SetFID(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int arg2 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (OGRErr)OGRFeatureShadow_SetFID(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1DumpReadable(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    OGRFeatureShadow_DumpReadable(arg1);
    
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1UnsetField_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    OGRFeatureShadow_UnsetField__SWIG_0(arg1,arg2);
    
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1UnsetField_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    OGRFeatureShadow_UnsetField__SWIG_1(arg1,(char const *)arg2);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1SetField_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jstring jarg3) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int arg2 ;
    char *arg3 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    {
        /* %typemap(in) (tostring argin) */
        arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    }
    OGRFeatureShadow_SetField__SWIG_0(arg1,arg2,(char const *)arg3);
    
    {
        /* %typemap(in) (tostring argin) */
        jenv->ReleaseStringUTFChars(jarg3, (char*)arg3);
    }
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1SetField_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    {
        /* %typemap(in) (tostring argin) */
        arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
    }
    OGRFeatureShadow_SetField__SWIG_1(arg1,(char const *)arg2,(char const *)arg3);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        /* %typemap(in) (tostring argin) */
        jenv->ReleaseStringUTFChars(jarg3, (char*)arg3);
    }
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1SetFrom(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
    jint jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    OGRFeatureShadow *arg2 = (OGRFeatureShadow *) 0 ;
    int arg3 = (int) 1 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    arg2 = *(OGRFeatureShadow **)(void *)&jarg2; 
    arg3 = (int)jarg3; 
    result = (OGRErr)OGRFeatureShadow_SetFrom(arg1,arg2,arg3);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1GetStyleString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    result = (char *)OGRFeatureShadow_GetStyleString(arg1);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1SetStyleString(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    OGRFeatureShadow_SetStyleString(arg1,(char const *)arg2);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1GetFieldType_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jint jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    int arg2 ;
    OGRFieldType result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (OGRFieldType)OGRFeatureShadow_GetFieldType__SWIG_0(arg1,arg2);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Feature_1GetFieldType_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2, jstring jarg3) {
    jint jresult = 0 ;
    OGRFeatureShadow *arg1 = (OGRFeatureShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    char *arg3 = (char *) 0 ;
    OGRFieldType result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        arg3 = 0;
        if (jarg3) {
            arg3 = (char *)jenv->GetStringUTFChars(jarg3, 0);
            if (!arg3) return 0;
        }
    }
    result = (OGRFieldType)OGRFeatureShadow_GetFieldType__SWIG_1(arg1,(char const *)arg2,(char const *)arg3);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        if (arg3) jenv->ReleaseStringUTFChars(jarg3, arg3); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_delete_1FeatureDefn(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    OGRFeatureDefnShadow *arg1 = (OGRFeatureDefnShadow *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureDefnShadow **)(void *)&jarg1; 
    delete_OGRFeatureDefnShadow(arg1);
    
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_new_1FeatureDefn(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    char *arg1 = (char *) NULL ;
    OGRFeatureDefnShadow *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (OGRFeatureDefnShadow *)new_OGRFeatureDefnShadow((char const *)arg1);
    
    *(OGRFeatureDefnShadow **)(void *)&jresult = result; 
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_FeatureDefn_1GetName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    OGRFeatureDefnShadow *arg1 = (OGRFeatureDefnShadow *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureDefnShadow **)(void *)&jarg1; 
    result = (char *)OGRFeatureDefnShadow_GetName(arg1);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_FeatureDefn_1GetFieldCount(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRFeatureDefnShadow *arg1 = (OGRFeatureDefnShadow *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureDefnShadow **)(void *)&jarg1; 
    result = (int)OGRFeatureDefnShadow_GetFieldCount(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_FeatureDefn_1GetFieldDefn(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    OGRFeatureDefnShadow *arg1 = (OGRFeatureDefnShadow *) 0 ;
    int arg2 ;
    OGRFieldDefnShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureDefnShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (OGRFieldDefnShadow *)OGRFeatureDefnShadow_GetFieldDefn(arg1,arg2);
    
    *(OGRFieldDefnShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_FeatureDefn_1GetFieldIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jint jresult = 0 ;
    OGRFeatureDefnShadow *arg1 = (OGRFeatureDefnShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureDefnShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    result = (int)OGRFeatureDefnShadow_GetFieldIndex(arg1,(char const *)arg2);
    
    jresult = (jint)result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_FeatureDefn_1AddFieldDefn(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    OGRFeatureDefnShadow *arg1 = (OGRFeatureDefnShadow *) 0 ;
    OGRFieldDefnShadow *arg2 = (OGRFieldDefnShadow *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureDefnShadow **)(void *)&jarg1; 
    arg2 = *(OGRFieldDefnShadow **)(void *)&jarg2; 
    OGRFeatureDefnShadow_AddFieldDefn(arg1,arg2);
    
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_FeatureDefn_1GetGeomType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRFeatureDefnShadow *arg1 = (OGRFeatureDefnShadow *) 0 ;
    OGRwkbGeometryType result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureDefnShadow **)(void *)&jarg1; 
    result = (OGRwkbGeometryType)OGRFeatureDefnShadow_GetGeomType(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_FeatureDefn_1SetGeomType(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    OGRFeatureDefnShadow *arg1 = (OGRFeatureDefnShadow *) 0 ;
    OGRwkbGeometryType arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureDefnShadow **)(void *)&jarg1; 
    arg2 = (OGRwkbGeometryType)jarg2; 
    OGRFeatureDefnShadow_SetGeomType(arg1,arg2);
    
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_FeatureDefn_1GetReferenceCount(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRFeatureDefnShadow *arg1 = (OGRFeatureDefnShadow *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFeatureDefnShadow **)(void *)&jarg1; 
    result = (int)OGRFeatureDefnShadow_GetReferenceCount(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_delete_1FieldDefn(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFieldDefnShadow **)(void *)&jarg1; 
    delete_OGRFieldDefnShadow(arg1);
    
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_new_1FieldDefn(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2) {
    jlong jresult = 0 ;
    char *arg1 = (char *) "unnamed" ;
    OGRFieldType arg2 = (OGRFieldType) OFTString ;
    OGRFieldDefnShadow *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return 0;
        }
    }
    arg2 = (OGRFieldType)jarg2; 
    result = (OGRFieldDefnShadow *)new_OGRFieldDefnShadow((char const *)arg1,arg2);
    
    *(OGRFieldDefnShadow **)(void *)&jresult = result; 
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_FieldDefn_1GetName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFieldDefnShadow **)(void *)&jarg1; 
    result = (char *)OGRFieldDefnShadow_GetName(arg1);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_FieldDefn_1GetNameRef(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFieldDefnShadow **)(void *)&jarg1; 
    result = (char *)OGRFieldDefnShadow_GetNameRef(arg1);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_FieldDefn_1SetName(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    char *arg2 = (char *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFieldDefnShadow **)(void *)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return ;
        }
    }
    OGRFieldDefnShadow_SetName(arg1,(char const *)arg2);
    
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_FieldDefn_1GetFieldType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    OGRFieldType result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFieldDefnShadow **)(void *)&jarg1; 
    result = (OGRFieldType)OGRFieldDefnShadow_GetType(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_FieldDefn_1SetType(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    OGRFieldType arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFieldDefnShadow **)(void *)&jarg1; 
    arg2 = (OGRFieldType)jarg2; 
    OGRFieldDefnShadow_SetType(arg1,arg2);
    
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_FieldDefn_1GetJustify(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    OGRJustification result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFieldDefnShadow **)(void *)&jarg1; 
    result = (OGRJustification)OGRFieldDefnShadow_GetJustify(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_FieldDefn_1SetJustify(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    OGRJustification arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFieldDefnShadow **)(void *)&jarg1; 
    arg2 = (OGRJustification)jarg2; 
    OGRFieldDefnShadow_SetJustify(arg1,arg2);
    
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_FieldDefn_1GetWidth(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFieldDefnShadow **)(void *)&jarg1; 
    result = (int)OGRFieldDefnShadow_GetWidth(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_FieldDefn_1SetWidth(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFieldDefnShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    OGRFieldDefnShadow_SetWidth(arg1,arg2);
    
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_FieldDefn_1GetPrecision(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFieldDefnShadow **)(void *)&jarg1; 
    result = (int)OGRFieldDefnShadow_GetPrecision(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_FieldDefn_1SetPrecision(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    int arg2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFieldDefnShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    OGRFieldDefnShadow_SetPrecision(arg1,arg2);
    
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_FieldDefn_1GetFieldTypeName(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jstring jresult = 0 ;
    OGRFieldDefnShadow *arg1 = (OGRFieldDefnShadow *) 0 ;
    OGRFieldType arg2 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRFieldDefnShadow **)(void *)&jarg1; 
    arg2 = (OGRFieldType)jarg2; 
    result = (char *)OGRFieldDefnShadow_GetFieldTypeName(arg1,arg2);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_CreateGeometryFromWkb(JNIEnv *jenv, jclass jcls, jcharArray jarg1, jlong jarg3) {
    jlong jresult = 0 ;
    int arg1 ;
    char *arg2 = (char *) 0 ;
    OSRSpatialReferenceShadow *arg3 = (OSRSpatialReferenceShadow *) NULL ;
    OGRGeometryShadow *result;
    jboolean isCopy1 ;
    
    (void)jenv;
    (void)jcls;
    {
        /* %typemap(in) (int nLen, char *pBuf ) */
        arg1 = jenv->GetArrayLength(jarg1);
        arg2 = (char *)jenv->GetCharArrayElements(jarg1, &isCopy1);
    }
    arg3 = *(OSRSpatialReferenceShadow **)(void *)&jarg3; 
    result = (OGRGeometryShadow *)CreateGeometryFromWkb(arg1,arg2,arg3);
    
    *(OGRGeometryShadow **)(void *)&jresult = result; 
    {
        /* %typemap(argout) (int nLen, char *pBuf ) */
    }
    {
        /* %typemap(freearg) (int nLen, char *pBuf ) */
        /* This calls JNI_ABORT, so any modifications will not be passed back
              into the Java caller
           */
        if(isCopy1 == JNI_TRUE) {
            jenv->ReleaseCharArrayElements(jarg1, (jchar *)arg2, 0);
        }
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_CreateGeometryFromWkt(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    char **arg1 = (char **) 0 ;
    OSRSpatialReferenceShadow *arg2 = (OSRSpatialReferenceShadow *) NULL ;
    OGRGeometryShadow *result;
    char *val1 ;
    
    (void)jenv;
    (void)jcls;
    {
        /* %typemap(in) (char **ignorechange) */
        val1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
        arg1 = &val1;
    }
    arg2 = *(OSRSpatialReferenceShadow **)(void *)&jarg2; 
    result = (OGRGeometryShadow *)CreateGeometryFromWkt(arg1,arg2);
    
    *(OGRGeometryShadow **)(void *)&jresult = result; 
    {
        /* %typemap(freearg) (char **ignorechange) */
        jenv->ReleaseStringUTFChars(jarg1, val1);
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_CreateGeometryFromGML(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    char *arg1 = (char *) 0 ;
    OGRGeometryShadow *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (OGRGeometryShadow *)CreateGeometryFromGML((char const *)arg1);
    
    *(OGRGeometryShadow **)(void *)&jresult = result; 
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_delete_1Geometry(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    delete_OGRGeometryShadow(arg1);
    
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_new_1Geometry(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2, jint jarg3, jstring jarg4, jstring jarg5) {
    jlong jresult = 0 ;
    OGRwkbGeometryType arg1 = (OGRwkbGeometryType) wkbUnknown ;
    char *arg2 = (char *) 0 ;
    int arg3 = (int) 0 ;
    char *arg4 = (char *) 0 ;
    char *arg5 = (char *) 0 ;
    OGRGeometryShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (OGRwkbGeometryType)jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    arg3 = (int)jarg3; 
    {
        arg4 = 0;
        if (jarg4) {
            arg4 = (char *)jenv->GetStringUTFChars(jarg4, 0);
            if (!arg4) return 0;
        }
    }
    {
        arg5 = 0;
        if (jarg5) {
            arg5 = (char *)jenv->GetStringUTFChars(jarg5, 0);
            if (!arg5) return 0;
        }
    }
    result = (OGRGeometryShadow *)new_OGRGeometryShadow(arg1,arg2,arg3,arg4,arg5);
    
    *(OGRGeometryShadow **)(void *)&jresult = result; 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    {
        if (arg4) jenv->ReleaseStringUTFChars(jarg4, arg4); 
    }
    {
        if (arg5) jenv->ReleaseStringUTFChars(jarg5, arg5); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1ExportToWkt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobjectArray jarg2) {
    jint jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    char **arg2 = (char **) 0 ;
    OGRErr result;
    char *argout2 = 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    {
        /* %typemap(in) (char **argout2) */
        arg2 = &argout2;
    }
    result = (OGRErr)OGRGeometryShadow_ExportToWkt(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(argout) (char **argout) */
        jstring temp_string;
        
        if((int)jenv->GetArrayLength(jarg2) >= 1) {
            temp_string = jenv->NewStringUTF(argout2);
            jenv->SetObjectArrayElement(jarg2, 0, temp_string);
            jenv->DeleteLocalRef(temp_string);
        }
    }
    {
        /* %typemap(freearg) (char **argout) */
        if(arg2) {
            free((void *)argout2);
        }
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1ExportToWkb(JNIEnv *jenv, jclass jcls, jlong jarg1, jobjectArray jarg2, jint jarg4) {
    jint jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int *arg2 = (int *) 0 ;
    char **arg3 = (char **) 0 ;
    OGRwkbByteOrder arg4 = (OGRwkbByteOrder) wkbXDR ;
    OGRErr result;
    int nLen2 ;
    char *pBuf2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    {
        /* %typemap(in) (int *nLen2, char **pBuf2 ) */
        arg2 = &nLen2;
        arg3 = &pBuf2;
    }
    arg4 = (OGRwkbByteOrder)jarg4; 
    result = (OGRErr)OGRGeometryShadow_ExportToWkb(arg1,arg2,arg3,arg4);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(argout) (int *nLen, char **pBuf ) */
        /* make sure that the passed array is at lease length 1 */
        if(jenv->GetArrayLength(jarg2) >= 1) {
            jcharArray charArray = jenv->NewCharArray(nLen2);
            jenv->SetCharArrayRegion(charArray, (jsize)0, (jsize)nLen2, (jchar*)pBuf2);
            jenv->SetObjectArrayElement(jarg2,0,charArray);
        }
    }
    {
        /* %typemap(freearg) (int *nLen, char **pBuf ) */
        if( arg2 ) {
            free( *arg3 );
        }
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1ExportToGML(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    result = (char *)OGRGeometryShadow_ExportToGML(arg1);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1AddPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    double arg2 ;
    double arg3 ;
    double arg4 = (double) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    arg3 = (double)jarg3; 
    arg4 = (double)jarg4; 
    OGRGeometryShadow_AddPoint(arg1,arg2,arg3,arg4);
    
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1AddGeometryDirectly(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = *(OGRGeometryShadow **)(void *)&jarg2; 
    result = (OGRErr)OGRGeometryShadow_AddGeometryDirectly(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1AddGeometry(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = *(OGRGeometryShadow **)(void *)&jarg2; 
    result = (OGRErr)OGRGeometryShadow_AddGeometry(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1Clone(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    result = (OGRGeometryShadow *)OGRGeometryShadow_Clone(arg1);
    
    *(OGRGeometryShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1GetGeometryType(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRwkbGeometryType result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    result = (OGRwkbGeometryType)OGRGeometryShadow_GetGeometryType(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1GetGeometryName(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    result = (char *)OGRGeometryShadow_GetGeometryName(arg1);
    
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1GetArea(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jdouble jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    result = (double)OGRGeometryShadow_GetArea(arg1);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1GetPointCount(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    result = (int)OGRGeometryShadow_GetPointCount(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1GetX(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jdouble jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int arg2 = (int) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (double)OGRGeometryShadow_GetX(arg1,arg2);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1GetY(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jdouble jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int arg2 = (int) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (double)OGRGeometryShadow_GetY(arg1,arg2);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1GetZ(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jdouble jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int arg2 = (int) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (double)OGRGeometryShadow_GetZ(arg1,arg2);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1GetGeometryCount(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    result = (int)OGRGeometryShadow_GetGeometryCount(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1SetPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int arg2 ;
    double arg3 ;
    double arg4 ;
    double arg5 = (double) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    arg3 = (double)jarg3; 
    arg4 = (double)jarg4; 
    arg5 = (double)jarg5; 
    OGRGeometryShadow_SetPoint(arg1,arg2,arg3,arg4,arg5);
    
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1GetGeometryRef(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
    jlong jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int arg2 ;
    OGRGeometryShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = (int)jarg2; 
    result = (OGRGeometryShadow *)OGRGeometryShadow_GetGeometryRef(arg1,arg2);
    
    *(OGRGeometryShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1GetBoundary(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    result = (OGRGeometryShadow *)OGRGeometryShadow_GetBoundary(arg1);
    
    *(OGRGeometryShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1ConvexHull(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    result = (OGRGeometryShadow *)OGRGeometryShadow_ConvexHull(arg1);
    
    *(OGRGeometryShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1Buffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jdouble jarg2, jint jarg3) {
    jlong jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    double arg2 ;
    int arg3 = (int) 30 ;
    OGRGeometryShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = (double)jarg2; 
    arg3 = (int)jarg3; 
    result = (OGRGeometryShadow *)OGRGeometryShadow_Buffer(arg1,arg2,arg3);
    
    *(OGRGeometryShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1Intersection(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = *(OGRGeometryShadow **)(void *)&jarg2; 
    result = (OGRGeometryShadow *)OGRGeometryShadow_Intersection(arg1,arg2);
    
    *(OGRGeometryShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1Union(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = *(OGRGeometryShadow **)(void *)&jarg2; 
    result = (OGRGeometryShadow *)OGRGeometryShadow_Union(arg1,arg2);
    
    *(OGRGeometryShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1Difference(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = *(OGRGeometryShadow **)(void *)&jarg2; 
    result = (OGRGeometryShadow *)OGRGeometryShadow_Difference(arg1,arg2);
    
    *(OGRGeometryShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1SymmetricDifference(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jlong jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = *(OGRGeometryShadow **)(void *)&jarg2; 
    result = (OGRGeometryShadow *)OGRGeometryShadow_SymmetricDifference(arg1,arg2);
    
    *(OGRGeometryShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jdouble JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1Distance(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jdouble jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    double result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = *(OGRGeometryShadow **)(void *)&jarg2; 
    result = (double)OGRGeometryShadow_Distance(arg1,arg2);
    
    jresult = (jdouble)result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1Empty(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    OGRGeometryShadow_Empty(arg1);
    
}


JNIEXPORT jboolean JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1Intersect(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = *(OGRGeometryShadow **)(void *)&jarg2; 
    result = (bool)OGRGeometryShadow_Intersect(arg1,arg2);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1Equal(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = *(OGRGeometryShadow **)(void *)&jarg2; 
    result = (bool)OGRGeometryShadow_Equal(arg1,arg2);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1Disjoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = *(OGRGeometryShadow **)(void *)&jarg2; 
    result = (bool)OGRGeometryShadow_Disjoint(arg1,arg2);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1Touches(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = *(OGRGeometryShadow **)(void *)&jarg2; 
    result = (bool)OGRGeometryShadow_Touches(arg1,arg2);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1Crosses(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = *(OGRGeometryShadow **)(void *)&jarg2; 
    result = (bool)OGRGeometryShadow_Crosses(arg1,arg2);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1Within(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = *(OGRGeometryShadow **)(void *)&jarg2; 
    result = (bool)OGRGeometryShadow_Within(arg1,arg2);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1Contains(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = *(OGRGeometryShadow **)(void *)&jarg2; 
    result = (bool)OGRGeometryShadow_Contains(arg1,arg2);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jboolean JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1Overlaps(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jboolean jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *arg2 = (OGRGeometryShadow *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = *(OGRGeometryShadow **)(void *)&jarg2; 
    result = (bool)OGRGeometryShadow_Overlaps(arg1,arg2);
    
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1TransformTo(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OSRSpatialReferenceShadow *arg2 = (OSRSpatialReferenceShadow *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = *(OSRSpatialReferenceShadow **)(void *)&jarg2; 
    result = (OGRErr)OGRGeometryShadow_TransformTo(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1Transform(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    jint jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OSRCoordinateTransformationShadow *arg2 = (OSRCoordinateTransformationShadow *) 0 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = *(OSRCoordinateTransformationShadow **)(void *)&jarg2; 
    result = (OGRErr)OGRGeometryShadow_Transform(arg1,arg2);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1GetSpatialReference(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OSRSpatialReferenceShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    result = (OSRSpatialReferenceShadow *)OGRGeometryShadow_GetSpatialReference(arg1);
    
    *(OSRSpatialReferenceShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1AssignSpatialReference(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OSRSpatialReferenceShadow *arg2 = (OSRSpatialReferenceShadow *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    arg2 = *(OSRSpatialReferenceShadow **)(void *)&jarg2; 
    OGRGeometryShadow_AssignSpatialReference(arg1,arg2);
    
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1CloseRings(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    OGRGeometryShadow_CloseRings(arg1);
    
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1FlattenTo2D(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    OGRGeometryShadow_FlattenTo2D(arg1);
    
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1GetEnvelope(JNIEnv *jenv, jclass jcls, jlong jarg1, jdoubleArray jarg2) {
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    double *arg2 ;
    jdouble *jarr2 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    if (jarg2 && jenv->GetArrayLength(jarg2) != 4) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "incorrect array size");
        return ;
    }
    if (!SWIG_JavaArrayInDouble(jenv, &jarr2, &arg2, jarg2)) return ; 
    OGRGeometryShadow_GetEnvelope(arg1,arg2);
    
    SWIG_JavaArrayArgoutDouble(jenv, jarr2, arg2, jarg2); 
    delete [] arg2; 
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1Centroid(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    OGRGeometryShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    result = (OGRGeometryShadow *)OGRGeometryShadow_Centroid(arg1);
    
    *(OGRGeometryShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1WkbSize(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    result = (int)OGRGeometryShadow_WkbSize(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1GetCoordinateDimension(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    result = (int)OGRGeometryShadow_GetCoordinateDimension(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_Geometry_1GetDimension(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    OGRGeometryShadow *arg1 = (OGRGeometryShadow *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(OGRGeometryShadow **)(void *)&jarg1; 
    result = (int)OGRGeometryShadow_GetDimension(arg1);
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_GetDriverCount(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)OGRGetDriverCount();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_GetOpenDSCount(JNIEnv *jenv, jclass jcls) {
    jint jresult = 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    result = (int)OGRGetOpenDSCount();
    
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_org_gdal_ogr_ogrJNI_SetGenerate_1DB2_1V72_1BYTE_1ORDER(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jint jresult = 0 ;
    int arg1 ;
    OGRErr result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (int)jarg1; 
    result = (OGRErr)OGRSetGenerate_DB2_V72_BYTE_ORDER(arg1);
    
    {
        /* %typemap(out) OGRErr */
        if (result != 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException,
            OGRErrMessages(result));
            return 0;
        }
        jresult = (jint)result;
    }
    {
        /* %typemap(ret) OGRErr */
        
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_org_gdal_ogr_ogrJNI_RegisterAll(JNIEnv *jenv, jclass jcls) {
    (void)jenv;
    (void)jcls;
    OGRRegisterAll();
    
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_GetOpenDS(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jlong jresult = 0 ;
    int arg1 ;
    OGRDataSourceShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (int)jarg1; 
    result = (OGRDataSourceShadow *)GetOpenDS(arg1);
    
    *(OGRDataSourceShadow **)(void *)&jresult = result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_Open(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2) {
    jlong jresult = 0 ;
    char *arg1 = (char *) 0 ;
    int arg2 = (int) 0 ;
    OGRDataSourceShadow *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return 0;
        }
    }
    arg2 = (int)jarg2; 
    result = (OGRDataSourceShadow *)Open((char const *)arg1,arg2);
    
    *(OGRDataSourceShadow **)(void *)&jresult = result; 
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_OpenShared(JNIEnv *jenv, jclass jcls, jstring jarg1, jint jarg2) {
    jlong jresult = 0 ;
    char *arg1 = (char *) 0 ;
    int arg2 = (int) 0 ;
    OGRDataSourceShadow *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return 0;
        }
    }
    arg2 = (int)jarg2; 
    result = (OGRDataSourceShadow *)OpenShared((char const *)arg1,arg2);
    
    *(OGRDataSourceShadow **)(void *)&jresult = result; 
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_GetDriverByName(JNIEnv *jenv, jclass jcls, jstring jarg1) {
    jlong jresult = 0 ;
    char *arg1 = (char *) 0 ;
    OGRDriverShadow *result;
    
    (void)jenv;
    (void)jcls;
    {
        arg1 = 0;
        if (jarg1) {
            arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
            if (!arg1) return 0;
        }
    }
    result = (OGRDriverShadow *)GetDriverByName((char const *)arg1);
    
    *(OGRDriverShadow **)(void *)&jresult = result; 
    {
        if (arg1) jenv->ReleaseStringUTFChars(jarg1, arg1); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_org_gdal_ogr_ogrJNI_GetDriver(JNIEnv *jenv, jclass jcls, jint jarg1) {
    jlong jresult = 0 ;
    int arg1 ;
    OGRDriverShadow *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = (int)jarg1; 
    result = (OGRDriverShadow *)GetDriver(arg1);
    
    *(OGRDriverShadow **)(void *)&jresult = result; 
    return jresult;
}


#ifdef __cplusplus
}
#endif

