/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.generator;

import ch.interlis.ili2c.generator.IndentPrintWriter;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.AttributeRef;
import ch.interlis.ili2c.metamodel.BaseUnit;
import ch.interlis.ili2c.metamodel.ClassType;
import ch.interlis.ili2c.metamodel.ComposedUnit;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.DataModel;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.NumericallyDerivedUnit;
import ch.interlis.ili2c.metamodel.OIDType;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.StructuredUnitType;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.UniqueEl;
import ch.interlis.ili2c.metamodel.UniquenessConstraint;
import ch.interlis.ili2c.metamodel.Unit;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.ResourceBundle;

public final class Interlis1Generator {
    private IndentPrintWriter ipw;
    private TransferDescription td;
    private boolean genFmt = false;
    private int fmtAttrIdx;
    private static String FMT_CMT = "!!!!";
    private Type typeOf_ILI1_DATE;
    private Type typeOf_URI;
    private Type typeOf_NAME;
    private Type typeOf_BOOLEAN;
    private Type typeOf_HALIGNMENT;
    private Type typeOf_VALIGNMENT;
    private int numErrors = 0;
    private static ResourceBundle rsrc;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ch.interlis.ili2c.generator.Interlis1Generator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        rsrc = ResourceBundle.getBundle(clazz.getName(), Locale.getDefault());
    }

    private Interlis1Generator(Writer out, TransferDescription td) {
        this.ipw = new IndentPrintWriter(out);
        this.td = td;
        this.typeOf_ILI1_DATE = td.INTERLIS.INTERLIS_1_DATE.getType();
        this.typeOf_URI = td.INTERLIS.URI.getType();
        this.typeOf_NAME = td.INTERLIS.NAME.getType();
        this.typeOf_BOOLEAN = td.INTERLIS.BOOLEAN.getType();
        this.typeOf_HALIGNMENT = td.INTERLIS.HALIGNMENT.getType();
        this.typeOf_VALIGNMENT = td.INTERLIS.VALIGNMENT.getType();
    }

    private void finish() {
        this.ipw.close();
    }

    private void printError() {
        ++this.numErrors;
        this.ipw.print(Element.makeErrorName(null));
    }

    private final boolean printErrorOrToString(Object obj) {
        if (obj == null) {
            this.printError();
            return true;
        }
        if (obj instanceof PrecisionDecimal) {
            this.ipw.print(((PrecisionDecimal)obj).toIli1String());
        } else {
            this.ipw.print(obj.toString());
        }
        return false;
    }

    private void printExplanation(String explanation) {
        this.ipw.print("//");
        if (explanation != null) {
            this.ipw.print(explanation);
        }
        this.ipw.print("//");
    }

    public static int generate(Writer out, TransferDescription td) {
        Interlis1Generator i = new Interlis1Generator(out, td);
        i.printTransferDescription(td);
        i.finish();
        return i.numErrors;
    }

    public static int generateFmt(Writer out, TransferDescription td) {
        Interlis1Generator i = new Interlis1Generator(out, td);
        i.genFmt = true;
        i.printTransferDescription(td);
        i.finish();
        return i.numErrors;
    }

    private void printTransferDescriptionHeader(TransferDescription td) {
        if (this.genFmt) {
            this.ipw.println("SCNT");
            this.ipw.println("Beschreibung der Transferdatei");
            this.ipw.println("////");
            this.ipw.println("MTID model.ili");
        } else {
            this.ipw.println("TRANSFER TransferName;");
            this.ipw.println();
        }
    }

    private void printTransferDescriptionTrailer(TransferDescription td) {
        if (this.genFmt) {
            this.ipw.println("ENDE");
        } else {
            this.ipw.println("FORMAT");
            this.ipw.indent();
            this.ipw.println("FREE;");
            this.ipw.unindent();
            this.ipw.println();
            this.ipw.println("CODE");
            this.ipw.indent();
            this.ipw.println("BLANK = DEFAULT, UNDEFINED = DEFAULT, CONTINUE = DEFAULT;");
            this.ipw.println("TID = ANY;");
            this.ipw.unindent();
            this.ipw.println("END.");
        }
    }

    private void printTransferDescription(TransferDescription td) {
        this.printTransferDescriptionHeader(td);
        int numEmittedModels = 0;
        Iterator iter = td.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof Model) || !this.needToPrintModel((Model)obj)) continue;
            if (numEmittedModels > 0) {
                this.printTransferDescriptionTrailer(td);
                if (!this.genFmt) {
                    this.ipw.println();
                    this.ipw.println();
                    this.ipw.println("!! " + rsrc.getString("err_multipleModels_line_1"));
                    this.ipw.println("!! " + rsrc.getString("err_multipleModels_line_2"));
                    this.ipw.println("!! " + rsrc.getString("err_multipleModels_line_3"));
                    this.ipw.println();
                }
                this.printTransferDescriptionHeader(td);
            }
            ++numEmittedModels;
            this.printModel((Model)obj);
            if (this.genFmt) continue;
            this.ipw.println();
        }
        this.printTransferDescriptionTrailer(td);
    }

    private boolean needToPrintModel(Model model) {
        if (model == null) {
            return false;
        }
        if (model == this.td.INTERLIS) {
            return false;
        }
        if (!(model instanceof DataModel)) {
            return false;
        }
        Iterator iter = model.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof Topic) || !this.needToPrintTopic((Topic)obj)) continue;
            return true;
        }
        return false;
    }

    private boolean needToPrintTopic(Topic topic) {
        if (topic == null) {
            return false;
        }
        if (topic.isAbstract()) {
            return true;
        }
        Iterator iter = topic.getViewables().iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof Table) || !this.needToPrintTable((Table)obj)) continue;
            return true;
        }
        return false;
    }

    private boolean needToPrintTable(AbstractClassDef table) {
        if (table == null) {
            return false;
        }
        if (table instanceof Table && ((Table)table).isImplicit()) {
            return false;
        }
        if (table.isAbstract()) {
            return false;
        }
        if (table instanceof Table && ((Table)table).isIdentifiable()) {
            return true;
        }
        return table instanceof AssociationDef && !((AssociationDef)table).isLightweight();
    }

    private void printModel(Model model) {
        Class<?> lastPrinted = null;
        if (this.genFmt) {
            this.ipw.println("MODL " + model.getName());
        } else {
            this.ipw.print("MODEL ");
            this.ipw.println(model.getName());
            this.ipw.indent();
        }
        Iterator iter = model.iterator();
        while (iter.hasNext()) {
            Topic topic;
            Object obj = iter.next();
            if (!(obj instanceof Topic) || !this.needToPrintTopic(topic = (Topic)obj)) continue;
            if (lastPrinted != null && !this.genFmt) {
                this.ipw.println();
            }
            this.printTopic(topic);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("ch.interlis.ili2c.metamodel.Topic");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            lastPrinted = clazz;
        }
        if (this.genFmt) {
            this.ipw.println("EMOD");
        } else {
            this.ipw.unindent();
            this.ipw.print("END ");
            this.ipw.print(model.getName());
            this.ipw.println('.');
        }
    }

    private void printTopic(Topic topic) {
        if (this.genFmt) {
            this.ipw.println(FMT_CMT);
            this.ipw.println("TOPI " + topic.getName());
        } else {
            this.ipw.print("TOPIC ");
            this.ipw.print(topic.getName());
            this.ipw.println(" =");
            this.ipw.indent();
        }
        Class<?> lastPrinted = null;
        Iterator iter = topic.getViewables().iterator();
        while (iter.hasNext()) {
            AbstractClassDef table;
            Object obj = iter.next();
            if (!(obj instanceof AbstractClassDef) || !this.needToPrintTable(table = (AbstractClassDef)obj)) continue;
            if (lastPrinted != null && !this.genFmt) {
                this.ipw.println();
            }
            this.printTable(table);
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = Class.forName("ch.interlis.ili2c.metamodel.Table");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            lastPrinted = clazz;
        }
        if (this.genFmt) {
            this.ipw.println("ETOP");
        } else {
            this.ipw.unindent();
            this.ipw.print("END ");
            this.ipw.print(topic.getName());
            this.ipw.println('.');
        }
    }

    private Iterator determineUniquenessConstraints(AbstractClassDef forTable) {
        LinkedList result = new LinkedList();
        AbstractClassDef tab = forTable;
        while (tab != null) {
            Iterator iter = tab.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof UniquenessConstraint)) continue;
                result.add(obj);
            }
            tab = (AbstractClassDef)tab.getExtending();
        }
        return result.iterator();
    }

    private void printTable(AbstractClassDef table) {
        AttributeDef attr;
        Iterator iter;
        if (this.genFmt) {
            iter = table.getAttributes();
            while (iter.hasNext()) {
                AttributeDef attr2;
                Type type;
                Object obj = iter.next();
                if (!(obj instanceof AttributeDef) || !((type = Type.findReal((attr2 = (AttributeDef)obj).getDomain())) instanceof AreaType)) continue;
                this.printSurfaceOrAreaTypeFmt(table, attr2, (AreaType)type);
            }
            this.ipw.println(FMT_CMT);
            this.ipw.println("TABL " + table.getName());
            this.ipw.print("OBJE " + this.genFmtField(1, 1));
            this.fmtAttrIdx = 2;
        } else {
            this.ipw.print("TABLE ");
            this.ipw.print(table.getName());
            this.ipw.println(" =");
            this.ipw.indent();
        }
        ArrayList attrlist = new ArrayList();
        iter = table.getAttributesAndRoles();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof AttributeDef) {
                attrlist.add(obj);
                continue;
            }
            if (!(obj instanceof RoleDef) || ((AssociationDef)table).isLightweight()) continue;
            attrlist.add(obj);
        }
        ArrayList rolesSorted = new ArrayList(table.getLightweightAssociations());
        Collections.sort(rolesSorted, new Comparator(){

            public int compare(Object o1, Object o2) {
                int idx2;
                int idx1 = ((RoleDef)o1).getIli1AttrIdx();
                if (idx1 == (idx2 = ((RoleDef)o2).getIli1AttrIdx())) {
                    return 0;
                }
                if (idx1 == -1) {
                    return 1;
                }
                if (idx2 == -1) {
                    return -1;
                }
                if (idx1 < idx2) {
                    return -1;
                }
                return 1;
            }
        });
        iter = ((AbstractList)rolesSorted).iterator();
        while (iter.hasNext()) {
            RoleDef role = (RoleDef)iter.next();
            RoleDef oppend = this.getOppEnd(role);
            if (role.getIli1AttrIdx() == -1) {
                attrlist.add(role);
                continue;
            }
            attrlist.add(role.getIli1AttrIdx(), role);
        }
        iter = attrlist.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof AttributeDef) {
                attr = (AttributeDef)obj;
                this.printAttribute(table, attr);
                continue;
            }
            if (!(obj instanceof RoleDef)) continue;
            RoleDef role = (RoleDef)obj;
            if (role.getContainer() == table && table instanceof AssociationDef && !((AssociationDef)table).isLightweight()) {
                if (this.genFmt) {
                    this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, 1));
                    ++this.fmtAttrIdx;
                    continue;
                }
                this.ipw.println(String.valueOf(role.getName()) + " : ->" + role.getDestination().getName() + ";");
                continue;
            }
            if (role.getContainer() == table) continue;
            RoleDef oppend = this.getOppEnd(role);
            if (this.genFmt) {
                this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, 1));
                ++this.fmtAttrIdx;
                continue;
            }
            this.ipw.println(String.valueOf(oppend.getName()) + " : ->" + oppend.getDestination().getName() + ";");
        }
        if (this.genFmt) {
            this.ipw.println("");
            this.ipw.println(FMT_CMT);
            this.ipw.println(String.valueOf(FMT_CMT) + " 1: Objektidentifikation");
            iter = attrlist.iterator();
            int idx = 2;
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj instanceof AttributeDef) {
                    AttributeDef attr3 = (AttributeDef)obj;
                    Type type = Type.findReal(attr3.getDomain());
                    if (!(type instanceof LineType) || type instanceof AreaType) {
                        this.ipw.println(String.valueOf(FMT_CMT) + " " + this.getIdxCode(idx) + ": " + attr3.getName());
                    }
                } else if (obj instanceof RoleDef) {
                    RoleDef role = (RoleDef)obj;
                    if (role.getContainer() == table && table instanceof AssociationDef && !((AssociationDef)table).isLightweight()) {
                        this.ipw.println(String.valueOf(FMT_CMT) + " " + this.getIdxCode(idx) + ": " + role.getName() + " ->" + role.getDestination().getName());
                    } else if (role.getContainer() != table) {
                        RoleDef oppend = this.getOppEnd(role);
                        this.ipw.println(String.valueOf(FMT_CMT) + " " + this.getIdxCode(idx) + ": " + oppend.getName() + " ->" + oppend.getDestination().getName());
                    }
                }
                ++idx;
            }
            this.ipw.println(FMT_CMT);
            iter = table.getAttributes();
            while (iter.hasNext()) {
                attr = (AttributeDef)iter.next();
                Type type = Type.findReal(attr.getDomain());
                if (!(type instanceof PolylineType)) continue;
                this.ipw.println(String.valueOf(FMT_CMT) + " " + attr.getName());
                this.printLineTypeFmt((PolylineType)type);
            }
        } else {
            this.ipw.unindent();
            Iterator idents = this.determineUniquenessConstraints(table);
            if (idents.hasNext()) {
                this.ipw.println("IDENT");
                this.ipw.indent();
                do {
                    UniquenessConstraint uc;
                    UniqueEl attribs;
                    if ((attribs = (uc = (UniquenessConstraint)idents.next()).getElements()) == null) {
                        this.printError();
                    } else {
                        Iterator attri = attribs.iteratorAttribute();
                        String sep = "";
                        while (attri.hasNext()) {
                            ObjectPath path = (ObjectPath)attri.next();
                            if (path == null) {
                                this.printError();
                            } else {
                                this.ipw.print(String.valueOf(sep) + ((AttributeRef)path.getPathElements()[0]).getName());
                            }
                            sep = ", ";
                        }
                    }
                    this.ipw.println(';');
                } while (idents.hasNext());
                this.ipw.unindent();
            } else {
                this.ipw.println("NO IDENT");
            }
        }
        if (this.genFmt) {
            this.ipw.println("ETAB");
            iter = table.getAttributes();
            while (iter.hasNext()) {
                AttributeDef attr4 = (AttributeDef)iter.next();
                Type type = Type.findReal(attr4.getDomain());
                if (!(type instanceof SurfaceType)) continue;
                this.printSurfaceOrAreaTypeFmt(table, attr4, (SurfaceType)type);
            }
        } else {
            this.ipw.print("END ");
            this.ipw.print(table.getName());
            this.ipw.println(';');
        }
    }

    private void printAttribute(AbstractClassDef forTable, AttributeDef attr) {
        if (attr.isAbstract()) {
            return;
        }
        if (this.genFmt) {
            String comment = this.printType(forTable, attr.getDomain(), false);
            ++this.fmtAttrIdx;
        } else {
            this.ipw.print(attr.getName());
            this.ipw.print(": ");
            String comment = this.printType(forTable, attr.getDomain(), false);
            if (comment != null) {
                this.ipw.print(";  !! ");
                this.ipw.println(comment);
            } else {
                this.ipw.println(';');
            }
        }
    }

    private String printType(Container scope, Type typ, boolean withoutOptional) {
        String comment = null;
        if (typ == null) {
            this.printError();
            return rsrc.getString("err_inSource");
        }
        Type t = typ;
        boolean mand = false;
        do {
            mand |= t.isMandatory();
            if (!(t instanceof TypeAlias)) continue;
            Domain aliased = ((TypeAlias)t).getAliasing();
            t = aliased == null ? null : aliased.getType();
        } while (t instanceof TypeAlias);
        if (!(mand || this.genFmt || withoutOptional)) {
            this.ipw.print("OPTIONAL ");
        }
        if ((t = Type.findReal(typ)) instanceof TextType) {
            if (t == this.typeOf_ILI1_DATE) {
                if (this.genFmt) {
                    this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, 8));
                } else {
                    this.ipw.print("DATE");
                }
                return null;
            }
            if (this.genFmt) {
                this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, ((TextType)t).getMaxLength()));
            } else {
                this.ipw.print("TEXT*");
                this.ipw.print(((TextType)t).getMaxLength());
            }
            if (t == this.typeOf_URI) {
                comment = rsrc.getString("comment_uri");
            } else if (t == this.typeOf_NAME) {
                comment = rsrc.getString("comment_name");
            }
            return comment;
        }
        if (t instanceof NumericType) {
            return this.printNumericType((NumericType)t);
        }
        if (t instanceof CoordType) {
            return this.printCoordType((CoordType)t);
        }
        if (t instanceof EnumerationType) {
            if (t == this.typeOf_BOOLEAN) {
                if (this.genFmt) {
                    this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, 1));
                } else {
                    this.ipw.print("BOOLEAN");
                }
            } else if (t == this.typeOf_HALIGNMENT) {
                if (this.genFmt) {
                    this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, 1));
                } else {
                    this.ipw.print("HALIGNMENT");
                }
            } else if (t == this.typeOf_VALIGNMENT) {
                if (this.genFmt) {
                    this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, 1));
                } else {
                    this.ipw.print("VALIGNMENT");
                }
            } else {
                this.printEnumeration(((EnumerationType)t).getEnumeration());
            }
        } else {
            if (t instanceof LineType) {
                if (this.genFmt) {
                    LineType lineType = (LineType)Type.findReal(t);
                    if (lineType instanceof AreaType) {
                        Domain controlPointDomain = lineType.getControlPointDomain();
                        if (controlPointDomain == null) {
                            this.printError();
                        } else {
                            return this.printCoordType((CoordType)Type.findReal(controlPointDomain.getType()));
                        }
                    }
                    return null;
                }
                return this.printLineType((LineType)t);
            }
            if (t instanceof ReferenceType) {
                return this.printReferenceType(scope, (ReferenceType)t);
            }
            if (t instanceof ClassType) {
                int classTypeLen = 767;
                if (this.genFmt) {
                    this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, classTypeLen));
                } else {
                    this.ipw.print("TEXT*");
                    this.ipw.print(classTypeLen);
                }
                return null;
            }
            if (t instanceof StructuredUnitType) {
                StructuredUnitType st = (StructuredUnitType)t;
                int textLen = Math.min(st.getMaximum().toString().length(), st.getMinimum().toString().length());
                if (this.genFmt) {
                    this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, textLen));
                } else {
                    this.ipw.print("TEXT*");
                    this.ipw.print(textLen);
                }
                return null;
            }
            if (t instanceof OIDType) {
                OIDType ot = (OIDType)t;
                return this.printType(scope, ot.getOIDType(), true);
            }
            this.printError();
            return rsrc.getString("err_notExpressible");
        }
        return comment;
    }

    private String printReferenceType(Container scope, ReferenceType type) {
        if (!this.genFmt) {
            Topic referredTopic;
            AbstractClassDef referred;
            if (type == null || (referred = type.getReferred()) == null) {
                this.printError();
                return rsrc.getString("err_inSource");
            }
            if (referred.isAbstract()) {
                this.printError();
                this.ipw.println();
                this.ipw.print("!! ");
                this.ipw.println(new MessageFormat(rsrc.getString("err_relationToAbstractClass_line_1")).format(new Object[]{referred.toString()}));
                this.ipw.print("!! ");
                this.ipw.println(rsrc.getString("err_relationToAbstractClass_line_2"));
                return null;
            }
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("ch.interlis.ili2c.metamodel.Topic");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Topic scopeTopic = (Topic)scope.getContainerOrSame(clazz);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("ch.interlis.ili2c.metamodel.Topic");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (scopeTopic != (referredTopic = (Topic)referred.getContainer(clazz2))) {
                this.printError();
                this.ipw.println();
                this.ipw.print("!! ");
                this.ipw.println(new MessageFormat(rsrc.getString("err_crossTopicRelation_line_1")).format(new Object[]{referred.toString(), referredTopic.toString(), scopeTopic.toString()}));
                this.ipw.print("!! ");
                this.ipw.println(rsrc.getString("err_crossTopicRelation_line_2"));
                return null;
            }
            String referredName = referred.getName();
            this.ipw.print("-> ");
            if (referredName == null || referredName.length() == 0) {
                this.printError();
                return rsrc.getString("err_inSource");
            }
            this.ipw.print(referredName);
        }
        return null;
    }

    private String printNumericType(NumericType type) {
        String before;
        if (this.genFmt) {
            String fld = this.genFmtField(this.fmtAttrIdx, type.getMinimum(), type.getMaximum());
            this.ipw.print(" " + fld);
            return null;
        }
        Unit unit = type.getUnit();
        String between = " ";
        String after = "";
        String comment = null;
        boolean error = false;
        if (unit != null) {
            String docName = unit.getDocName();
            String shortName = unit.getName();
            if (shortName != null) {
                comment = shortName.equals(docName) ? "[" + shortName + "]" : String.valueOf(docName) + " [" + shortName + "]";
            }
        }
        if (this.isDIM1(type)) {
            before = "DIM1 ";
        } else if (this.isDIM2(type)) {
            before = "DIM2 ";
        } else if (this.isRADIANS(type)) {
            before = "RADIANS ";
            comment = null;
        } else if (this.isDEGREES(type)) {
            before = "DEGREES ";
            comment = null;
        } else if (this.isGRADS(type)) {
            before = "GRADS ";
            comment = null;
        } else {
            before = "[";
            between = " .. ";
            after = "]";
        }
        this.ipw.print(before);
        error |= this.printErrorOrToString(type.getMinimum());
        this.ipw.print(between);
        this.ipw.print(after);
        if (error |= this.printErrorOrToString(type.getMaximum())) {
            return rsrc.getString("err_inSource");
        }
        return comment;
    }

    private boolean isDIM1(NumericType type) {
        if (type == null) {
            return false;
        }
        Unit unit = type.getUnit();
        if (unit == null) {
            return false;
        }
        if (!(unit instanceof NumericallyDerivedUnit) && !(unit instanceof BaseUnit)) {
            return false;
        }
        return unit.isExtendingIndirectly(this.td.INTERLIS.LENGTH);
    }

    private boolean isDIM2(NumericType type) {
        if (type == null) {
            return false;
        }
        Unit unit = type.getUnit();
        if (!(unit instanceof ComposedUnit)) {
            return false;
        }
        ComposedUnit.Composed[] parts = ((ComposedUnit)unit).getComposedUnits();
        if (parts == null || parts.length != 2) {
            return false;
        }
        if (!parts[0].getUnit().isExtendingIndirectly(this.td.INTERLIS.LENGTH)) {
            return false;
        }
        if (parts[0].getCompositionOperator() != '*') {
            return false;
        }
        if (!parts[1].getUnit().isExtendingIndirectly(this.td.INTERLIS.LENGTH)) {
            return false;
        }
        return parts[1].getCompositionOperator() == '*';
    }

    private boolean isRADIANS(NumericType type) {
        if (type == null) {
            return false;
        }
        return type.getUnit() == this.td.INTERLIS.RADIAN;
    }

    private boolean isDEGREES(NumericType type) {
        if (type == null) {
            return false;
        }
        Unit unit = type.getUnit();
        if (!(unit instanceof NumericallyDerivedUnit)) {
            return false;
        }
        Unit baseUnit = (Unit)((NumericallyDerivedUnit)unit).getExtending();
        if (baseUnit != this.td.INTERLIS.RADIAN) {
            return false;
        }
        NumericallyDerivedUnit.Factor[] factors = ((NumericallyDerivedUnit)unit).getConversionFactors();
        if (factors == null || factors.length != 2 || factors[0] == null || factors[1] == null) {
            return false;
        }
        if (factors[0].getConversionFactor() != Math.PI) {
            return false;
        }
        if (factors[0].getConversionOperator() != '*') {
            return false;
        }
        if (factors[1].getConversionFactor() != 180.0) {
            return false;
        }
        return factors[1].getConversionOperator() == '/';
    }

    private boolean isGRADS(NumericType type) {
        if (type == null) {
            return false;
        }
        Unit unit = type.getUnit();
        if (!(unit instanceof NumericallyDerivedUnit)) {
            return false;
        }
        Unit baseUnit = (Unit)((NumericallyDerivedUnit)unit).getExtending();
        if (baseUnit != this.td.INTERLIS.RADIAN) {
            return false;
        }
        NumericallyDerivedUnit.Factor[] factors = ((NumericallyDerivedUnit)unit).getConversionFactors();
        if (factors == null || factors.length != 2 || factors[0] == null || factors[1] == null) {
            return false;
        }
        if (factors[0].getConversionFactor() != Math.PI) {
            return false;
        }
        if (factors[0].getConversionOperator() != '*') {
            return false;
        }
        if (factors[1].getConversionFactor() != 200.0) {
            return false;
        }
        return factors[1].getConversionOperator() == '/';
    }

    private int countEnumLeafs(Enumeration enumer) {
        int ret = 0;
        Iterator iter = enumer.getElements();
        while (iter.hasNext()) {
            Enumeration.Element ee = (Enumeration.Element)iter.next();
            Enumeration subEnum = ee.getSubEnumeration();
            if (subEnum != null) {
                ret += this.countEnumLeafs(subEnum);
                continue;
            }
            ++ret;
        }
        return ret;
    }

    private void printEnumeration(Enumeration enumer) {
        if (this.genFmt) {
            int leafs = this.countEnumLeafs(enumer);
            int size = Integer.toString(leafs).length();
            this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, size));
        } else {
            this.ipw.println('(');
            this.ipw.indent();
            if (enumer == null) {
                this.printError();
            } else {
                Iterator iter = enumer.getElements();
                while (iter.hasNext()) {
                    this.printEnumerationElement((Enumeration.Element)iter.next());
                    if (!iter.hasNext()) continue;
                    this.ipw.println(',');
                }
            }
            this.ipw.unindent();
            this.ipw.print(')');
        }
    }

    private void printEnumerationElement(Enumeration.Element ee) {
        this.ipw.print(ee.getName());
        Enumeration subEnum = ee.getSubEnumeration();
        if (subEnum != null) {
            this.ipw.print(' ');
            this.printEnumeration(subEnum);
        }
    }

    private String printCoordType(CoordType coord) {
        if (coord == null) {
            this.printError();
            return rsrc.getString("err_inSource");
        }
        NumericalType[] dimensions = coord.getDimensions();
        boolean error = false;
        if (dimensions == null) {
            this.printError();
            return rsrc.getString("err_inSource");
        }
        if (dimensions.length == 2) {
            if (!this.genFmt) {
                this.ipw.print("COORD2");
            }
        } else if (dimensions.length == 3) {
            if (!this.genFmt) {
                this.ipw.print("COORD3");
            }
        } else {
            this.printError();
            return rsrc.getString("err_notExpressible");
        }
        if (dimensions[0] instanceof StructuredUnitType || dimensions[1] instanceof StructuredUnitType || dimensions.length > 2 && dimensions[2] instanceof StructuredUnitType) {
            this.printError();
            return rsrc.getString("err_notExpressible");
        }
        if (!this.genFmt) {
            this.ipw.println();
            this.ipw.indent();
        }
        PrecisionDecimal minE = null;
        PrecisionDecimal minN = null;
        PrecisionDecimal minH = null;
        PrecisionDecimal maxE = null;
        PrecisionDecimal maxN = null;
        PrecisionDecimal maxH = null;
        NumericType eastingDimension = dimensions[0] instanceof NumericType ? (NumericType)dimensions[0] : null;
        NumericType northingDimension = dimensions[1] instanceof NumericType ? (NumericType)dimensions[1] : null;
        NumericType heightDimension = dimensions.length == 3 && dimensions[2] instanceof NumericType ? (NumericType)dimensions[2] : null;
        if (eastingDimension != null) {
            minE = eastingDimension.getMinimum();
            maxE = eastingDimension.getMaximum();
        }
        if (northingDimension != null) {
            minN = northingDimension.getMinimum();
            maxN = northingDimension.getMaximum();
        }
        if (heightDimension != null) {
            minH = heightDimension.getMinimum();
            maxH = heightDimension.getMaximum();
        }
        if (this.genFmt) {
            this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, minE, maxE));
            this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, minN, maxN));
            if (dimensions.length == 3) {
                this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, minH, maxH));
            }
        } else {
            error |= this.printErrorOrToString(minE);
            this.ipw.print(' ');
            error |= this.printErrorOrToString(minN);
            if (dimensions.length == 3) {
                this.ipw.print(' ');
                error |= this.printErrorOrToString(minH);
            }
            this.ipw.println();
            error |= this.printErrorOrToString(maxE);
            this.ipw.print(' ');
            error |= this.printErrorOrToString(maxN);
            if (dimensions.length == 3) {
                this.ipw.print(' ');
                error |= this.printErrorOrToString(maxH);
            }
            this.ipw.unindent();
        }
        if (error) {
            return rsrc.getString("err_inSource");
        }
        return null;
    }

    private String printLineType(LineType lineType) {
        if (this.genFmt) {
            return null;
        }
        String comment = null;
        if (lineType instanceof PolylineType) {
            this.ipw.print("POLYLINE ");
        } else if (lineType instanceof SurfaceType) {
            this.ipw.print("SURFACE ");
        } else if (lineType instanceof AreaType) {
            this.ipw.print("AREA ");
        }
        LineForm[] lineForms = lineType.getLineForms();
        this.ipw.print("WITH (");
        int i = 0;
        while (i < lineForms.length) {
            if (i > 0) {
                this.ipw.print(", ");
            }
            if (lineForms[i] == null) {
                this.printError();
            } else if (lineForms[i] == this.td.INTERLIS.STRAIGHTS) {
                this.ipw.print("STRAIGHTS");
            } else if (lineForms[i] == this.td.INTERLIS.ARCS) {
                this.ipw.print("ARCS");
            } else {
                this.printExplanation(lineForms[i].getExplanation());
            }
            ++i;
        }
        this.ipw.println(")");
        this.ipw.indent();
        this.ipw.print("VERTEX ");
        Domain controlPointDomain = lineType.getControlPointDomain();
        if (controlPointDomain == null) {
            this.printError();
        } else {
            comment = this.printCoordType((CoordType)Type.findReal(controlPointDomain.getType()));
        }
        PrecisionDecimal maxOverlap = lineType.getMaxOverlap();
        if (maxOverlap != null) {
            this.ipw.println();
            this.ipw.print("WITHOUT OVERLAPS > ");
            this.ipw.print(maxOverlap.toString());
        }
        this.printLineAttributes(lineType);
        this.ipw.unindent();
        return comment;
    }

    private void printSurfaceOrAreaTypeFmt(AbstractClassDef table, AttributeDef thisAttr, SurfaceOrAreaType lineType) {
        if (!this.genFmt) {
            return;
        }
        this.ipw.println(FMT_CMT);
        this.ipw.println("TABL " + table.getName() + "_" + thisAttr.getName());
        this.ipw.print("OBJE " + this.genFmtField(1, 1));
        this.fmtAttrIdx = 2;
        if (lineType instanceof SurfaceType) {
            this.ipw.print(" " + this.genFmtField(this.fmtAttrIdx, 1));
            ++this.fmtAttrIdx;
        }
        Iterator iter = null;
        Table attributeTable = lineType.getLineAttributeStructure();
        if (attributeTable != null) {
            iter = attributeTable.getAttributes();
            while (iter.hasNext()) {
                this.printAttribute(attributeTable, (AttributeDef)iter.next());
            }
        }
        this.ipw.println();
        this.ipw.println(FMT_CMT);
        this.ipw.println(String.valueOf(FMT_CMT) + " 1: Objektidentifikation");
        int idx = 2;
        if (lineType instanceof SurfaceType) {
            this.ipw.println(String.valueOf(FMT_CMT) + " 2: ->" + table.getName());
            ++idx;
        }
        if (attributeTable != null) {
            iter = attributeTable.getAttributes();
            while (iter.hasNext()) {
                AttributeDef attr = (AttributeDef)iter.next();
                Type type = Type.findReal(attr.getDomain());
                if (!(type instanceof LineType) || type instanceof AreaType) {
                    this.ipw.println(String.valueOf(FMT_CMT) + " " + this.getIdxCode(idx) + ": " + attr.getName());
                }
                ++idx;
            }
        }
        this.ipw.println(FMT_CMT);
        this.printLineTypeFmt(lineType);
        this.ipw.println("ETAB");
    }

    private void printLineTypeFmt(LineType lineType) {
        if (!this.genFmt) {
            return;
        }
        if (!(lineType instanceof PolylineType) && !(lineType instanceof SurfaceType)) {
            boolean cfr_ignored_0 = lineType instanceof AreaType;
        }
        CoordType ct = null;
        Domain controlPointDomain = lineType.getControlPointDomain();
        if (controlPointDomain == null) {
            this.printError();
        } else {
            ct = (CoordType)Type.findReal(controlPointDomain.getType());
        }
        this.fmtAttrIdx = 1;
        this.ipw.print("STPT ");
        this.printCoordType(ct);
        this.ipw.println();
        this.ipw.print("LIPT ");
        this.printCoordType(ct);
        this.ipw.println();
        LineForm[] lineForms = lineType.getLineForms();
        int i = 0;
        while (i < lineForms.length) {
            if (lineForms[i] == null) {
                this.printError();
            }
            if (lineForms[i] == this.td.INTERLIS.ARCS) {
                this.ipw.print("ARCP ");
                this.printCoordType(ct);
                this.ipw.println();
            }
            ++i;
        }
        this.ipw.println("ELIN");
    }

    private void printLineAttributes(LineType lineType) {
        if (lineType == null) {
            return;
        }
        Table attributeTable = null;
        if (lineType instanceof SurfaceOrAreaType) {
            attributeTable = ((SurfaceOrAreaType)lineType).getLineAttributeStructure();
        }
        if (attributeTable == null) {
            return;
        }
        boolean hasOutput = false;
        Iterator attrs = attributeTable.getAttributes();
        while (attrs.hasNext()) {
            AttributeDef attr = (AttributeDef)attrs.next();
            if (!hasOutput) {
                this.ipw.println();
                this.ipw.println("LINEATTR =");
                this.ipw.indent();
                hasOutput = true;
            }
            this.printAttribute(attributeTable, attr);
        }
        if (hasOutput) {
            this.ipw.unindent();
            this.ipw.print("END");
        }
    }

    private char getIdxCode(int idx) {
        return Character.toUpperCase(Character.forDigit(idx, 36));
    }

    private String genFmtField(int idx, int size) {
        StringBuffer ret = new StringBuffer(size);
        char c = this.getIdxCode(idx);
        int i = 0;
        while (i < size) {
            ret.append(c);
            ++i;
        }
        return ret.toString();
    }

    private String genFmtField(int idx, PrecisionDecimal value) {
        StringBuffer ret = new StringBuffer(10);
        char c = this.getIdxCode(idx);
        int size = value.toBigInteger().toString().length();
        int i = 0;
        while (i < size) {
            ret.append(c);
            ++i;
        }
        size = value.getAccuracy();
        if (size > 0) {
            ret.append('.');
            i = 0;
            while (i < size) {
                ret.append(c);
                ++i;
            }
        }
        return ret.toString();
    }

    private String genFmtField(int idx, PrecisionDecimal min, PrecisionDecimal max) {
        String minFld = this.genFmtField(idx, min);
        String maxFld = this.genFmtField(idx, max);
        if (minFld.length() > maxFld.length()) {
            return minFld;
        }
        return maxFld;
    }

    private RoleDef getOppEnd(RoleDef oneRole) {
        RoleDef role1 = null;
        RoleDef role2 = null;
        Iterator rolei = ((AssociationDef)oneRole.getContainer()).getAttributesAndRoles();
        while (rolei.hasNext()) {
            Object obj = rolei.next();
            if (!(obj instanceof RoleDef)) continue;
            if (role1 == null) {
                role1 = (RoleDef)obj;
                continue;
            }
            if (role2 != null) continue;
            role2 = (RoleDef)obj;
        }
        if (role1 == oneRole) {
            return role2;
        }
        return role1;
    }
}

