package GCPlugins::GCfilms::GCKinopoisk;

use strict;
use utf8;
use Encode qw(encode);

use GCPlugins::GCfilms::GCfilmsCommon;

{
    package GCPlugins::GCfilms::GCPluginKinopoisk;

    use base qw(GCPlugins::GCfilms::GCfilmsPluginsBase);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
        $self->{inside}->{$tagname}++;
	
        if ($self->{parsingEnded})
        {
            return;
        }
	
        if ($self->{parsingList})
        {
            if ($tagname eq "a")
            {
                if ($attr->{class} eq "all")
		{
		    my $url = $attr->{href};
                    if ($url =~ m/\/level\/1\/film/)
                    {
			$self->{isMovie} = 1;
                        $self->{itemIdx}++;
                        $self->{itemsList}[$self->{itemIdx}]->{url} = $url;
                    }
    	        }
		if ($attr->{class} eq "orange")
		{
		    $self->{isYear} = 1;		
		}
    	    }
            elsif ($tagname eq "title")
            {
                $self->{insideHTMLtitle} = 1;
            }
        }   
    	else
    	{
            if ($attr->{class} eq "moviename-big")
            {
                $self->{insideTitle} = 1;
            }
	    elsif ($tagname eq "span" && $attr->{style} eq "font-size:13px;color:#666")
	    {
	        $self->{insideOriginal} = 1;
	    }
            elsif ($tagname eq "a" && $attr->{class} eq "all")
            {
		if ($attr->{href} =~ m/\/level\/10\/m\_act\%5Byear\%5D/)
		{
                    $self->{insideDate} = 1;
		}
		if ($attr->{href} =~ m/\/level\/10\/m\_act\%5Bcountry\%5D/)
		{
		    $self->{insideCountry} = 1;
		}
		if ($attr->{href} =~ m/\/level\/4\/people/)
		{
		    if ($self->{isDirector} != 0)
		    {
		        $self->{insideDirector} = 1;
			$self->{isDirector} += 1;
		    }
		}
		if ($attr->{href} =~ m/\/level\/10\/m\_act\%5Bgenre\%5D/)
		{
		    $self->{insideGenre} = 1;
		    $self->{isGenre} += 1;
		}					    
            }
            elsif ($tagname eq "td")
	    {
	        if ($attr->{style} eq "padding:10px;padding-left:20px;")
                {
                    $self->{insideSynopsis} = 1;
                }
		elsif ($attr->{style} eq "padding-right:20px;padding-top:10px")
		{
		    $self->{curInfo}->{synopsis} = "нет описания";
		}
		elsif ($attr->{width} eq "35%")
		{
		    $self->{isDirector} = 1;
		}
		elsif ($attr->{class} eq "desc-title")
		{
		    $self->{isTime} = 1;
		}
		elsif ($attr->{class} eq "desc-data" && $self->{isTime} == 2)
		{
	            $self->{insideTime} = 1;
		    $self->{isTime} = 0;
		}
		elsif ($attr->{height} eq "15" && $attr->{align} eq "right")
		{
	            $self->{isActors} += 1;
		    $self->{insideActors} = 1;
		}
	    }
            elsif ($tagname eq "img" && $attr->{style} eq "border-left:10px solid #f60")
            {
                if ($attr->{src} ne "/images/image_none.gif")
		{
		    $self->{curInfo}->{image} = "http://www.kinopoisk.ru".$attr->{src};
		}
            }
    	}
    }

    sub text
    {
        my ($self, $origtext) = @_;
        return if ($self->{parsingEnded});
        if ($self->{parsingList})
        {
            if (($self->{insideHTMLtitle}))
            {
                if ($origtext =~ m/Результаты\sпоиска/)
		{
		#
		}
		else
                {
                    $self->{parsingEnded} = 1;
                    $self->{itemIdx} = 0;
                    $self->{itemsList}[0]->{url} = $self->{loadedUrl};           
                }
                $self->{insideHTMLtitle} = 0;
            }
	    if ($self->{isMovie})
            {
                my ($title, $date);
		$self->{itemsList}[$self->{itemIdx}]->{title} = $origtext;
                $self->{isMovie} = 0;
                return;
            }
	    elsif ($self->{isYear})
	    {
	        $self->{itemsList}[$self->{itemIdx}]->{date} = $origtext;
		$self->{isYear} = 0;
		return;
	    }
        }
        else
        {
            if ($self->{insideTitle})
            {
	    	$origtext =~ s/\s+$//;
                $self->{curInfo}->{title} = $origtext;
                $self->{insideTitle} = 0;
            }
	    elsif ($self->{insideOriginal})
	    {
		$origtext =~ s/^\s+//;		
		$self->{curInfo}->{original} = $origtext;   
		$self->{insideOriginal} = 0;
	    }
            elsif ($self->{insideDate})
            {
		$self->{curInfo}->{date} = $origtext;
		$self->{insideDate} = 0;
            }
            elsif ($self->{insideCountry})
            {
		$self->{curInfo}->{country} = $origtext;
		$self->{insideCountry} = 0;
            }	    
            elsif ($self->{insideDirector})
            {
                if ($self->{isDirector} == 2)
		{
		    $self->{curInfo}->{director} = $origtext;
		}
		elsif ($self->{isDirector} > 2)
		{
		    $self->{curInfo}->{director} = $self->{curInfo}->{director}.", ".$origtext;
		}
                $self->{insideDirector} = 0;
            }
	    elsif ($self->{insideActors})
	    {
                if ($self->{isActors} == 1)
		{
		    $self->{curInfo}->{actors} = $origtext;
		}
		elsif ($self->{isActors} > 1 && $origtext ne "...")
		{
		    $self->{curInfo}->{actors} = $self->{curInfo}->{actors}.", ".$origtext;
		}
                $self->{insideActors} = 0;	    
	    }
            elsif ($self->{insideSynopsis})
            {
		$origtext =~ s/^\s+//;
		$self->{curInfo}->{synopsis} = $origtext;
                $self->{insideSynopsis} = 0;
            }
            elsif ($self->{isTime} == 1)
	    {
                if ($origtext eq "время")
                {
                    $self->{isTime} = 2;
                }		
		else
		{
		    $self->{isTime} = 0;
		}
            }
            elsif ($self->{insideTime})
	    {
	        $self->{curInfo}->{time} = $origtext;
		$self->{insideTime} = 0;		
	    }
            elsif ($self->{insideGenre})
	    {
                if ($self->{isGenre} == 1)
		{
		    $self->{curInfo}->{genre} = $origtext;
		}
		elsif ($self->{isGenre} > 1)
		{
		    $self->{curInfo}->{genre} = $self->{curInfo}->{genre}.", ".$origtext;
		}
		$self->{insideGenre} = 0;		
	    }
        }
    }

    sub end
    {
        my ($self, $tagname) = @_;
        $self->{inside}->{$tagname}--;
        if ($self->{parsingList})
        {
            # Your code for processing search results here
        }
	else
	{
	    if ($tagname eq "tr" && $self->{isDirector} != 0)
	    {
	        $self->{isDirector} = 0;
	    }
	    elsif ($tagname eq "tr" && $self->{isGenre} != 0)
	    {
	        $self->{isGenre} = 0;
	    }	    
	}	
    }

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{hasField} = {
            title => 1,
            date => 1,
            director => 0,
            actors => 0,
        };

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
	$self->{isYear} = 0;
	$self->{isDirector} = 0;
	$self->{isActors} = 0;
	$self->{isTime} = 0;
	$self->{isGenre} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;
	
        return $self;
    }

    sub getName
    {
        return "Kinopoisk";
    }

    sub getAuthor
    {
        return 'Nazarov Pavel';
    }

    sub getLang
    {
        return 'RU';
    }

    sub getCharset
    {
        my $self = shift;
        return "windows-1251";
    }

    sub getSearchUrl
    {
        my ($self, $word) = @_;
        return "http://www.kinopoisk.ru/index.php?kp_query=$word";
    }

    sub getItemUrl
    {
        my ($self, $url) = @_;
	      return $url if $url =~ /^http:/;
        return "http://www.kinopoisk.ru/" . $url;
    }

    sub preProcess
    {
	my ($self, $html) = @_;
	
        $self->{parsingEnded} = 0;
	
        $html =~ s/\x85/\.\.\./g;
        $html =~ s/\x92/'/g;
        $html =~ s/\x93/“/g;
        $html =~ s/\x94/”/g;

        $html =~ s/"&#34;/'"/g;
        $html =~ s/&#34;"/"'/g;
        $html =~ s|</a></b><br>|</a><br>|;

        return $html;
    }

}

1;
