/* Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GCC.

GCC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GCC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to
the Free Software Foundation, 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.  */

/* As a special exception, if you include this header file into source
   files compiled by GCC, this header file does not by itself cause
   the resulting executable to be covered by the GNU General Public
   License.  This exception does not however invalidate any other
   reasons why the executable file might be covered by the GNU General
   Public License.  */

/*
 * Draft C Extension to support decimal floating-pointing arithmetic:  
 * Characteristics of decimal floating types <decfloat.h>
 */

#ifndef _DECFLOAT_H___
#define _DECFLOAT_H___

/* Number of base-FLT_RADIX digits in the significand, p.  */
#undef DEC32_MANT_DIG
#undef DEC64_MANT_DIG
#undef DEC128_MANT_DIG
#define DEC32_MANT_DIG        __DEC32_MANT_DIG__
#define DEC64_MANT_DIG        __DEC64_MANT_DIG__
#define DEC128_MANT_DIG        __DEC128_MANT_DIG__

/* Minimum exponent. */
#undef DEC32_MIN_EXP
#undef DEC64_MIN_EXP
#undef DEC128_MIN_EXP
#define DEC32_MIN_EXP        __DEC32_MIN_EXP__
#define DEC64_MIN_EXP        __DEC64_MIN_EXP__
#define DEC128_MIN_EXP        __DEC128_MIN_EXP__

/* Maximum exponent. */
#undef DEC32_MAX_EXP
#undef DEC64_MAX_EXP
#undef DEC128_MAX_EXP
#define DEC32_MAX_EXP        __DEC32_MAX_EXP__
#define DEC64_MAX_EXP        __DEC64_MAX_EXP__
#define DEC128_MAX_EXP        __DEC128_MAX_EXP__

/* Maximum representable finite decimal floating-point number
   (there are 6, 15, and 33 9s after the decimal points respectively). */
#undef DEC32_MAX
#undef DEC64_MAX
#undef DEC128_MAX
#define DEC32_MAX   __DEC32_MAX__
#define DEC64_MAX   __DEC64_MAX__
#define DEC128_MAX  __DEC128_MAX__

/* The difference between 1 and the least value greater than 1 that is
   representable in the given floating point type. */
#undef DEC32_EPSILON
#undef DEC64_EPSILON
#undef DEC128_EPSILON
#define DEC32_EPSILON        __DEC32_EPSILON__
#define DEC64_EPSILON        __DEC64_EPSILON__
#define DEC128_EPSILON        __DEC128_EPSILON__

/* Minimum normalized positive floating-point number. */
#undef DEC32_MIN
#undef DEC64_MIN
#undef DEC128_MIN
#define DEC32_MIN        __DEC32_MIN__
#define DEC64_MIN        __DEC64_MIN__
#define DEC128_MIN        __DEC128_MIN__

/* Minimum denormalized positive floating-point number. */
#undef DEC32_DEN
#undef DEC64_DEN
#undef DEC128_DEN
#define DEC32_DEN       __DEC32_DEN__
#define DEC64_DEN       __DEC64_DEN__
#define DEC128_DEN      __DEC128_DEN__

/* The floating-point expression evaluation method.
         -1  indeterminate
         0  evaluate all operations and constants just to the range and
            precision of the type
         1  evaluate operations and constants of type _Decimal32 
            and _Decimal64 to the range and precision of the _Decimal64 
            type, evaluate _Decimal128 operations and constants to the 
            range and precision of the _Decimal128 type;
         2  evaluate all operations and constants to the range and
            precision of the _Decimal128 type.
*/

#undef DECFLT_EVAL_METHOD
#define DECFLT_EVAL_METHOD        __DECFLT_EVAL_METHOD__

#endif /* _DECFLOAT_H___ */
