/*
 * Gnome-biff program
 * Version:  2.6
 * Copyright (C) 2000-2001  Nicolas Rougier
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include <gtk/gtk.h>

#ifndef __GBIFF_H
#define __GBIFF_H

/********************
 * HACKS (see README)
 ********************/
/* Uncomment the line below if you experienced window placement problems */
/* #define HACK_WM */
#define WM_DECORATION_WIDTH	4
#define WM_DECORATION_HEIGHT	24



/************
 * Constants
 ************/
#define PROTOCOL_FILE		0
#define PROTOCOL_POP3		1
#define PROTOCOL_IMAP4		2
#define PROTOCOL_MAILDIR	3
#define PROTOCOL_MH		4

#define SOUND_SELECTION_MODE	0
#define ADDRESS_SELECTION_MODE	1
#define MAIL_SELECTION_MODE	2
#define NOMAIL_SELECTION_MODE	3

#define APPLET_VERTICAL		0
#define APPLET_HORIZONTAL	1

#define NUMBER_INDEX		0
#define SENDER_INDEX		1
#define FROM_INDEX		2
#define DATE_INDEX		3
#define STATUS_INDEX		4
#define HEADER_FIELD_NUMBER	5


/* These are unset options for being able to handle gnome session and command line options */
#define UNSET_TITLE			((char *) -1)
#define UNSET_PROTOCOL			-1
#define UNSET_ADDRESS			((char *) -1)
#define UNSET_USER			((char *) -1)
#define UNSET_PASSWORD			((char *) -1)
#define	UNSET_POLLTIME			-1
#define	UNSET_POPTIME			-1
#define UNSET_GEOM_POP_X		-16000
#define UNSET_GEOM_POP_Y		-16000
#define UNSET_GEOM_WIN_X		-16000
#define UNSET_GEOM_WIN_Y		-16000
#define UNSET_OPT_NO_POPUP		-1
#define UNSET_OPT_NO_TITLE		-1
#define UNSET_OPT_NO_DATE		-1
#define UNSET_OPT_NO_SOUND		-1
#define UNSET_OPT_NO_CONFIGURE		-1
#define UNSET_SOUND			((char *) -1)
#define UNSET_FONT			((char *) -1)
#define UNSET_MAIL_PIXMAP_FILENAME	((char *) -1)
#define UNSET_NOMAIL_PIXMAP_FILENAME	((char *) -1)


#define DEFAULT_TITLE			"gbiff"
#define DEFAULT_PROTOCOL		PROTOCOL_FILE
#define	DEFAULT_POLLTIME		60
#define	DEFAULT_POPTIME			5
#define DEFAULT_GEOM_POP_X		-1
#define DEFAULT_GEOM_POP_Y		0
#define DEFAULT_GEOM_WIN_X		-1
#define DEFAULT_GEOM_WIN_Y		-1
#define DEFAULT_OPT_NO_POPUP		0
#define DEFAULT_OPT_NO_TITLE		0
#define DEFAULT_OPT_NO_DATE		0
#define DEFAULT_OPT_NO_SOUND		0
#define DEFAULT_OPT_NO_CONFIGURE	0
#define DEFAULT_SOUND			PACKAGE_DATA_DIR"/sounds/gbiff/mail.wav"
#define DEFAULT_FONT			"-adobe-times-medium-r-normal-*-*-100-*-*-p-*-iso8859-1"
#ifdef USE_GNOME
#define DEFAULT_MAIL_PIXMAP_FILENAME	PACKAGE_DATA_DIR"/pixmaps/gbiff/gnome-mail.xpm"
#define DEFAULT_NOMAIL_PIXMAP_FILENAME	PACKAGE_DATA_DIR"/pixmaps/gbiff/gnome-nomail.xpm"
#else
#define DEFAULT_MAIL_PIXMAP_FILENAME	PACKAGE_DATA_DIR"/pixmaps/gbiff/gtk-mail.xpm"
#define DEFAULT_NOMAIL_PIXMAP_FILENAME	PACKAGE_DATA_DIR"/pixmaps/gbiff/gtk-nomail.xpm"
#endif

#define DEFAULT_POP3_PORT		110
#define DEFAULT_IMAP4_PORT		143


#define MAX_HEADER_IN_POPUP		100


/****************************
 * Biff structure definition
 ****************************/
typedef struct _biff {
  char *	title;
  int		protocol;
  char *	address;
  char *	user;
  char *	password;
  int		polltime;
  int		poptime;
  int		popupX;
  int		popupY;
  int		windowX;
  int		windowY;
  int		optNoPopup;
  int		optNoTitle;
  int		optNoDate;
  int		optNoSound;
  int		optNoConfigure;
  char *	sound;
  char *	font;
  char *	mailPixmapFilename;
  char *	nomailPixmapFilename;
  
  char		*headers[MAX_HEADER_IN_POPUP][HEADER_FIELD_NUMBER];
  int		unread;
  int		total;
  int		popupState;
  int		selectionMode;
  int 		suspendMode;
  int		polltag;
  int		poptag;

  int		size;
  int		orient;
  
  GtkWidget *	applet;
  GtkWidget *	window;
  GtkWidget *	about;
  GtkWidget *	mailbox;
  GtkWidget *	popup;
  GtkWidget *	fileDialog;
  GtkWidget *	fontDialog;
  GdkPixmap *	mailGdkPixmap;
  GdkPixmap *	nomailGdkPixmap;
} Biff;


int main (int argc, char **argv);
void parseCommandLine (int argc, char **argv, Biff *biff);
void setDefaultParameters (Biff *biff);
void initializeMailbox (Biff *biff);

#endif /* __GBIFF_H */
