/* Gnome BibTeX containers.C
 *    Alejandro Aguilar Sierra <asierra@servidor.unam.mx>
 *    Felipe Bergo <bergo@seul.org>
 * 
 *    This program is free software; you can redistribute it and'or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2, or (at your option)
 *    any later version.
 */

#include <iostream.h>
#include <map.h>
#include <vector.h>
#include <std/bastring.h>
#include <algorithm>
#include <string.h>
#include <stdio.h>
#include "gbib.h"

#include <ctype.h>
int nstyles = 0;
char *bibstyle;

map<string, ApBibEntryDef, less<string> > entrydefs;

// Just to store the entrydef names, for some reason unaccesible from map
vector_string entrydefTab;

//
vector_string fieldNameTab;

//
vector_string extraFieldNameTab;

vector_string commandTab;


static void Stolower(char *s) {
   for (int i=0; s[i] > ' '; i++)
     s[i] = tolower(s[i]);
}


static void Stoupper(char *s) {
   for (int i=0; s[i] > ' '; i++)
     s[i] = toupper(s[i]);
}


static
int get_fieldname_idx(char * n) 
{
    for (unsigned int i=0; i<fieldNameTab.size(); i++) {
	if (strcmp(n, fieldNameTab[i].c_str())==0) {
	    return i;
	}
    }
    
    return -1;
}


static
int insert_fieldname(char * n) 
{
    for (unsigned int i=0; i<fieldNameTab.size(); i++) {
	if (strcmp(n, fieldNameTab[i].c_str())==0) {
	    return i;
	}
    } 
    
    fieldNameTab.push_back(n);
	
    return fieldNameTab.size() - 1;
}


void new_entrydef(char* name, char* required, char* optional)
{
    int i, rl, ol;
    BibEntryDef *def = new BibEntryDef;
    char *aux;
    char s[250];
    int iaux[100];
    
    for(i=0;i<strlen(name);i++)
      name[i]=tolower(name[i]);

    //    cerr << "newdef: " << name << endl;

    def->name = name;
    rl = strlen(required);
    ol = strlen(optional);
    
    // Number of required entries
    def->nreq = 0;
    strcpy(s, required);    
    //    cerr << "required " << required << "\n";
    if (rl > 0) {
	aux = &s[0];
	for (i=0; i < rl; i++) {	    
	    if (required[i] == ' ' || required[i] == '\0') {
		s[i] = '\0';
		iaux[def->nreq++] = insert_fieldname(aux);
		aux = &s[i+1];
	    }
	}
	iaux[def->nreq++] = insert_fieldname(aux);
	def->required = new int[def->nreq];
	for (i=0; i < def->nreq; i++) 	    
	  def->required[i] = iaux[i];
    }

    // Number of optional entries    
    def->nopt = 0;    
    strcpy(s, optional);
    //    cerr << "optional " << optional << "\n";
    if (ol > 0) {
	aux = &s[0];
	for (i=0; i < ol; i++) {
	    if (optional[i] == ' ' || optional[i] == '\0') {
		s[i] = '\0';
		iaux[def->nopt++] = insert_fieldname(aux);
		aux = &s[i+1];
	    }
	}	
	iaux[def->nopt++] = insert_fieldname(aux);
	def->optional = new int[def->nopt];
	for (i=0; i < def->nopt; i++) 	    
	  def->optional[i] = iaux[i];
    }

    entrydefs[name] = def;
    entrydefTab.push_back(def->name);
    //    cerr << "newdef: [" << name << "]\n";
}


void new_bibstyles(char* s) 
{
    int l;
    
    l = strlen(s);
    bibstyle = new char[l+1];

    if (l > 0) {
	int i;
	
	nstyles = 1;
	for (i=0; i < l; i++) {
	    if (s[i] == ' ') {
		bibstyle[i] = '\0';
		nstyles++;
	    } else 
	      bibstyle[i] = (unsigned char)s[i];
	}
	bibstyle[i] = '\0';
    } else  
      nstyles = 0;
}


BibEntryDef *getBibEntryDef(char *n)
{
    int i;
    char s[255];
    
    // Non-case sensitive
    for (i=0; n[i] > ' '; i++)
	s[i] = tolower(n[i]);
    s[i] = '\0';
    
    if (entrydefs.find(s) != entrydefs.end()) {
	return entrydefs[s];
    }

    //    cerr << "didn't find1 [" << s << "]" << endl;
    //    cerr << "didn't find2 [" << n << "]" << endl;
    return 0;
}



char *BibEntryDef::getRequired(int i)
{
    if (i > nreq || i < 0) 
      return 0;
    
    return( Unconst::copy(fieldNameTab[required[i]].c_str()) );
}


char *BibEntryDef::getOptional(int i)
{ 
    if (i > nopt || i < 0) 
      return 0;
    
    return( Unconst::copy(fieldNameTab[optional[i]].c_str()) );
}


int BibEntryDef::getFieldIdx(char *fx)
{
    int k = get_fieldname_idx(fx);

    if (k >= 0) {
	for (int i=0; i < nreq; i++)
	  if (k == required[i])
	    return i;
		
	for (int i=0; i < nopt; i++)
	  if (k == optional[i])
	    return i+nreq;
    }

    return -1;
}


char *get_entrytype_name(int i)
{
  unsigned int ui;
  ui=(unsigned int)i;
  if (0 <= ui && ui < entrydefTab.size()) {
    return ( Unconst::copy(entrydefTab[ui].c_str()));
  }
  
  return 0;
}   


char *get_bibtex_style(int i)
{
        if (0 <= i && i < nstyles) {
	    int k=0, j=0;
	    
	    for (k=0; j<i; k++) { 
	      if (bibstyle[k]=='\0') {
		  j++;
	      }
	    }
	    return &bibstyle[k];
	}
    
        return 0;
}


int set_globalfield_name(char *n)
{
    string name = n;
    
    // return the corresponding index if the name already exists
    for (unsigned int i=0; i<fieldNameTab.size(); i++) {
	if (name == fieldNameTab[i]) {
	    return i;
	}
    }
    
    for (unsigned int i=0; i<extraFieldNameTab.size(); i++) {
	if (name == extraFieldNameTab[i]) {
	    return i + fieldNameTab.size();
	}
    }

    // it doesn't exist
    extraFieldNameTab.push_back(name);
   
   return fieldNameTab.size() + extraFieldNameTab.size() - 1; 
}
 

char *get_globalfield_name(int idx)
{
  unsigned int ui;
  ui=(unsigned int)idx;
    if (ui < fieldNameTab.size())
      return (Unconst::copy(fieldNameTab[ui].c_str()));
    
    ui -= fieldNameTab.size();
    
    if (ui < extraFieldNameTab.size())
      return (Unconst::copy(extraFieldNameTab[ui].c_str()));
    
    return 0;
}


void new_commands(char* s) 
{
   int i, l;
   char *sx;
   
   l = strlen(s);
   
   if (l > 0) {
      sx = &s[0];
      for (i=0; i < l; i++) {
	 if (s[i] == ' ') {
	    s[i] = '\0';
	    Stoupper(sx);
	    commandTab.push_back(sx);
	    sx = &s[i+1];
	 }
      }
      s[i] = '\0';
      Stoupper(sx);
      commandTab.push_back(sx);
   }
}

bool isCommand(char *n) {
   
   vector_string::iterator result;

   Stoupper(n);

   result = find(commandTab.begin(), commandTab.end(), n);

   return (result != commandTab.end());
}

