/***************************************************************************

  CLabel.cpp

  The Label and TextView class

  (c) 2000-2003 Benot Minisini <gambas@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************/

#define __CLABEL_CPP



#include <qapplication.h>
#include <qlabel.h>

#include "gambas.h"

#include "CLabel.h"

/*#define DEBUG_CBUTTON*/


BEGIN_METHOD(CLABEL_new, GB_OBJECT parent)

  QLabel *wid = new QLabel(CONTAINER(VARG(parent)));

  CWIDGET_new(wid, (void *)_object, "Label");

  wid->setTextFormat(Qt::PlainText);
  wid->setAlignment(Qt::AlignAuto + Qt::AlignVCenter); // + Qt::WordBreak);
  //wid->setLineWidth(2);
  wid->show();

END_METHOD


BEGIN_METHOD(CTEXTLABEL_new, GB_OBJECT parent)

  QLabel *wid = new QLabel(CONTAINER(VARG(parent)));

  CWIDGET_new(wid, (void *)_object, "TextView");

  wid->setTextFormat(Qt::RichText);
  wid->setAlignment(Qt::AlignAuto + Qt::AlignTop + Qt::WordBreak);
  //wid->setLineWidth(2);
  wid->show();

END_METHOD


BEGIN_PROPERTY(CLABEL_text)

  if (READ_PROPERTY)
    GB.ReturnNewZeroString(TO_UTF8(WIDGET->text()));
  else
    WIDGET->setText(QSTRING_PROP());

END_PROPERTY


BEGIN_PROPERTY(CLABEL_alignment)

  if (READ_PROPERTY)
    GB.ReturnInteger(WIDGET->alignment() & ALIGN_MASK);
  else
    WIDGET->setAlignment((VPROP(GB_INTEGER) & ALIGN_MASK));

END_PROPERTY


BEGIN_PROPERTY(CTEXTLABEL_alignment)

  if (READ_PROPERTY)
    GB.ReturnInteger(WIDGET->alignment() & ALIGN_MASK);
  else
    WIDGET->setAlignment((VPROP(GB_INTEGER) & ALIGN_MASK) | Qt::WordBreak);

END_PROPERTY



GB_DESC CLabelDesc[] =
{
  GB_DECLARE("Label", sizeof(CLABEL)), GB_INHERITS("Control"),

  GB_METHOD("_new", NULL, CLABEL_new, "(Parent)Container;"),

  GB_PROPERTY("Text", "s", CLABEL_text),
  GB_PROPERTY("Caption", "s", CLABEL_text),
  GB_PROPERTY("Alignment", "i<Align>", CLABEL_alignment),
  GB_PROPERTY("Border", "i<Border>", CWIDGET_border_full),

  GB_CONSTANT("_Properties", "s", CLABEL_PROPERTIES),

  GB_END_DECLARE
};


GB_DESC CTextViewDesc[] =
{
  GB_DECLARE("TextLabel", sizeof(CLABEL)), GB_INHERITS("Control"),

  GB_METHOD("_new", NULL, CTEXTLABEL_new, "(Parent)Container;"),

  GB_PROPERTY("Text", "s", CLABEL_text),
  GB_PROPERTY("Caption", "s", CLABEL_text),
  GB_PROPERTY("Alignment", "i<Align>", CTEXTLABEL_alignment),
  GB_PROPERTY("Border", "i<Border>", CWIDGET_border_full),

  GB_CONSTANT("_Properties", "s", CLABEL_PROPERTIES),

  GB_END_DECLARE
};



