/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.util;

import com.gallery.GalleryRemote.Log;
import java.io.IOException;

public class OsShutdown {
    public static final String MODULE = "Shutdown";
    public static final String osname = System.getProperty("os.name").toLowerCase();

    public static void shutdown() {
        String win9x = "rundll32 user,exitwindows";
        String winNT = "shutdown -s -f -t 01";
        String unix = "shutdown -fh now";
        String cmd = null;
        if (OsShutdown.isWin9x()) {
            cmd = win9x;
        } else if (OsShutdown.isWinNT()) {
            cmd = winNT;
        } else if (OsShutdown.isUnix()) {
            cmd = unix;
        } else {
            Log.log((int)1, (String)MODULE, (String)"Platform not recognized; shutdown will not be performed");
        }
        try {
            if (cmd != null) {
                Log.log((int)3, (String)MODULE, (String)("Executing " + cmd));
                Runtime.getRuntime().exec(cmd);
            }
        }
        catch (IOException io) {
            Log.logException((int)1, (String)MODULE, (Throwable)io);
        }
    }

    public static boolean isWindows() {
        return osname.indexOf("windows") != -1;
    }

    public static boolean isWin9x() {
        return OsShutdown.isWindows() && (osname.indexOf("9") != -1 || osname.indexOf("me") != -1);
    }

    public static boolean isWinNT() {
        return OsShutdown.isWindows() && !OsShutdown.isWin9x();
    }

    public static boolean isMacOS() {
        return osname.indexOf("mac") != -1 && osname.indexOf("os") != -1;
    }

    public static boolean isMacOSX() {
        return osname.indexOf("mac os x") != -1;
    }

    public static boolean isLinux() {
        return osname.indexOf("linux") != -1;
    }

    public static boolean isSolaris() {
        return osname.indexOf("solaris") != -1;
    }

    public static boolean isUnix() {
        return OsShutdown.isMacOSX() || OsShutdown.isLinux() || OsShutdown.isSolaris();
    }

    public static boolean canShutdown() {
        return OsShutdown.isWin9x() || OsShutdown.isWinNT() || OsShutdown.isUnix() && !OsShutdown.isMacOSX();
    }
}

