#!/usr/bin/env python

import pygtk
pygtk.require('2.0')
import gtk
import galago
import galago.gtk
import sys

class ChooserTest(gtk.Window):
    def __init__(self):
        gtk.Window.__init__(self, gtk.WINDOW_TOPLEVEL)
        self.contact_list = None

        self.set_title("Galago Chooser Test")
        self.set_border_width(12)

        vbox = gtk.VBox(False, 6)
        vbox.show()
        self.add(vbox)

        sw = gtk.ScrolledWindow()
        sw.show()
        vbox.pack_start(sw, True, True, 0)
        sw.set_shadow_type(gtk.SHADOW_IN)

        self.contact_list = galago.gtk.ContactList(False)
        self.contact_list.show()
        sw.add(self.contact_list)

        bbox = gtk.HButtonBox()
        bbox.show()
        vbox.pack_start(bbox, False, True, 0)
        bbox.set_layout(gtk.BUTTONBOX_END)

        add_button = gtk.Button(stock=gtk.STOCK_ADD)
        add_button.show()
        bbox.pack_start(add_button, False, False, 0)
        add_button.connect("clicked", self.add_clicked_cb)

    def response_cb(self, chooser, response_id):
        if response_id == gtk.RESPONSE_ACCEPT:
            self.contact_list.add_contact(chooser.get_contact())

        chooser.destroy()

    def add_clicked_cb(self, button):
        dialog = galago.gtk.ContactChooserDialog(
            "Select a Contact", self,
            galago.gtk.CONTACT_CHOOSER_SELECT_CONTACTS,
            (gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT,
             gtk.STOCK_ADD,    gtk.RESPONSE_ACCEPT))
        dialog.show()
        dialog.connect("response", self.response_cb)


if __name__ == "__main__":
    if not galago.init("test-chooser"):
        sys.exit(1)

    win = ChooserTest()
    win.show()
    win.connect("destroy", gtk.main_quit)

    gtk.main()
